/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.nodes.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.uml.project.ui.nodes.actions.INewTypeExt;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.windows.WindowManager;

public class UMLNewAction
extends NodeAction {
    private static ActSubMenuModel model = new ActSubMenuModel(null);

    protected void performAction(Node[] nodeArray) {
        UMLNewAction.performAction(nodeArray, 0);
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performAction(Node[] nodeArray, int n) {
        NewType[] newTypeArray = UMLNewAction.getNewTypes(nodeArray);
        if (newTypeArray.length <= n) {
            return;
        }
        NewType newType = newTypeArray[n];
        try {
            newType.create();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static NewType[] getNewTypes() {
        return UMLNewAction.getNewTypes(WindowManager.getDefault().getRegistry().getCurrentNodes());
    }

    private static NewType[] getNewTypes(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return new NewType[0];
        }
        return nodeArray[0].getNewTypes();
    }

    protected boolean enable(Node[] nodeArray) {
        NewType[] newTypeArray = UMLNewAction.getNewTypes();
        UMLNewAction.model.cs.fireChange();
        return newTypeArray.length > 0;
    }

    public String getName() {
        return UMLNewAction.createName(UMLNewAction.getNewTypes());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(UMLNewAction.class);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu((SystemAction)this, (Actions.SubMenuModel)model, true);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    private static String createName(NewType[] newTypeArray) {
        return NbBundle.getMessage(UMLNewAction.class, (String)"LBL_New_Menu", (Object)"");
    }

    private static class CustomedMenuItem
    extends Actions.SubMenu {
        private Actions.SubMenuModel model;
        private List<JMenuItem> menuList = new ArrayList<JMenuItem>();
        private JMenu aMenu;
        Action action;

        public CustomedMenuItem(Action action, Actions.SubMenuModel subMenuModel, boolean bl) {
            super(action, subMenuModel, bl);
            this.model = subMenuModel;
            this.action = action;
        }

        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(null);
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            int n;
            this.menuList.clear();
            if (this.model != null && (n = this.model.getCount()) > 0) {
                JMenuItem jMenuItem = null;
                this.aMenu = new JMenu();
                Mnemonics.setLocalizedText((AbstractButton)this.aMenu, (String)((String)this.action.getValue("Name")));
                for (int i = 0; i < n; ++i) {
                    String string = this.model.getLabel(i);
                    String string2 = ((ActSubMenuModel)this.model).getIconResource(i);
                    if (string == null) continue;
                    jMenuItem = new JMenuItem();
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)string);
                    if (string2 != null) {
                        ImageIcon imageIcon = new ImageIcon(Utilities.loadImage((String)string2));
                        jMenuItem.setIcon(imageIcon);
                    }
                    jMenuItem.addActionListener(new SubActionListener(i, this.model));
                    this.aMenu.add(jMenuItem);
                }
                this.aMenu.setEnabled(true);
                this.menuList.add(this.aMenu);
            }
            return this.menuList.toArray(new JMenuItem[this.menuList.size()]);
        }

        private static class SubActionListener
        implements ActionListener {
            int index;
            Actions.SubMenuModel model;

            public SubActionListener(int n, Actions.SubMenuModel subMenuModel) {
                this.index = n;
                this.model = subMenuModel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.model.performActionAt(this.index);
            }
        }
    }

    private static final class DelegateAction
    extends AbstractAction
    implements Presenter.Popup {
        private final NodeAction delegate;
        private final ActSubMenuModel model;

        public DelegateAction(NodeAction nodeAction, Lookup lookup) {
            this.delegate = nodeAction;
            this.model = new ActSubMenuModel(lookup);
            this.putValue("Name", UMLNewAction.createName(this.model.newTypes()));
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.model.performActionAt(0);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public Object getValue(String string) {
            if ("Name".equals(string)) {
                return UMLNewAction.createName(this.model.newTypes());
            }
            return this.delegate.getValue(string);
        }

        public boolean isEnabled() {
            return this.model.getCount() > 0;
        }

        public JMenuItem getPopupPresenter() {
            CustomedMenuItem customedMenuItem = new CustomedMenuItem(this, this.model, true);
            return customedMenuItem;
        }
    }

    private static class ActSubMenuModel
    implements Actions.SubMenuModel {
        static final long serialVersionUID = -1L;
        final ChangeSupport cs = new ChangeSupport((Object)this);
        private Lookup lookup;
        private Node prevNode;
        private NewType[] prevTypes;

        ActSubMenuModel(Lookup lookup) {
            this.lookup = lookup;
        }

        private NewType[] newTypes() {
            Collection collection;
            if (this.lookup != null && (collection = this.lookup.lookupResult(Node.class).allItems()) != null && collection.size() == 1) {
                for (Lookup.Item item : collection) {
                    Node node = (Node)item.getInstance();
                    if (node == null) continue;
                    if (node == this.prevNode && this.prevTypes != null) {
                        return this.prevTypes;
                    }
                    this.prevNode = node;
                    this.prevTypes = node.getNewTypes();
                    return this.prevTypes;
                }
            }
            return UMLNewAction.getNewTypes();
        }

        public int getCount() {
            return this.newTypes().length;
        }

        public String getLabel(int n) {
            NewType[] newTypeArray = this.newTypes();
            if (newTypeArray == null || newTypeArray.length <= n) {
                return null;
            }
            return newTypeArray[n].getName();
        }

        public String getIconResource(int n) {
            String string = null;
            NewType[] newTypeArray = this.newTypes();
            if (newTypeArray != null && newTypeArray.length > n) {
                NewType newType = newTypeArray[n];
                string = newType instanceof INewTypeExt ? ((INewTypeExt)newType).getIconResource() : null;
            }
            return string;
        }

        public HelpCtx getHelpCtx(int n) {
            NewType[] newTypeArray = this.newTypes();
            if (newTypeArray == null || newTypeArray.length <= n) {
                return null;
            }
            return newTypeArray[n].getHelpCtx();
        }

        public void performActionAt(int n) {
            NewType[] newTypeArray = this.newTypes();
            if (newTypeArray == null || newTypeArray.length <= n) {
                return;
            }
            Node[] nodeArray = this.lookup != null ? this.lookup.lookupAll(Node.class).toArray(new Node[0]) : WindowManager.getDefault().getRegistry().getCurrentNodes();
            UMLNewAction.performAction(nodeArray, n);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }
    }
}

