/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.project.ui.customizer.UMLImportsUiSupport;
import org.netbeans.modules.uml.project.ui.nodes.ImportProjectRootNode;
import org.netbeans.modules.uml.project.ui.nodes.ModelRootNodeCookie;
import org.netbeans.modules.uml.project.ui.nodes.UMLDiagramsRootNode;
import org.netbeans.modules.uml.project.ui.nodes.UMLElementNode;
import org.netbeans.modules.uml.project.ui.nodes.UMLLogicalViewCookie;
import org.netbeans.modules.uml.project.ui.nodes.UMLModelRootNode;
import org.netbeans.modules.uml.project.ui.nodes.actions.NewDiagramType;
import org.netbeans.modules.uml.project.ui.nodes.actions.NewElementType;
import org.netbeans.modules.uml.project.ui.nodes.actions.NewPackageType;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProduct;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.NewType;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class UMLPhysicalViewProvider
implements LogicalViewProvider {
    private static final RequestProcessor BROKEN_LINKS_RP = new RequestProcessor("UMLPhysicalViewProvider.BROKEN_LINKS_RP");
    private static final RequestProcessor rp = new RequestProcessor();
    private final UMLProject mProject;
    private final UMLProjectHelper mHelper;
    private final SubprojectProvider mSubProjetProvider;
    private final PropertyEvaluator evaluator;
    private final UMLImportsUiSupport mImportSupport;
    private UMLLogicalViewRootNode node;
    private WeakReference<UMLLogicalViewRootNode> nodeWeakRef;
    private ReferenceHelper mResolver = null;
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"uml.javaproject", "uml.javaproject.artifacts", "uml.javaproject.src"};
    private static Image brokenProjectBadge = Utilities.loadImage((String)"org/netbeans/modules/uml/resources/images/broken-project-badge.gif");

    public UMLPhysicalViewProvider(UMLProject uMLProject, UMLProjectHelper uMLProjectHelper, PropertyEvaluator propertyEvaluator, SubprojectProvider subprojectProvider, UMLImportsUiSupport uMLImportsUiSupport, ReferenceHelper referenceHelper) {
        this.mProject = uMLProject;
        assert (this.mProject != null) : "Project can not be NULL";
        this.mHelper = uMLProjectHelper;
        assert (this.mHelper != null) : "Helper can not be NULL";
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.mSubProjetProvider = subprojectProvider;
        assert (subprojectProvider != null) : "SubprojectProvider can not be NULL";
        this.mImportSupport = uMLImportsUiSupport;
        assert (uMLImportsUiSupport != null) : "UMLImportsUiSupport can not be NULL";
        this.mResolver = referenceHelper;
        assert (referenceHelper != null) : "ReferenceHelper can not be NULL";
    }

    public Node createLogicalView() {
        if (this.node == null) {
            UMLLogicalViewRootNode uMLLogicalViewRootNode;
            if (this.nodeWeakRef != null && (uMLLogicalViewRootNode = (UMLLogicalViewRootNode)this.nodeWeakRef.get()) != null) {
                this.node = uMLLogicalViewRootNode;
            }
            if (this.node == null) {
                this.node = new UMLLogicalViewRootNode();
            }
        }
        this.nodeWeakRef = null;
        return this.node;
    }

    public void detachLogicalView() {
        if (this.node != null) {
            this.nodeWeakRef = new WeakReference<UMLLogicalViewRootNode>(this.node);
        }
        this.node = null;
    }

    public Node findPath(Node node, Object object) {
        return null;
    }

    public void testBroken() {
    }

    public boolean hasBrokenLinks() {
        boolean bl = false;
        bl = BrokenReferencesSupport.isBroken((AntProjectHelper)this.mHelper.getAntProjectHelper(), (ReferenceHelper)this.mResolver, (String[])this.getBreakableProperties(), (String[])new String[0]);
        return bl;
    }

    private String[] getBreakableProperties() {
        return BREAKABLE_PROPERTIES;
    }

    public ModelRootNodeCookie getModelRootNodeCookie() {
        return ((UMLLogicalViewRootNode)this.createLogicalView()).getModelRootNodeCookie();
    }

    public UMLModelRootNode getModelRootNode() {
        return ((UMLLogicalViewRootNode)this.createLogicalView()).getModelRootNode();
    }

    protected void addContextMenus(List list) {
        Action[] actionArray;
        UMLElementNode uMLElementNode = new UMLElementNode();
        for (Action action : actionArray = uMLElementNode.getActionsFromRegistry("Actions/UML/Search")) {
            if (action == null) {
                list.add(null);
                continue;
            }
            if (!action.isEnabled()) continue;
            list.add(action);
        }
        list.add(null);
        for (Action action : actionArray = uMLElementNode.getActionsFromRegistry("contextmenu/uml/generate")) {
            if (action == null) {
                list.add(null);
                continue;
            }
            if (!action.isEnabled()) continue;
            list.add(action);
        }
    }

    private static final class LogicalViewChildren
    extends Children.Keys
    implements ChangeListener {
        private static final Object UML_MODEL = "Model";
        private static final Object UML_DIAGRAMS = "Diagrams";
        private static final Object UML_IMPORTED_PROJECTS = "Imported Projects";
        private final UMLProject project;
        private final PropertyEvaluator evaluator;
        private final UMLProjectHelper helper;
        private final UMLImportsUiSupport mImportSupport;
        private Node mModelNode = null;
        private Node mDiagramNode = null;
        private ImportProjectRootNode mImportedNode = null;

        public LogicalViewChildren(UMLProject uMLProject, UMLProjectHelper uMLProjectHelper, PropertyEvaluator propertyEvaluator, UMLImportsUiSupport uMLImportsUiSupport) {
            this.project = uMLProject;
            this.evaluator = propertyEvaluator;
            this.helper = uMLProjectHelper;
            this.mImportSupport = uMLImportsUiSupport;
        }

        protected void addNotify() {
            super.addNotify();
            this.getSources().addChangeListener((ChangeListener)this);
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.getSources().removeChangeListener((ChangeListener)this);
            super.removeNotify();
        }

        protected synchronized Node getModelRootNode() {
            if (this.mModelNode == null) {
                this.mModelNode = new UMLModelRootNode(this.project, this.helper, this.evaluator);
            }
            return this.mModelNode;
        }

        protected synchronized Node getDiagramRootNode() {
            if (this.mDiagramNode == null) {
                this.mDiagramNode = new UMLDiagramsRootNode(this.project, this.helper, this.evaluator);
            }
            return this.mDiagramNode;
        }

        protected synchronized ImportProjectRootNode getImportsRootNode() {
            if (this.mImportedNode == null) {
                this.mImportedNode = new ImportProjectRootNode(this.helper);
            }
            return this.mImportedNode;
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray;
            if (object == UML_MODEL) {
                nodeArray = new Node[]{this.getModelRootNode()};
            } else if (object == UML_DIAGRAMS) {
                nodeArray = new Node[]{this.getDiagramRootNode()};
            } else if (object == UML_IMPORTED_PROJECTS) {
                ImportProjectRootNode importProjectRootNode = this.getImportsRootNode();
                this.mImportSupport.addImportElementListener(importProjectRootNode);
                nodeArray = new Node[]{importProjectRootNode};
            } else {
                assert (false) : "Unknown key type";
                nodeArray = new Node[]{};
            }
            return nodeArray;
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }

        private Collection getKeys() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(UML_MODEL);
            arrayList.add(UML_DIAGRAMS);
            arrayList.add(UML_IMPORTED_PROJECTS);
            return arrayList;
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }

    private final class UMLLogicalViewRootNode
    extends AbstractNode
    implements UMLLogicalViewCookie {
        private Image icon;
        private Lookup lookup;
        private Action brokenLinksAction;
        private boolean broken;

        public UMLLogicalViewRootNode() {
            super((Children)new LogicalViewChildren(UMLPhysicalViewProvider.this.mProject, UMLPhysicalViewProvider.this.mHelper, UMLPhysicalViewProvider.this.evaluator, UMLPhysicalViewProvider.this.mImportSupport), Lookups.singleton((Object)UMLPhysicalViewProvider.this.mProject));
            this.setIconBaseWithExtension("org/netbeans/modules/uml/resources/images/uml-project.png");
            this.setName(ProjectUtils.getInformation((Project)UMLPhysicalViewProvider.this.mProject).getDisplayName());
            if (UMLPhysicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            return this.broken ? Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0) : image;
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return this.broken ? Utilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0) : image;
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
            return this.broken ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return true;
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UMLPhysicalViewProvider.class, (String)"MSG_ConfirmDeleteProject", (Object)UMLPhysicalViewProvider.this.mProject.getName(), (Object)UMLPhysicalViewProvider.this.mProject.getProjectDirectory().getPath()), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION) {
                UMLPhysicalViewProvider.this.mProject.removeUMLProjectMetaListener();
                this.closeDiagramsWithoutSave();
                Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        OpenProjects.getDefault().close(new Project[]{UMLPhysicalViewProvider.this.mProject});
                        return null;
                    }
                });
                UMLPhysicalViewProvider.this.mHelper.getProjectDirectory().delete();
            }
        }

        private void closeDiagramsWithoutSave() {
            ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
            if (iCoreProduct instanceof IProduct) {
                IProduct iProduct = (IProduct)iCoreProduct;
                ETList eTList = iProduct.getDiagramManager().getOpenDiagrams();
                for (IProxyDiagram iProxyDiagram : eTList) {
                    IDiagram iDiagram;
                    File file = new File(iProxyDiagram.getFilename());
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) continue;
                    Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                    if (!UMLPhysicalViewProvider.this.mProject.equals(project) || (iDiagram = iProxyDiagram.getDiagram()) == null) continue;
                    iDiagram.setIsDirty(false);
                    iProduct.getDiagramManager().closeDiagram2(iDiagram);
                }
            }
        }

        public Node.Cookie getCookie(Class clazz) {
            Node.Cookie cookie = super.getCookie(clazz);
            if (cookie == null && clazz.isAssignableFrom(UMLLogicalViewCookie.class)) {
                return this;
            }
            return cookie;
        }

        public ModelRootNodeCookie getModelRootNodeCookie() {
            Children children = this.getChildren();
            ModelRootNodeCookie modelRootNodeCookie = null;
            for (int i = 0; i < children.getNodes().length; ++i) {
                modelRootNodeCookie = (ModelRootNodeCookie)children.getNodes()[i].getCookie(ModelRootNodeCookie.class);
                if (modelRootNodeCookie == null) continue;
                return modelRootNodeCookie;
            }
            return null;
        }

        public UMLModelRootNode getModelRootNode() {
            Children children = this.getChildren();
            ModelRootNodeCookie modelRootNodeCookie = null;
            for (int i = 0; i < children.getNodes().length; ++i) {
                modelRootNodeCookie = (ModelRootNodeCookie)children.getNodes()[i].getCookie(ModelRootNodeCookie.class);
                if (modelRootNodeCookie == null) continue;
                return (UMLModelRootNode)children.getNodes()[i];
            }
            return null;
        }

        public NewType[] getNewTypes() {
            return new NewType[]{new NewDiagramType((IElement)UMLPhysicalViewProvider.this.mHelper.getProject()), new NewPackageType((IElement)UMLPhysicalViewProvider.this.mHelper.getProject()), new NewElementType((IElement)UMLPhysicalViewProvider.this.mHelper.getProject())};
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(UMLPhysicalViewProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            try {
                Repository repository = Repository.getDefault();
                FileSystem fileSystem = repository.getDefaultFileSystem();
                FileObject fileObject = fileSystem.findResource("UMLProjects/Actions");
                if (fileObject != null) {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    FolderLookup folderLookup = new FolderLookup((DataObject.Container)((DataFolder)dataObject));
                    Lookup.Template template = new Lookup.Template(Object.class);
                    Lookup lookup = folderLookup.getLookup();
                    for (Object e : lookup.lookup(template).allInstances()) {
                        if (e instanceof Action) {
                            arrayList.add((Action)e);
                            continue;
                        }
                        if (!(e instanceof JSeparator)) continue;
                        arrayList.add(null);
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
            UMLPhysicalViewProvider.this.addContextMenus(arrayList);
            arrayList.add(null);
            if (this.broken) {
                arrayList.add(this.brokenLinksAction);
            }
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private boolean isBroken() {
            return false;
        }

        private void setBroken(boolean bl) {
            this.broken = bl;
            this.brokenLinksAction.setEnabled(bl);
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        Runnable {
            private RequestProcessor.Task task = null;
            private PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                this.putValue("Name", NbBundle.getMessage(UMLPhysicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.setEnabled(UMLLogicalViewRootNode.this.broken);
                UMLPhysicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BrokenReferencesSupport.showCustomizer((AntProjectHelper)UMLPhysicalViewProvider.this.mHelper.getAntProjectHelper(), (ReferenceHelper)UMLPhysicalViewProvider.this.mResolver, (String[])UMLPhysicalViewProvider.this.getBreakableProperties(), (String[])new String[0]);
                UMLPhysicalViewProvider.this.mHelper.scanSourceGroups();
                this.run();
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (this.task == null) {
                    this.task = BROKEN_LINKS_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }

            public synchronized void run() {
                boolean bl = UMLLogicalViewRootNode.this.broken;
                UMLLogicalViewRootNode.this.broken = UMLPhysicalViewProvider.this.hasBrokenLinks();
                if (bl != UMLLogicalViewRootNode.this.broken) {
                    UMLLogicalViewRootNode.this.setBroken(UMLLogicalViewRootNode.this.broken);
                }
            }
        }
    }
}

