/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.customizer.uiapi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.uml.project.ui.customizer.uiapi.CategoryModel;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerPane
extends JPanel
implements HelpCtx.Provider {
    public static final String HELP_CTX_PROPERTY = "helpCtxProperty";
    public static final String OK_ENABLE_PROPERTY = "okEnableProperty";
    private Component currentCustomizer;
    private HelpCtx currentHelpCtx;
    private GridBagConstraints fillConstraints;
    private ProjectCustomizer.CategoryComponentProvider componentProvider;
    private JPanel categoryPanel;
    private JPanel customizerPanel;
    private JLabel jLabel1;
    CategoryPanelChangeListener mListener = new CategoryPanelChangeListener();

    public CustomizerPane(JPanel jPanel, CategoryModel categoryModel, ProjectCustomizer.CategoryComponentProvider categoryComponentProvider) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPane.class, (String)"AD_CustomizerPane"));
        this.componentProvider = categoryComponentProvider;
        this.fillConstraints = new GridBagConstraints();
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.gridheight = 0;
        this.fillConstraints.fill = 1;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        categoryModel.addPropertyChangeListener(new CategoryChangeListener());
        this.categoryPanel.add((Component)jPanel, this.fillConstraints);
        this.setCategory(categoryModel.getCurrentCategory());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.categoryPanel = new JPanel();
        this.customizerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(750, 450));
        this.jLabel1.setLabelFor(this.categoryPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 11, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName("");
        this.jLabel1.getAccessibleContext().setAccessibleDescription("");
        this.categoryPanel.setLayout(new GridBagLayout());
        this.categoryPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoryPanel.setMinimumSize(new Dimension(220, 4));
        this.categoryPanel.setPreferredSize(new Dimension(220, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 11, 8, 11);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.categoryPanel.getAccessibleContext().setAccessibleName("");
        this.categoryPanel.getAccessibleContext().setAccessibleDescription("");
        this.customizerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 8, 11);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.customizerPanel.getAccessibleContext().setAccessibleName("");
        this.customizerPanel.getAccessibleContext().setAccessibleDescription("");
    }

    public HelpCtx getHelpCtx() {
        return this.currentHelpCtx;
    }

    private void setCategory(ProjectCustomizer.Category category) {
        JComponent jComponent;
        if (category == null) {
            return;
        }
        if (this.currentCustomizer != null) {
            this.customizerPanel.remove(this.currentCustomizer);
        }
        if ((jComponent = this.componentProvider.create(category)) != null) {
            this.currentCustomizer = jComponent;
            this.currentHelpCtx = HelpCtx.findHelp((Component)this.currentCustomizer);
            this.customizerPanel.add(this.currentCustomizer, this.fillConstraints);
            this.customizerPanel.validate();
            this.customizerPanel.repaint();
            jComponent.addPropertyChangeListener(this.mListener);
            this.firePropertyChange(HELP_CTX_PROPERTY, null, this.getHelpCtx());
        } else {
            this.currentCustomizer = null;
        }
    }

    private class CategoryPanelChangeListener
    implements PropertyChangeListener {
        private CategoryPanelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CustomizerPane.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private class CategoryChangeListener
    implements PropertyChangeListener {
        private CategoryChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("propCurrentCategory".equals(propertyChangeEvent.getPropertyName())) {
                ProjectCustomizer.Category category = (ProjectCustomizer.Category)propertyChangeEvent.getNewValue();
                CustomizerPane.this.setCategory(category);
            }
        }
    }
}

