/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.uml.project.ui.common.ReferencedJavaProjectModel;
import org.openide.util.NbBundle;

public class JavaSourceRootsUI {
    public static final int NUM_COLS = 3;
    public static final int COL_INCLUDE_FLAG = 0;
    public static final int COL_SOURCE_GROUP = 1;
    public static final int COL_SOURCE_GROUP_DISPLAY_NAME = 2;

    public static JavaSourceRootsModel createModel(ReferencedJavaProjectModel referencedJavaProjectModel, DefaultListModel defaultListModel) {
        Object[][] objectArray = new Object[0][3];
        SourceGroup[] sourceGroupArray = new SourceGroup[]{};
        Project project = referencedJavaProjectModel.getProject();
        if (referencedJavaProjectModel.isBroken() || project == null) {
            objectArray = new Object[defaultListModel.getSize()][3];
            sourceGroupArray = new SourceGroup[defaultListModel.getSize()];
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                objectArray[i][0] = true;
                Object e = defaultListModel.getElementAt(i);
                if (!(e instanceof SourceGroup)) continue;
                SourceGroup sourceGroup = (SourceGroup)e;
                objectArray[i][1] = sourceGroup.getRootFolder().getName();
                sourceGroupArray[i] = sourceGroup;
            }
        } else {
            Sources sources = (Sources)project.getLookup().lookup(Sources.class);
            if (sources == null) {
                return new JavaSourceRootsModel(objectArray, sourceGroupArray);
            }
            SourceGroup[] sourceGroupArray2 = sources.getSourceGroups("java");
            objectArray = new Object[sourceGroupArray2.length][3];
            sourceGroupArray = new SourceGroup[sourceGroupArray2.length];
            if (sourceGroupArray2.length == 0 && defaultListModel.getSize() == 0) {
                return new JavaSourceRootsModel(objectArray, sourceGroupArray);
            }
            if (sourceGroupArray2.length == 0 || sourceGroupArray2.length < defaultListModel.getSize()) {
                return new JavaSourceRootsModel(objectArray, sourceGroupArray);
            }
            for (int i = 0; i < sourceGroupArray2.length; ++i) {
                objectArray[i][0] = defaultListModel.contains(sourceGroupArray2[i].getName()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                objectArray[i][1] = sourceGroupArray2[i].getRootFolder().getName();
                objectArray[i][2] = sourceGroupArray2[i].getDisplayName();
                sourceGroupArray[i] = sourceGroupArray2[i];
            }
        }
        return new JavaSourceRootsModel(objectArray, sourceGroupArray);
    }

    public static JavaSourceRootsModel createModel(Project project) {
        Object[][] objectArray = new Object[0][3];
        SourceGroup[] sourceGroupArray = new SourceGroup[]{};
        Sources sources = JavaSourceRootsUI.retrieveJavaProjectSources(project);
        if (sources == null) {
            return new JavaSourceRootsModel(objectArray);
        }
        SourceGroup[] sourceGroupArray2 = JavaSourceRootsUI.retrieveJavaProjectSourceGroups(sources);
        objectArray = new Object[sourceGroupArray2.length][3];
        sourceGroupArray = new SourceGroup[sourceGroupArray2.length];
        for (int i = 0; i < sourceGroupArray2.length; ++i) {
            objectArray[i][0] = true;
            objectArray[i][1] = sourceGroupArray2[i].getRootFolder().getName();
            objectArray[i][2] = sourceGroupArray2[i].getDisplayName();
            sourceGroupArray[i] = sourceGroupArray2[i];
        }
        return new JavaSourceRootsModel(objectArray, sourceGroupArray);
    }

    public static SourceGroup[] retrieveJavaProjectSourceGroups(Sources sources) {
        return sources.getSourceGroups("java");
    }

    public static Sources retrieveJavaProjectSources(Project project) {
        return (Sources)project.getLookup().lookup(Sources.class);
    }

    public static DefaultTableModel createEmptyModel() {
        Object[][] objectArray = new Object[0][3];
        SourceGroup[] sourceGroupArray = new SourceGroup[]{};
        return new JavaSourceRootsModel(objectArray, sourceGroupArray);
    }

    private static class WarningDlg
    extends JPanel {
        public WarningDlg(Set set) {
            this.initGui(set);
        }

        private void initGui(Set set) {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            jLabel.setText(NbBundle.getMessage(JavaSourceRootsUI.class, (String)"LBL_InvalidRoot"));
            jLabel.setDisplayedMnemonic(NbBundle.getMessage(JavaSourceRootsUI.class, (String)"MNE_InvalidRoot").charAt(0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(12, 0, 6, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            JList<Object> jList = new JList<Object>(set.toArray());
            jList.setCellRenderer(new InvalidRootRenderer(true));
            JScrollPane jScrollPane = new JScrollPane(jList);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 12, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            jLabel.setLabelFor(jList);
            jList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaSourceRootsUI.class, (String)"AD_InvalidRoot"));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(NbBundle.getMessage(JavaSourceRootsUI.class, (String)"MSG_InvalidRoot2"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel2, gridBagConstraints);
            this.add(jLabel2);
        }

        private static class InvalidRootRenderer
        extends DefaultListCellRenderer {
            private boolean projectConflict;

            public InvalidRootRenderer(boolean bl) {
                this.projectConflict = bl;
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                ProjectInformation projectInformation;
                Project project;
                File file = (File)object;
                String string2 = file.getAbsolutePath();
                if (this.projectConflict && (project = FileOwnerQuery.getOwner((URI)file.toURI())) != null && (projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class)) != null && (string = projectInformation.getDisplayName()) != null) {
                    string2 = MessageFormat.format(NbBundle.getMessage(JavaSourceRootsUI.class, (String)"TXT_RootOwnedByProject"), string2, string);
                }
                return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
            }
        }
    }

    public static class JavaSourceRootsModel
    extends DefaultTableModel {
        SourceGroup[] sourceGroups = null;
        static String colCheck = NbBundle.getMessage(JavaSourceRootsUI.class, (String)"LBL_SourceGroupsColCheck");
        static String colCheckAlt = NbBundle.getMessage(JavaSourceRootsUI.class, (String)"LBL_SourceGroupsColCheckAlt");
        static String colGroupFolder = NbBundle.getMessage(JavaSourceRootsUI.class, (String)"LBL_SourceGroupsColFolder");
        static String colGroupLabel = NbBundle.getMessage(JavaSourceRootsUI.class, (String)"LBL_SourceGroupsColLabel");

        public JavaSourceRootsModel(Object[][] objectArray) {
            super(objectArray, new Object[]{colCheck, colGroupFolder, colGroupLabel});
        }

        public JavaSourceRootsModel(Object[][] objectArray, SourceGroup[] sourceGroupArray) {
            super(objectArray, new Object[]{colCheck, colGroupFolder, colGroupLabel});
            this.sourceGroups = sourceGroupArray;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return super.getColumnClass(n);
        }

        public SourceGroup[] getSourceGroups() {
            return this.sourceGroups;
        }

        public SourceGroup getSourceGroup(int n) {
            if (this.sourceGroups == null) {
                return null;
            }
            return this.sourceGroups[n];
        }
    }
}

