/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.metamodel.structure.Project;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguageManager;
import org.netbeans.modules.uml.core.reverseengineering.reintegration.ReverseEngineerTask;
import org.netbeans.modules.uml.core.support.umlsupport.IStrings;
import org.netbeans.modules.uml.core.support.umlsupport.Strings;
import org.netbeans.modules.uml.project.AssociatedSourceProvider;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.UMLActionProvider;
import org.netbeans.modules.uml.project.UMLProjectDataObject;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.project.UMLProjectMetadataListener;
import org.netbeans.modules.uml.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.uml.project.ui.customizer.UMLImportsUiSupport;
import org.netbeans.modules.uml.project.ui.customizer.UMLProjectProperties;
import org.netbeans.modules.uml.project.ui.nodes.ModelRootNodeCookie;
import org.netbeans.modules.uml.project.ui.nodes.UMLPhysicalViewProvider;
import org.netbeans.modules.uml.resources.images.ImageUtil;
import org.netbeans.modules.uml.util.ITaskFinishListener;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UMLProject
implements org.netbeans.api.project.Project,
AntProjectListener {
    private static final Icon PROJECT_ICON = ImageUtil.instance().getIcon("uml-project.png");
    private final Lookup mLookup;
    private final UMLProjectHelper mHelper;
    private final ReferenceHelper mRefHelper;
    private final GeneratedFilesHelper mGenFilesHelper;
    private final PropertyEvaluator mEval;
    private final UMLImportsUiSupport mImportSupport;
    UMLProjectProperties uiProperties;
    public static final int PROJECT_MODE_ANALYSIS = 0;
    public static final int PROJECT_MODE_DESIGN = 1;
    public static final int PROJECT_MODE_IMPL = 2;
    public static final String PROJECT_MODE_ANALYSIS_STR = "Analysis";
    public static final String PROJECT_MODE_DESIGN_STR = "Design";
    public static final String PROJECT_MODE_IMPL_STR = "Implementation";
    public static final String PROJECT_MODE_DEFAULT_STR = "Analysis";
    public static final int PROJECT_LANG_JAVA = 0;
    public static final String PROJECT_LANG_JAVA_STR = "Java";
    public static final String ARTIFACT_TYPE_UML_PROJ = "umlproj";
    private UMLProjectMetadataListener mListener = null;
    private DataObject obj;

    public UMLProject(AntProjectHelper antProjectHelper) {
        this.mHelper = new UMLProjectHelper(antProjectHelper, this);
        this.mEval = this.createEvaluator();
        this.mImportSupport = new UMLImportsUiSupport(this);
        AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
        this.mRefHelper = new ReferenceHelper(antProjectHelper, auxiliaryConfiguration, this.mEval);
        this.mGenFilesHelper = new GeneratedFilesHelper(antProjectHelper);
        this.mLookup = this.createLookup(auxiliaryConfiguration);
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
        this.mListener = new UMLProjectMetadataListener(this);
        this.mEval.addPropertyChangeListener((PropertyChangeListener)this.mListener);
        this.mHelper.getAntProjectHelper().addAntProjectListener((AntProjectListener)this.mListener);
    }

    public Lookup getLookup() {
        return this.mLookup;
    }

    private PropertyEvaluator createEvaluator() {
        return this.mHelper.getStandardPropertyEvaluator();
    }

    public PropertyEvaluator evaluator() {
        return this.mEval;
    }

    public void removeUMLProjectMetaListener() {
        this.evaluator().removePropertyChangeListener((PropertyChangeListener)this.mListener);
        this.mHelper.getAntProjectHelper().removeAntProjectListener((AntProjectListener)this.mListener);
    }

    public ReferenceHelper getReferenceHelper() {
        return this.mRefHelper;
    }

    public UMLProjectProperties getUMLProjectProperties() {
        return this.uiProperties;
    }

    public void setUMLProjectProperties(UMLProjectProperties uMLProjectProperties) {
        this.uiProperties = uMLProjectProperties;
    }

    protected Lookup createLookup(AuxiliaryConfiguration auxiliaryConfiguration) {
        SubprojectProvider subprojectProvider = this.mRefHelper.createSubprojectProvider();
        Object[] objectArray = new Object[]{new Info(), auxiliaryConfiguration, this.mHelper.createCacheDirectoryProvider(), subprojectProvider, new UMLActionProvider(this, this.mHelper), new UMLPhysicalViewProvider(this, this.mHelper, this.mEval, subprojectProvider, this.mImportSupport, this.mRefHelper), new CustomizerProviderImpl(this, this.mHelper, this.mEval, this.mRefHelper), new ProjectOpenedHookImpl(), new RecommendedTemplatesImpl(), this.mHelper, new AntProjectHelperProvider(), new AntArtifactProviderImpl(), new AssociatedSourceProvider(this, this.mHelper, this.mEval)};
        return Lookups.fixed((Object[])objectArray);
    }

    public FileObject getProjectDirectory() {
        return this.mHelper.getProjectDirectory();
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element element = UMLProject.this.mHelper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.sun.com/ns/uml-project/1", "name");
                if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    return ((Text)nodeList.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setName(final String string) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element element;
                Element element2 = UMLProject.this.mHelper.getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS("http://www.sun.com/ns/uml-project/1", "name");
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS("http://www.sun.com/ns/uml-project/1", "name");
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string));
                UMLProject.this.mHelper.putPrimaryConfigurationData(element2, true);
                return null;
            }
        });
    }

    protected void retrieveFilenames(File file, IStrings iStrings, ILanguageManager iLanguageManager) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.retrieveFilenames(fileArray[i], iStrings, iLanguageManager);
                }
            } else {
                String string = file.getAbsolutePath();
                if (iLanguageManager.getLanguageForFile(string) != null) {
                    iStrings.add(string);
                }
            }
        }
    }

    protected IStrings retrieveFilenames(File[] fileArray) {
        Strings strings = new Strings();
        try {
            ILanguageManager iLanguageManager = this.mHelper.getProduct().getLanguageManager();
            for (int i = 0; i < fileArray.length; ++i) {
                this.retrieveFilenames(fileArray[i], (IStrings)strings, iLanguageManager);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return strings;
    }

    public void reverseEngineer(File[] fileArray) {
        this.initalizeProperties();
        IStrings iStrings = this.retrieveFilenames(fileArray);
        ReverseEngineerTask reverseEngineerTask = new ReverseEngineerTask((INamespace)this.mHelper.getProject(), iStrings, false, false, true, true, new ITaskFinishListener(){

            public void taskFinished() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ModelRootNodeCookie modelRootNodeCookie;
                        UMLPhysicalViewProvider uMLPhysicalViewProvider = (UMLPhysicalViewProvider)UMLProject.this.getLookup().lookup(UMLPhysicalViewProvider.class);
                        if (uMLPhysicalViewProvider != null && (modelRootNodeCookie = uMLPhysicalViewProvider.getModelRootNodeCookie()) != null) {
                            modelRootNodeCookie.recalculateChildren();
                        }
                    }
                });
            }
        });
        RequestProcessor requestProcessor = new RequestProcessor("uml/ReverseEngineer");
        requestProcessor.post((Runnable)reverseEngineerTask);
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        if (antProjectEvent.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    public void saveProject() {
        this.mHelper.saveProject();
    }

    protected void initalizeProperties() {
        if (this.uiProperties == null) {
            this.uiProperties = new UMLProjectProperties(this, this.mHelper, this.mEval, this.mRefHelper);
        }
    }

    protected void initializeProjectSettings(IProject iProject) {
        String string;
        if (this.getUMLProjectProperties() != null && !(string = this.getUMLProjectProperties().getProjectMode()).equals(iProject.getMode())) {
            this.setProjectMode(iProject, string);
        }
    }

    public void setProjectMode(String string) {
        IProject iProject = this.mHelper.getProject();
        this.setProjectMode(iProject, string);
    }

    protected void setProjectMode(IProject iProject, String string) {
        if (iProject != null) {
            iProject.setMode(string);
        }
    }

    private final class AntArtifactProviderImpl
    implements AntArtifactProvider {
        private AntArtifactProviderImpl() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{UMLProject.this.mHelper.getAntProjectHelper().createSimpleAntArtifact(UMLProject.ARTIFACT_TYPE_UML_PROJ, "uml.umlproject", UMLProject.this.evaluator(), "uml", "cleanUml")};
        }
    }

    final class AntProjectHelperProvider {
        AntProjectHelperProvider() {
        }

        AntProjectHelper getAntProjectHelper() {
            return UMLProject.this.mHelper.getAntProjectHelper();
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] APPLICATION_TYPES = new String[]{"uml-type"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/UML/newUMLDiagram", "Templates/UML/newUMLPackage", "Templates/UML/newUMLElement"};

        RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return APPLICATION_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String string) {
            this.pcs.firePropertyChange(string, null, null);
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)UMLProject.this.getName());
        }

        public String getDisplayName() {
            return UMLProject.this.getName();
        }

        public Icon getIcon() {
            return PROJECT_ICON;
        }

        public org.netbeans.api.project.Project getProject() {
            return UMLProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        UMLProjectChangeListener listener = new UMLProjectChangeListener();
        private IProject temp = null;

        ProjectOpenedHookImpl() {
        }

        protected IProject retreiveProject() {
            IProject iProject = null;
            try {
                iProject = UMLProject.this.mHelper.getProject();
                UMLProject.this.initializeProjectSettings(iProject);
                UMLProject.this.mImportSupport.initializeProject();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
            return iProject;
        }

        protected IProject verifyProjectIsInitialized() {
            this.temp = this.retreiveProject();
            while (this.temp == null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ProjectOpenedHookImpl.this.temp = ProjectOpenedHookImpl.this.retreiveProject();
                        }
                    });
                }
                catch (Exception exception) {}
            }
            return this.temp;
        }

        protected void projectOpened() {
            IProject iProject = this.verifyProjectIsInitialized();
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    EditableProperties editableProperties = UMLProject.this.mHelper.getProperties("nbproject/private/private.properties");
                    File file = new File(System.getProperty("netbeans.user"), "build.properties");
                    editableProperties.setProperty("user.properties.file", file.getAbsolutePath());
                    UMLProject.this.mHelper.putProperties("nbproject/private/private.properties", editableProperties);
                    try {
                        ProjectManager.getDefault().saveProject((org.netbeans.api.project.Project)UMLProject.this);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    return null;
                }
            });
            UMLPhysicalViewProvider uMLPhysicalViewProvider = (UMLPhysicalViewProvider)UMLProject.this.getLookup().lookup(UMLPhysicalViewProvider.class);
            boolean bl = uMLPhysicalViewProvider.hasBrokenLinks();
            if (uMLPhysicalViewProvider != null && bl) {
                BrokenReferencesSupport.showAlert();
            }
            UMLProject.this.initalizeProperties();
            FileObject fileObject = UMLProject.this.mHelper.getProjectDirectory();
            if (fileObject != null) {
                org.netbeans.api.project.Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                String string = fileObject.getPath();
                if (string != null && string.length() > 0) {
                    string = this.normalizeFile(FileUtil.toFile((FileObject)fileObject).getPath());
                }
                Project.PROJ_BASE_DIR = string;
                if (!bl) {
                    UMLProjectHelper.scanSourceGroups((UMLProject)project);
                }
                if (iProject instanceof Project) {
                    ((Project)iProject).addPropertyChangeListener((PropertyChangeListener)this.listener);
                }
                try {
                    File file = new File(iProject.getProject().getFileName());
                    FileObject fileObject2 = FileUtil.toFileObject((File)new File(file.getCanonicalPath()));
                    UMLProject.this.obj = DataObject.find((FileObject)fileObject2);
                    if (iProject.getDirty()) {
                        ((UMLProjectDataObject)UMLProject.this.obj).addSaveCookie();
                        UMLProject.this.obj.setModified(true);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().log(4096, exception.getMessage());
                }
            }
        }

        public String normalizeFile(String string) {
            if (string != null && string.length() > 0) {
                string = string.replace("/", File.separator).trim();
            }
            return string;
        }

        protected void projectClosed() {
            Object object;
            Lookup lookup;
            if (UMLProject.this.mHelper != null) {
                UMLProject.this.mHelper.closeProject(false);
            }
            if (UMLProject.this.mImportSupport != null) {
                UMLProject.this.mImportSupport.unInitializeProject();
            }
            if ((lookup = UMLProject.this.getLookup()) != null && (object = (UMLPhysicalViewProvider)lookup.lookup(UMLPhysicalViewProvider.class)) != null) {
                ((UMLPhysicalViewProvider)object).detachLogicalView();
            }
            if (((org.netbeans.api.project.Project[])(object = ProjectUtil.getOpenUMLProjects())).length == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TopComponent topComponent = WindowManager.getDefault().findTopComponent("designpattern");
                        if (topComponent != null) {
                            topComponent.close();
                        }
                        if ((topComponent = WindowManager.getDefault().findTopComponent("documentation")) != null) {
                            topComponent.close();
                        }
                    }
                });
            }
        }

        private class UMLProjectChangeListener
        implements PropertyChangeListener {
            private UMLProjectChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Project.PROP_DIRTY.equals(propertyChangeEvent.getPropertyName()) && UMLProject.this.obj instanceof UMLProjectDataObject) {
                    ((UMLProjectDataObject)UMLProject.this.obj).addSaveCookie();
                    UMLProject.this.obj.setModified(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                }
            }
        }
    }
}

