/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors.controls;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.StandardButtonBar;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.openide.util.NbBundle;

public class BaseTablePanel
extends EditorLifeCycleAdapter {
    static final long serialVersionUID = 1L;
    private ListSelectionModel mySelectionModel;
    private ListSelectionListener mySelectionListener;
    private MouseListener myMouseListener;
    private StandardButtonBar buttonBar;
    private JTable myTableView;

    public void createContent() {
        this.setLayout(new BorderLayout());
        this.buttonBar = new StandardButtonBar();
        this.buttonBar.createContent();
        this.add(this.buttonBar, "North");
        this.addListeners();
        this.buttonBar.btnUp.setVisible(this.isRowMoveSupported());
        this.buttonBar.btnDown.setVisible(this.isRowMoveSupported());
    }

    public boolean initControls() {
        this.updateButtonState();
        return true;
    }

    private void addListeners() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == ((BaseTablePanel)BaseTablePanel.this).buttonBar.btnAdd) {
                    BaseTablePanel.this.addRow(actionEvent);
                } else if (object == ((BaseTablePanel)BaseTablePanel.this).buttonBar.btnEdit) {
                    BaseTablePanel.this.editRow(actionEvent);
                } else if (object == ((BaseTablePanel)BaseTablePanel.this).buttonBar.btnDelete) {
                    BaseTablePanel.this.deleteRow(actionEvent);
                    BaseTablePanel.this.updateButtonState();
                } else if (object == ((BaseTablePanel)BaseTablePanel.this).buttonBar.btnUp) {
                    BaseTablePanel.this.moveUp();
                } else if (object == ((BaseTablePanel)BaseTablePanel.this).buttonBar.btnDown) {
                    BaseTablePanel.this.moveDown();
                }
            }
        };
        this.buttonBar.btnAdd.addActionListener(actionListener);
        this.buttonBar.btnEdit.addActionListener(actionListener);
        this.buttonBar.btnDelete.addActionListener(actionListener);
        this.buttonBar.btnUp.addActionListener(actionListener);
        this.buttonBar.btnDown.addActionListener(actionListener);
    }

    protected void doRefresh() {
    }

    protected void addRow(ActionEvent actionEvent) {
    }

    protected void editRow(ActionEvent actionEvent) {
    }

    protected void deleteRow(ActionEvent actionEvent) {
        int n = this.getTableView().getSelectedRow();
        this.deleteRowImpl(actionEvent);
        if (n != -1) {
            int n2 = this.getTableView().getModel().getRowCount();
            n = Math.min(n2 - 1, n);
            this.getTableView().getSelectionModel().setSelectionInterval(n, n);
        }
    }

    protected void deleteRowImpl(ActionEvent actionEvent) {
    }

    protected boolean isRowMoveSupported() {
        return false;
    }

    protected void moveUp() {
    }

    protected void moveDown() {
    }

    protected void processDoubleClick(int n) {
        this.editRow(new ActionEvent((Object)this, 0, "edit"));
    }

    protected void attach2SelectionModel(ListSelectionModel listSelectionModel) {
        if (this.mySelectionModel == null || !this.mySelectionModel.equals(listSelectionModel)) {
            if (this.mySelectionModel != null) {
                this.mySelectionModel.removeListSelectionListener(this.getSelectionListener());
            }
            this.mySelectionModel = listSelectionModel;
            if (this.mySelectionModel != null) {
                this.mySelectionModel.addListSelectionListener(this.getSelectionListener());
            }
        }
    }

    protected ListSelectionListener getSelectionListener() {
        if (this.mySelectionListener == null) {
            this.mySelectionListener = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        BaseTablePanel.this.updateButtonState();
                    }
                }
            };
        }
        return this.mySelectionListener;
    }

    protected void updateButtonState() {
        if (this.mySelectionModel != null && this.myTableView != null) {
            int n = this.mySelectionModel.getMinSelectionIndex();
            int n2 = this.mySelectionModel.getMaxSelectionIndex();
            boolean bl = n != -1;
            this.buttonBar.btnEdit.setEnabled(bl);
            this.buttonBar.btnDelete.setEnabled(bl);
            this.buttonBar.btnUp.setEnabled(bl && n > 0);
            int n3 = this.myTableView.getModel().getRowCount();
            this.buttonBar.btnDown.setEnabled(bl && n2 < n3 - 1);
        }
    }

    protected MouseListener getMouseListener() {
        if (this.myMouseListener == null) {
            this.myMouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = BaseTablePanel.this.getTableView().getSelectedRow()) != -1) {
                        BaseTablePanel.this.processDoubleClick(n);
                    }
                }
            };
        }
        return this.myMouseListener;
    }

    public JTable getTableView() {
        return this.myTableView;
    }

    public void setTableView(JTable jTable) {
        if (this.myTableView == null || !this.myTableView.equals(jTable)) {
            if (this.myTableView != null) {
                this.myTableView.removeMouseListener(this.getMouseListener());
                this.attach2SelectionModel(null);
            }
            this.myTableView = jTable;
            if (this.myTableView != null) {
                this.myTableView.addMouseListener(this.getMouseListener());
                this.attach2SelectionModel(jTable.getSelectionModel());
                this.updateButtonState();
            }
        }
    }

    public StandardButtonBar getButtonBar() {
        return this.buttonBar;
    }

    protected void restoreSelectedRows(int[] nArray) {
        if (this.myTableView == null) {
            return;
        }
        ListSelectionModel listSelectionModel = this.myTableView.getSelectionModel();
        int n = this.myTableView.getRowCount();
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            listSelectionModel.addSelectionInterval(n2, n2);
        }
    }

    protected void disableButtons() {
        this.buttonBar.btnAdd.setEnabled(false);
        this.buttonBar.btnDelete.setEnabled(false);
        this.buttonBar.btnDown.setEnabled(false);
        this.buttonBar.btnEdit.setEnabled(false);
        this.buttonBar.btnUp.setEnabled(false);
    }

    protected JLabel createLabel(String string) {
        return new JLabel(string, 0);
    }

    protected JLabel createWSDLErrorMessage() {
        String string = NbBundle.getMessage(FormBundle.class, (String)"LBL_BadWSDL");
        return this.createLabel("<HTML><b><font color='red'>" + string + "</font></b></HTML>");
    }
}

