/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PortTypeReference;
import org.netbeans.modules.bpel.model.xam.BpelAttributes;
import org.netbeans.modules.bpel.properties.editors.BpelEntityComplexName;
import org.netbeans.modules.bpel.properties.editors.DefineCorrelationWizard;
import org.netbeans.modules.bpel.properties.editors.OnEventComplexName;
import org.netbeans.modules.bpel.properties.editors.OnMessageComplexName;
import org.netbeans.modules.bpel.properties.editors.UnnamedActivityNameHandler;
import org.netbeans.modules.bpel.properties.editors.WizardConstants;
import org.netbeans.modules.bpel.properties.editors.WsdlNamespaceContext;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationUtil;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.wsdl.util.RelativePath;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeNameTest;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathModelFactory;
import org.netbeans.modules.xml.xpath.ext.XPathModelHelper;
import org.netbeans.modules.xml.xpath.ext.XPathUtils;
import org.netbeans.modules.xml.xpath.ext.spi.ExternalModelResolver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WizardUtils
implements WizardConstants {
    WizardUtils() {
    }

    public static String getCorrelationSetBpelEntityName(BpelEntity bpelEntity) {
        String string = null;
        if (bpelEntity instanceof OnMessage || bpelEntity instanceof OnEvent) {
            string = NbBundle.getMessage(DefineCorrelationWizard.class, (String)(bpelEntity instanceof OnMessage ? "LBL_Correlation_Set_Name_OnMessage_Pattern" : "LBL_Correlation_Set_Name_OnEvent_Pattern"));
        }
        return WizardUtils.getBpelEntityName(bpelEntity, string);
    }

    public static String getBpelEntityName(BpelEntity bpelEntity) {
        return WizardUtils.getBpelEntityName(bpelEntity, null);
    }

    public static String getBpelEntityName(BpelEntity bpelEntity, String string) {
        if (bpelEntity instanceof OnMessage || bpelEntity instanceof OnEvent) {
            assert (string != null);
            BpelEntityComplexName bpelEntityComplexName = bpelEntity instanceof OnMessage ? new OnMessageComplexName((OnMessage)bpelEntity) : new OnEventComplexName((OnEvent)bpelEntity);
            String string2 = bpelEntityComplexName.getFirstName();
            String string3 = bpelEntityComplexName.getMiddleName();
            String string4 = bpelEntityComplexName.getLastName();
            return MessageFormat.format(string, string2, string3, string4);
        }
        String string5 = bpelEntity.getAttribute((Attribute)BpelAttributes.NAME);
        return string5 != null ? string5 : UnnamedActivityNameHandler.getInstance().getActivityName(bpelEntity);
    }

    public static NamedComponentReference<? extends GlobalType> getSchemaComponentTypeRef(SchemaComponent schemaComponent) {
        NamedComponentReference namedComponentReference = null;
        try {
            namedComponentReference = ((TypeContainer)schemaComponent).getType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return namedComponentReference;
    }

    public static String getSchemaComponentTypeName(SchemaComponent schemaComponent) {
        NamedComponentReference<? extends GlobalType> namedComponentReference;
        String string = null;
        string = schemaComponent instanceof SimpleType || schemaComponent instanceof ComplexType ? schemaComponent.getAttribute(ValidationUtil.attributeName()) : ((namedComponentReference = WizardUtils.getSchemaComponentTypeRef(schemaComponent)) != null ? ((GlobalType)namedComponentReference.get()).getName() : schemaComponent.getAttribute(ValidationUtil.attributeType()));
        return string;
    }

    public static String getSchemaComponentName(SchemaComponent schemaComponent) {
        String string = null;
        string = schemaComponent instanceof SimpleType ? WizardUtils.getSchemaComponentTypeName(schemaComponent) : schemaComponent.toString();
        return string;
    }

    public static boolean isBuiltInType(SchemaComponent schemaComponent) {
        String string = WizardUtils.getSchemaComponentTypeName(schemaComponent);
        GlobalSimpleType globalSimpleType = ValidationUtil.findGlobalSimpleType((String)string, (Collection)ValidationUtil.BUILT_IN_SIMPLE_TYPES);
        return globalSimpleType != null;
    }

    public static PortType getBpelEntityPortType(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return null;
        }
        try {
            PortType portType = (PortType)((PortTypeReference)bpelEntity).getPortType().get();
            return portType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Operation getBpelEntityOperation(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return null;
        }
        PortType portType = WizardUtils.getBpelEntityPortType(bpelEntity);
        Collection collection = portType.getOperations();
        String string = bpelEntity.getAttribute((Attribute)BpelAttributes.OPERATION);
        for (Operation operation : collection) {
            if (!operation.getName().equals(string)) continue;
            return operation;
        }
        return null;
    }

    public static String validateActivity(BpelEntity bpelEntity) {
        if (WizardUtils.getBpelEntityPortType(bpelEntity) == null) {
            return NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_ErrMsg_Activity_Has_Wrong_PortType");
        }
        if (WizardUtils.getBpelEntityOperation(bpelEntity) == null) {
            return NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_ErrMsg_Activity_Has_Wrong_Operation");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importRequiredSchemas(WSDLModel wSDLModel, List<SchemaComponent> list) {
        try {
            wSDLModel.startTransaction();
            for (SchemaComponent schemaComponent : list) {
                Utility.addSchemaImport((SchemaComponent)schemaComponent, (WSDLModel)wSDLModel);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        finally {
            wSDLModel.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importWsdlIntoWsdl(WSDLModel wSDLModel, WSDLModel wSDLModel2) {
        try {
            Import import_ = wSDLModel.getFactory().createImport();
            FileObject fileObject = (FileObject)wSDLModel.getModelSource().getLookup().lookup(FileObject.class);
            FileObject fileObject2 = (FileObject)wSDLModel2.getModelSource().getLookup().lookup(FileObject.class);
            String string = WizardUtils.getRelativePath(fileObject, fileObject2);
            import_.setNamespace(wSDLModel2.getDefinitions().getTargetNamespace());
            import_.setLocation(string);
            if (!WizardUtils.wsdlContainsImport(wSDLModel, import_)) {
                wSDLModel.startTransaction();
                wSDLModel.getDefinitions().addImport(import_);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        finally {
            wSDLModel.endTransaction();
        }
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject == null || fileObject2 == null) {
            throw new NullPointerException(fileObject == null ? "Base file object is null" : "Related file object is null");
        }
        String string = fileObject2.getNameExt();
        URI uRI = FileUtil.toFile((FileObject)fileObject).toURI();
        URI uRI2 = FileUtil.toFile((FileObject)fileObject2).toURI();
        if (!uRI2.equals(uRI)) {
            DefaultProjectCatalogSupport defaultProjectCatalogSupport = DefaultProjectCatalogSupport.getInstance((FileObject)fileObject);
            if (defaultProjectCatalogSupport.needsCatalogEntry(fileObject, fileObject2)) {
                try {
                    URI uRI3 = defaultProjectCatalogSupport.getReferenceURI(fileObject, fileObject2);
                    defaultProjectCatalogSupport.removeCatalogEntry(uRI3);
                    defaultProjectCatalogSupport.createCatalogEntry(fileObject, fileObject2);
                    string = defaultProjectCatalogSupport.getReferenceURI(fileObject, fileObject2).toString();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            } else {
                string = RelativePath.getRelativePath((File)FileUtil.toFile((FileObject)fileObject).getParentFile(), (File)FileUtil.toFile((FileObject)fileObject2));
            }
        }
        return string;
    }

    public static boolean wsdlContainsImport(WSDLModel wSDLModel, Import import_) {
        Collection collection = wSDLModel.getDefinitions().getImports();
        for (Import import_2 : collection) {
            if (!import_2.getNamespace().equals(import_.getNamespace()) || !import_2.getLocation().equals(import_.getLocation())) continue;
            return true;
        }
        return false;
    }

    public static boolean wsdlContainsPropertyAlias(WSDLModel wSDLModel, CorrelationProperty correlationProperty, Message message, Part part) {
        List list = ((WSDLComponent)wSDLModel.getRootComponent()).getChildren(PropertyAlias.class);
        for (PropertyAlias propertyAlias : list) {
            CorrelationProperty correlationProperty2 = (CorrelationProperty)propertyAlias.getPropertyName().get();
            Message message2 = (Message)propertyAlias.getMessageType().get();
            String string = propertyAlias.getPart();
            if (!correlationProperty2.getName().equals(correlationProperty.getName()) || !message2.getName().equals(message.getName()) || !string.equals(part.getName())) continue;
            return true;
        }
        return false;
    }

    public static String makeLocationPath(final WSDLModel wSDLModel, final List<SchemaComponent> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        XPathModelHelper xPathModelHelper = XPathModelHelper.getInstance();
        XPathModel xPathModel = xPathModelHelper.newXPathModel();
        WsdlNamespaceContext wsdlNamespaceContext = new WsdlNamespaceContext((WSDLComponent)wSDLModel.getDefinitions());
        xPathModel.setNamespaceContext((NamespaceContext)wsdlNamespaceContext);
        xPathModel.setExternalModelResolver(new ExternalModelResolver(){

            public Collection<SchemaModel> getModels(String string) {
                List list2 = wSDLModel.findSchemas(string);
                ArrayList<SchemaModel> arrayList = new ArrayList<SchemaModel>(list2.size());
                for (Schema schema : list2) {
                    SchemaModel schemaModel = schema.getModel();
                    arrayList.add(schemaModel);
                }
                return arrayList;
            }

            public Collection<SchemaModel> getVisibleModels() {
                SchemaModel schemaModel = ((SchemaComponent)list.get(0)).getModel();
                return Collections.singleton(schemaModel);
            }

            public boolean isSchemaVisible(String string) {
                List list2 = wSDLModel.findSchemas(string);
                return list2 != null && list2.size() > 0;
            }
        });
        XPathModelFactory xPathModelFactory = xPathModel.getFactory();
        ArrayList<LocationStep> arrayList = new ArrayList<LocationStep>(list.size());
        for (SchemaComponent schemaComponent : list) {
            String string = WizardUtils.getNamespacePrefix(wSDLModel, schemaComponent);
            StepNodeNameTest stepNodeNameTest = null;
            if (string != null) {
                string = XPathUtils.isPrefixRequired((SchemaComponent)schemaComponent) ? string : "";
                stepNodeNameTest = new StepNodeNameTest(new QName(null, WizardUtils.getSchemaComponentName(schemaComponent), string));
            } else {
                new StepNodeNameTest(xPathModel, schemaComponent);
            }
            LocationStep locationStep = xPathModelFactory.newLocationStep(null, stepNodeNameTest, null);
            arrayList.add(locationStep);
        }
        XPathLocationPath xPathLocationPath = xPathModelFactory.newXPathLocationPath(arrayList.toArray(new LocationStep[arrayList.size()]));
        xPathLocationPath.setAbsolute(true);
        xPathModel.setRootExpression((XPathExpression)xPathLocationPath);
        return xPathLocationPath.getExpressionString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNamespacePrefix(WSDLModel wSDLModel, SchemaComponent schemaComponent) {
        assert (wSDLModel != null && schemaComponent != null);
        String string = schemaComponent.getModel().getSchema().getTargetNamespace();
        if (string != null) {
            try {
                new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
                return null;
            }
        }
        try {
            String string2 = WizardUtils.getNamespacePrefix(wSDLModel, string);
            if (string2 != null) {
                String string3 = string2;
                return string3;
            }
            string2 = "ns";
            int n = WizardUtils.getMaxSuffixNumber(wSDLModel, string2);
            string2 = string2 + ++n;
            wSDLModel.startTransaction();
            if (n == 0) {
                ((AbstractDocumentComponent)wSDLModel.getDefinitions()).addPrefix(string2, string);
            }
            String string4 = string2;
            return string4;
        }
        finally {
            wSDLModel.endTransaction();
        }
    }

    private static String getNamespacePrefix(WSDLModel wSDLModel, String string) {
        String string2 = wSDLModel.getDefinitions().getPeer().lookupPrefix(string);
        if (string2 != null && string2.length() == 0) {
            return null;
        }
        return string2;
    }

    private static int getMaxSuffixNumber(WSDLModel wSDLModel, String string) {
        assert (string != null);
        Set set = ((AbstractDocumentComponent)wSDLModel.getDefinitions()).getPrefixes().keySet();
        int n = -1;
        for (String string2 : set) {
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length());
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 <= n) continue;
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }
}

