/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.soa.ui.nodes.NodesTreeParams;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELQName;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Query;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String FORWARD_SLASH = "/";
    public static final String UP_REL_FOLDER = "../";
    public static final String CUR_REL_FOLDER = "./";

    private Util() {
    }

    public static FileObject getRelativeFO(FileObject fileObject, String string) {
        if (fileObject == null || string == null) {
            return null;
        }
        string = ResolverUtility.decodeLocation(string);
        if (!fileObject.isFolder()) {
            fileObject = fileObject.getParent();
        }
        if (string.startsWith(UP_REL_FOLDER)) {
            int n = UP_REL_FOLDER.length();
            while (string.startsWith(UP_REL_FOLDER)) {
                fileObject = fileObject.getParent();
                string = string.substring(n);
            }
        } else if (string.startsWith(CUR_REL_FOLDER)) {
            string = string.substring(CUR_REL_FOLDER.length());
        }
        return fileObject.getFileObject(string);
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
        if (string != null) {
            return string;
        }
        if (!fileObject.isFolder()) {
            fileObject = fileObject.getParent();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(fileObject.getPath(), FORWARD_SLASH);
        StringTokenizer stringTokenizer2 = new StringTokenizer(fileObject2.getPath(), FORWARD_SLASH);
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()).equals(string3 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null)) {
        }
        if (string3 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(UP_REL_FOLDER);
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            stringBuffer.append(UP_REL_FOLDER);
        }
        StringBuffer stringBuffer2 = new StringBuffer(string3);
        while (stringTokenizer2.hasMoreTokens()) {
            stringBuffer2.append(FORWARD_SLASH).append(stringTokenizer2.nextToken());
        }
        return stringBuffer.append(stringBuffer2).toString();
    }

    public static String getAccentedString(String string) {
        return "<html><b>" + string + "</b></html>";
    }

    public static boolean isNCName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char c = cArray[0];
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (Util.isNCNameChar(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNameChar(char c) {
        if (Character.isLetter(c) || Character.isDigit(c)) {
            return true;
        }
        if (Util.isExtender(c)) {
            return true;
        }
        switch (c) {
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static boolean isExtender(char c) {
        if (c >= '\u3031' && c <= '\u3035') {
            return true;
        }
        if (c >= '\u30fc' && c <= '\u30fe') {
            return true;
        }
        switch (c) {
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u0640': 
            case '\u0e46': 
            case '\u0ec6': 
            case '\u3005': 
            case '\u309d': 
            case '\u309e': {
                return true;
            }
        }
        return false;
    }

    public static FileObject getFileObjectByModel(Model model) {
        Lookup lookup;
        ModelSource modelSource;
        if (model != null && (modelSource = model.getModelSource()) != null && (lookup = modelSource.getLookup()) != null) {
            return (FileObject)lookup.lookup(FileObject.class);
        }
        return null;
    }

    public static String getNewModelLocation(Model model, FileObject fileObject) {
        Lookup lookup = model.getModelSource().getLookup();
        if (lookup != null) {
            FileObject fileObject2 = Util.getFileObjectByModel(model);
            return Util.getRelativePath(fileObject2.getParent(), fileObject);
        }
        return null;
    }

    public static String getNewModelNamespace(FileObject fileObject, Constants.StandardImportType standardImportType) {
        ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
        if (modelSource == null) {
            return null;
        }
        switch (standardImportType) {
            case IMPORT_SCHEMA: {
                SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
                if (schemaModel == null || schemaModel.getState() == Model.State.NOT_WELL_FORMED) break;
                return schemaModel.getSchema().getTargetNamespace();
            }
            case IMPORT_WSDL: {
                WSDLModel wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
                if (wSDLModel == null || wSDLModel.getState() == Model.State.NOT_WELL_FORMED) break;
                return wSDLModel.getDefinitions().getTargetNamespace();
            }
        }
        return null;
    }

    public static boolean isUniquePropertyName(WSDLModel wSDLModel, String string) {
        assert (wSDLModel != null && string != null);
        List list = wSDLModel.getDefinitions().getExtensibilityElements(CorrelationProperty.class);
        if (list == null || list.size() < 1) {
            return true;
        }
        for (CorrelationProperty correlationProperty : list) {
            if (!string.equals(correlationProperty.getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean isUniquePartnerLinkTypeName(WSDLModel wSDLModel, String string) {
        assert (wSDLModel != null && string != null);
        List list = wSDLModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class);
        if (list == null || list.size() < 1) {
            return true;
        }
        for (PartnerLinkType partnerLinkType : list) {
            if (!string.equals(partnerLinkType.getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean isUniquePartnerLinkTypeRoleName(PartnerLinkType partnerLinkType, String string) {
        assert (partnerLinkType != null && string != null);
        Role role = partnerLinkType.getRole1();
        Role role2 = role = role == null ? partnerLinkType.getRole2() : role;
        return role == null || !string.equals(role.getName());
    }

    public static void setQueryImpl(PropertyAlias propertyAlias, String string) {
        assert (propertyAlias != null);
        if (string == null) {
            return;
        }
        Query query = propertyAlias.getQuery();
        if (query == null) {
            WSDLModel wSDLModel = propertyAlias.getModel();
            if (wSDLModel == null) {
                return;
            }
            Query query2 = (Query)wSDLModel.getFactory().create((WSDLComponent)propertyAlias, BPELQName.QUERY.getQName());
            propertyAlias.addExtensibilityElement((ExtensibilityElement)query2);
        }
        if ((query = propertyAlias.getQuery()) != null) {
            query.setContent(string);
        }
    }

    public static void disableDefaultActionsInBeenTreeViews(Component component) {
        BeanTreeView beanTreeView = Util.findChildComponentOfClass(BeanTreeView.class, component);
        if (beanTreeView != null) {
            beanTreeView.setDefaultActionAllowed(false);
        }
    }

    public static Action createPreferredAction(final Component component) {
        Action action = new Action(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton;
                JRootPane jRootPane = SwingUtilities.getRootPane(component);
                if (jRootPane != null && (jButton = jRootPane.getDefaultButton()) != null && jButton.isEnabled()) {
                    jButton.doClick(200);
                }
            }

            public void performAction(Node[] nodeArray) {
            }

            public Object getValue(String string) {
                return null;
            }

            public void putValue(String string, Object object) {
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void setEnabled(boolean bl) {
            }

            public boolean isEnabled() {
                return true;
            }
        };
        return action;
    }

    public static void attachDefaultDblClickAction(final Component component, final Lookup.Provider provider) {
        Util.disableDefaultActionsInBeenTreeViews(component);
        final JTree jTree = Util.findChildComponentOfClass(JTree.class, component);
        if (jTree != null) {
            jTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n != -1 && SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                        JButton jButton;
                        JRootPane jRootPane;
                        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                        Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
                        if (node == null) {
                            return;
                        }
                        boolean bl = false;
                        NodesTreeParams nodesTreeParams = (NodesTreeParams)provider.getLookup().lookup(NodesTreeParams.class);
                        if (nodesTreeParams != null) {
                            bl = nodesTreeParams.isTargetNodeClass(node.getClass());
                        }
                        if (bl && (jRootPane = SwingUtilities.getRootPane(component)) != null && (jButton = jRootPane.getDefaultButton()) != null && jButton.isEnabled()) {
                            jButton.doClick(200);
                        }
                    }
                }
            });
        }
    }

    public static <T extends Component> T findChildComponentOfClass(Class<T> clazz, Component component) {
        if (clazz.isInstance(component)) {
            return (T)component;
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                T t = Util.findChildComponentOfClass(clazz, component2);
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }

    public static boolean isEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return object2.equals(object);
    }

    public static String getTargetNamespace(Model model) {
        try {
            if (model instanceof SchemaModel) {
                return ((SchemaModel)model).getSchema().getTargetNamespace();
            }
            if (model instanceof BpelModel) {
                return ((BpelModel)model).getProcess().getTargetNamespace();
            }
            if (model instanceof WSDLModel) {
                return ((WSDLModel)model).getDefinitions().getTargetNamespace();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

