/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.navigator;

import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.Documentation;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromPart;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.ToPart;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.DecorationProvider;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Reference;
import org.openide.util.NbBundle;

public interface TooltipManager {
    public boolean accept(NodeType var1, Object var2);

    public String getTooltip(NodeType var1, Object var2);

    public static class Util {
        private Util() {
        }

        public static String getDocumentations(ExtensibleElements extensibleElements) {
            Documentation[] documentationArray = extensibleElements.getDocumentations();
            if (documentationArray == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < documentationArray.length; ++i) {
                String string = documentationArray[i].getContent();
                if (string == null) continue;
                stringBuffer.append(string);
                if (i >= documentationArray.length - 1) continue;
                stringBuffer.append("<br>");
            }
            return stringBuffer == null ? null : stringBuffer.toString();
        }

        public static String getLocalizedAttribute(Reference reference, String string) {
            if (reference == null) {
                return "";
            }
            string = string == null ? "" : string;
            return NbBundle.getMessage(BpelNode.class, (String)"LBL_ATTRIBUTE_HTML_TEMPLATE", (Object)string, (Object)reference.getRefString());
        }

        public static String getLocalizedAttribute(String string, String string2) {
            if (string == null) {
                return "";
            }
            string2 = string2 == null ? "" : string2;
            string = string == null ? "" : string;
            return NbBundle.getMessage(BpelNode.class, (String)"LBL_ATTRIBUTE_HTML_TEMPLATE", (Object)string2, (Object)string);
        }

        public static String getAttributesTooltip(NodeType nodeType, Object object) {
            StringBuffer stringBuffer = new StringBuffer();
            Object var3_3 = null;
            switch (nodeType) {
                case INVOKE: {
                    assert (object instanceof Invoke);
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((Invoke)object).getOutputVariable(), "outputVariable"));
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((Invoke)object).getInputVariable(), "inputVariable"));
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((Invoke)object).getPartnerLink(), "partnerLink"));
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((Invoke)object).getOperation(), "operation"));
                    break;
                }
                case IMPORT: 
                case IMPORT_WSDL: 
                case IMPORT_SCHEMA: {
                    assert (object instanceof Import);
                    stringBuffer.append(Util.getLocalizedAttribute(((Import)object).getNamespace(), "namespace"));
                    break;
                }
                case FROM_PART: {
                    assert (object instanceof FromPart);
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((FromPart)object).getToVariable(), "toVariable"));
                    break;
                }
                case TO_PART: {
                    assert (object instanceof ToPart);
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((ToPart)object).getFromVariable(), "fromVariable"));
                    break;
                }
                case ON_EVENT: {
                    assert (object instanceof OnEvent);
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((OnEvent)object).getMessageExchange(), "messageExchange"));
                    break;
                }
                case MESSAGE_HANDLER: {
                    assert (object instanceof OnMessage);
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((OnMessage)object).getMessageExchange(), "messageExchange"));
                    break;
                }
                case PARTNER_LINK: {
                    assert (object instanceof PartnerLink);
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((PartnerLink)object).getMyRole(), "myRole"));
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((PartnerLink)object).getPartnerRole(), "partnerRole"));
                    break;
                }
                case RECEIVE: {
                    assert (object instanceof Receive);
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((Receive)object).getVariable(), "variable"));
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((Receive)object).getMessageExchange(), "messageExchange"));
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((Receive)object).getPartnerLink(), "partnerLink"));
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((Receive)object).getOperation(), "operation"));
                    break;
                }
                case REPLY: {
                    assert (object instanceof Reply);
                    stringBuffer.append(Util.getLocalizedAttribute((Reference)((Reply)object).getMessageExchange(), "messageExchange"));
                }
            }
            return stringBuffer.toString();
        }
    }

    public static class CopyTooltipManager
    implements TooltipManager {
        public boolean accept(NodeType nodeType, Object object) {
            if (!(object instanceof Copy)) {
                return false;
            }
            return NodeType.COPY == nodeType;
        }

        public String getTooltip(NodeType nodeType, Object object) {
            if (!this.accept(nodeType, object)) {
                return null;
            }
            Copy copy = (Copy)object;
            String string = null;
            String string2 = null;
            From from = copy.getFrom();
            To to = copy.getTo();
            if (from == null || to == null) {
                return "";
            }
            string = DecorationProvider.Util.getFromLabel(from);
            String string3 = DecorationProvider.Util.getEndpointReferenceLabelPart(from);
            if (string != null && string3 != null && string3.length() > 0) {
                string = "(" + string + string3 + ")";
            }
            string2 = DecorationProvider.Util.getToLabel(to);
            if (string == null && string2 == null) {
                return "";
            }
            string = string == null ? "" : org.netbeans.modules.bpel.editors.api.utils.Util.getCorrectedHtmlRenderedString((String)string);
            string2 = string2 == null ? "" : org.netbeans.modules.bpel.editors.api.utils.Util.getCorrectedHtmlRenderedString((String)string2);
            return NbBundle.getMessage(BpelNode.class, (String)"LBL_COPY_HTML_TOOLTIP", (Object)string2, (Object)string);
        }
    }

    public static class LongTooltipManager
    implements TooltipManager {
        public boolean accept(NodeType nodeType, Object object) {
            if (!(object instanceof BpelEntity)) {
                return false;
            }
            switch (nodeType) {
                case INVOKE: 
                case IMPORT: 
                case IMPORT_WSDL: 
                case IMPORT_SCHEMA: 
                case FROM_PART: 
                case TO_PART: 
                case ON_EVENT: 
                case MESSAGE_HANDLER: 
                case PARTNER_LINK: 
                case RECEIVE: 
                case REPLY: {
                    return true;
                }
            }
            return false;
        }

        public String getTooltip(NodeType nodeType, Object object) {
            if (!this.accept(nodeType, object)) {
                return null;
            }
            String string = null;
            if (object instanceof ExtensibleElements) {
                string = Util.getDocumentations((ExtensibleElements)object);
            }
            String string2 = object instanceof Named ? ((Named)object).getName() : "";
            string2 = string2 == null ? "" : string2;
            return string == null || "".equals(string) ? NbBundle.getMessage(BpelNode.class, (String)"LBL_LONG_TOOLTIP_HTML_TEMPLATE", (Object)nodeType.getDisplayName(), (Object)string2, (Object)Util.getAttributesTooltip(nodeType, object)) : NbBundle.getMessage(BpelNode.class, (String)"LBL_LONG_TOOLTIP_WITHDOCS_HTML_TEMPLATE", (Object[])new String[]{nodeType.getDisplayName(), string2, string, Util.getAttributesTooltip(nodeType, object)});
        }
    }

    public static class ShortTooltipManager
    implements TooltipManager {
        public boolean accept(NodeType nodeType, Object object) {
            return object instanceof Component;
        }

        public String getTooltip(NodeType nodeType, Object object) {
            if (!this.accept(nodeType, object)) {
                return null;
            }
            String string = null;
            if (object instanceof ExtensibleElements) {
                string = Util.getDocumentations((ExtensibleElements)object);
            }
            String string2 = object instanceof Named ? ((Named)object).getName() : "";
            string2 = string2 == null ? "" : string2;
            return string == null || "".equals(string) ? NbBundle.getMessage(BpelNode.class, (String)"LBL_SHORT_TOOLTIP_HTML_TEMPLATE", (Object)nodeType.getDisplayName(), (Object)string2) : NbBundle.getMessage(BpelNode.class, (String)"LBL_SHORT_TOOLTIP_WITHDOCS_HTML_TEMPLATE", (Object)nodeType.getDisplayName(), (Object)string2, (Object)string);
        }
    }
}

