/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.actions;

import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.nodes.PartnerLinkNode;
import org.netbeans.modules.bpel.nodes.actions.BpelNodeAction;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.xam.Model;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class OpenPartnerLinkInEditor
extends BpelNodeAction {
    private static final long serialVersionUID = 1L;

    protected String getBundleName() {
        return NbBundle.getMessage(OpenPartnerLinkInEditor.class, (String)"CTL_OpenPartnerLinkInEditor");
    }

    public void performAction(Node[] nodeArray) {
        if (!this.enable(nodeArray)) {
            return;
        }
        PartnerLink partnerLink = (PartnerLink)((PartnerLinkNode)nodeArray[0]).getReference();
        if (partnerLink == null) {
            return;
        }
        WSDLReference wSDLReference = partnerLink.getPartnerLinkType();
        if (wSDLReference == null) {
            return;
        }
        WSDLModel wSDLModel = ((PartnerLinkType)wSDLReference.get()).getModel();
        FileObject fileObject = Util.getFileObjectByModel((Model)wSDLModel);
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            final Line line = lineCookie.getLineSet().getOriginal(1);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    line.show(2);
                }
            });
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
    }

    public boolean isChangeAction() {
        return false;
    }

    public boolean enable(BpelEntity[] bpelEntityArray) {
        if (!super.enable(bpelEntityArray)) {
            return false;
        }
        return bpelEntityArray[0] instanceof PartnerLink;
    }

    public ActionType getType() {
        return ActionType.OPEN_IN_EDITOR;
    }

    protected void performAction(BpelEntity[] bpelEntityArray) {
    }
}

