/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes;

import java.util.concurrent.Callable;
import org.netbeans.modules.bpel.editors.api.BpelEditorConstants;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.TimeEvent;
import org.netbeans.modules.bpel.model.api.TimeEventHolder;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnAlarmNode
extends BpelNode<TimeEventHolder> {
    public OnAlarmNode(TimeEventHolder timeEventHolder, Lookup lookup) {
        super(timeEventHolder, lookup);
    }

    public OnAlarmNode(TimeEventHolder timeEventHolder, Children children, Lookup lookup) {
        super(timeEventHolder, children, lookup);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ALARM_HANDLER;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (this.getReference() == null) {
            return sheet;
        }
        Sheet.Set set = this.getPropertySet(sheet, Constants.PropertiesGroups.MAIN_SET);
        PropertyUtils.registerCalculatedProperty((Object)this, set, PropertyType.ALARM_TYPE, "getAlarmType", "setAlarmType");
        PropertyUtils.registerElementProperty(this, null, set, For.class, PropertyType.FOR_EXPRESSION, "getTimeEvent", "setTimeEvent", null);
        PropertyUtils.registerElementProperty(this, null, set, DeadlineExpression.class, PropertyType.UNTIL_EXPRESSION, "getTimeEvent", "setTimeEvent", null);
        this.updateAlarmTypeState(null, sheet.toArray());
        PropertyUtils.registerProperty(this, set, PropertyType.DOCUMENTATION, "getDocumentation", "setDocumentation", "removeDocumentation");
        return sheet;
    }

    public BpelEditorConstants.AlarmType getAlarmType() {
        TimeEventHolder timeEventHolder = (TimeEventHolder)this.getReference();
        if (timeEventHolder == null) {
            return null;
        }
        TimeEvent timeEvent = timeEventHolder.getTimeEvent();
        BpelEditorConstants.AlarmType alarmType = BpelEditorConstants.AlarmType.INVALID;
        if (timeEvent == null) {
            alarmType = BpelEditorConstants.AlarmType.NOT_ASSIGNED;
        } else if (timeEvent != null) {
            if (timeEvent instanceof For) {
                alarmType = BpelEditorConstants.AlarmType.FOR_TIME;
            } else if (timeEvent instanceof DeadlineExpression) {
                alarmType = BpelEditorConstants.AlarmType.UNTIL_TIME;
            }
        }
        return alarmType;
    }

    public void setAlarmType(BpelEditorConstants.AlarmType alarmType) throws Exception {
        BpelEditorConstants.AlarmType alarmType2 = this.getAlarmType();
        if (alarmType == alarmType2) {
            return;
        }
        final TimeEventHolder timeEventHolder = (TimeEventHolder)this.getReference();
        if (timeEventHolder == null) {
            return;
        }
        BpelModel bpelModel = timeEventHolder.getBpelModel();
        final BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
        switch (alarmType) {
            case FOR_TIME: {
                bpelModel.invoke(new Callable(){

                    public Object call() throws Exception {
                        TimeEvent timeEvent = timeEventHolder.getTimeEvent();
                        if (timeEvent == null || !(timeEvent instanceof For)) {
                            timeEventHolder.setTimeEvent((TimeEvent)bPELElementsBuilder.createFor());
                        }
                        return null;
                    }
                }, (Object)this);
                break;
            }
            case UNTIL_TIME: {
                bpelModel.invoke(new Callable(){

                    public Object call() throws Exception {
                        TimeEvent timeEvent = timeEventHolder.getTimeEvent();
                        if (timeEvent == null || !(timeEvent instanceof DeadlineExpression)) {
                            timeEventHolder.setTimeEvent((TimeEvent)bPELElementsBuilder.createUntil());
                        }
                        return null;
                    }
                }, (Object)this);
                break;
            }
        }
        this.updateAlarmTypeState(this.getAlarmType(), this.getPropertySets());
    }

    public void updateAlarmTypeState(BpelEditorConstants.AlarmType alarmType, Node.PropertySet[] propertySetArray) {
        if (alarmType == null) {
            alarmType = this.getAlarmType();
        }
        boolean bl = true;
        boolean bl2 = true;
        switch (alarmType) {
            case FOR_TIME: {
                bl = false;
                bl2 = true;
                break;
            }
            case UNTIL_TIME: {
                bl = true;
                bl2 = false;
                break;
            }
            case NOT_ASSIGNED: 
            case INVALID: {
                bl = true;
                bl2 = true;
            }
        }
        Node.Property property = PropertyUtils.lookForPropertyByType(propertySetArray, PropertyType.FOR_EXPRESSION);
        if (property != null) {
            property.setHidden(bl);
        }
        if ((property = PropertyUtils.lookForPropertyByType(propertySetArray, PropertyType.UNTIL_EXPRESSION)) != null) {
            property.setHidden(bl2);
        }
        this.firePropertySetsChange(null, null);
    }

    @Override
    protected ActionType[] getActionsArray() {
        return new ActionType[]{ActionType.ADD_FROM_PALETTE, ActionType.SEPARATOR, ActionType.GO_TO, ActionType.SEPARATOR, ActionType.TOGGLE_BREAKPOINT, ActionType.SEPARATOR, ActionType.REMOVE, ActionType.SEPARATOR, ActionType.PROPERTIES};
    }

    @Override
    public String getHelpId() {
        return "orch_elements_event_handler_onalarm";
    }
}

