/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.selection;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.elements.ContentElement;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.EntitySelectionModel;

public class GhostSelection
implements ActionListener {
    private DesignView designView;
    private Area ghostArea;
    private JLabel label;
    private float currentX;
    private float currentY;
    private boolean enabled;
    private Timer timer;
    private int iteration;
    private static int RESIZE_TIME = 300;
    private static int ITERATION_COUNT = 10;
    private static final Color ENABLED_COLOR = new Color(6133852);
    private static final Color DISABLED_COLOR = new Color(0xCC0000);
    private static double MAXIMUM_GHOST_SIZE = 160.0;
    private static final Icon ERROR_BADGE = new ImageIcon(DesignView.class.getResource("resources/error_badge.png"));

    public GhostSelection(DesignView designView) {
        this.designView = designView;
        this.timer = new Timer(RESIZE_TIME / ITERATION_COUNT, this);
    }

    public void init(String string, Point point) {
        FPoint fPoint = this.designView.getOverlayView().convertScreenToDiagram(point);
        this.currentX = fPoint.x;
        this.currentY = fPoint.y;
        this.label = new JLabel(string);
        this.label.setIcon(ERROR_BADGE);
        this.label.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.label.setBackground(new Color(0xFFFFDD));
        this.label.setOpaque(true);
        this.label.setFont(this.label.getFont().deriveFont(1));
        this.label.setForeground(Color.RED);
        this.ghostArea = null;
    }

    public void initCentered(Pattern pattern, Point point) {
        FPoint fPoint = this.designView.getOverlayView().convertScreenToDiagram(point);
        this.label = null;
        this.currentX = fPoint.x;
        this.currentY = fPoint.y;
        this.enabled = false;
        this.iteration = 0;
        this.ghostArea = pattern != null ? pattern.createSelection() : new Area(ContentElement.TASK_SHAPE);
        Rectangle2D rectangle2D = this.ghostArea.getBounds2D();
        double d = Math.max(rectangle2D.getWidth(), rectangle2D.getHeight());
        double d2 = Math.min(MAXIMUM_GHOST_SIZE / d, 1.0);
        double d3 = rectangle2D.getCenterX();
        double d4 = rectangle2D.getCenterY();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.currentX, this.currentY);
        affineTransform.scale(d2, d2);
        affineTransform.translate(-d3, -d4);
        this.ghostArea.transform(affineTransform);
        this.getDesignView().repaint();
    }

    public void init(Pattern pattern, Point point) {
        FPoint fPoint = this.designView.getOverlayView().convertScreenToDiagram(point);
        this.label = null;
        this.currentX = fPoint.x;
        this.currentY = fPoint.y;
        this.iteration = 0;
        this.ghostArea = pattern != null ? pattern.createSelection() : new Area(ContentElement.TASK_SHAPE);
        Rectangle2D rectangle2D = this.ghostArea.getBounds2D();
        this.timer.restart();
        this.getDesignView().repaint();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void move(FPoint fPoint) {
        this.move(fPoint.x, fPoint.y);
    }

    public void move(float f, float f2) {
        if (this.moveImpl(f, f2)) {
            this.getDesignView().repaint();
        }
    }

    private boolean moveImpl(float f, float f2) {
        if (this.isEmpty()) {
            return false;
        }
        double d = f - this.currentX;
        double d2 = f2 - this.currentY;
        if (d == 0.0 && d2 == 0.0) {
            return false;
        }
        if (this.ghostArea != null) {
            this.ghostArea.transform(AffineTransform.getTranslateInstance(d, d2));
        }
        this.currentX = f;
        this.currentY = f2;
        return true;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.ghostArea = null;
        this.label = null;
        this.iteration = 0;
        this.getDesignView().repaint();
    }

    public boolean isEmpty() {
        return this.ghostArea == null && this.label == null;
    }

    public DesignView getDesignView() {
        return this.designView;
    }

    public EntitySelectionModel getSelectionModel() {
        return this.getDesignView().getSelectionModel();
    }

    public void paint(Graphics2D graphics2D) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.ghostArea == null) {
            this.timer.stop();
            return;
        }
        int n = Math.max(1, ITERATION_COUNT - this.iteration++);
        Rectangle2D rectangle2D = this.ghostArea.getBounds2D();
        double d = Math.max(rectangle2D.getWidth(), rectangle2D.getHeight());
        if (d > MAXIMUM_GHOST_SIZE) {
            double d2 = Math.pow(MAXIMUM_GHOST_SIZE / d, 1.0 / (double)n);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.currentX, this.currentY);
            affineTransform.scale(d2, d2);
            affineTransform.translate(-this.currentX, -this.currentY);
            this.ghostArea.transform(affineTransform);
        } else {
            this.timer.stop();
        }
        if (n == 1) {
            this.timer.stop();
        }
        this.getDesignView().repaint();
    }
}

