/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.providers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.netbeans.modules.bpel.core.annotations.AnnotationListener;
import org.netbeans.modules.bpel.core.annotations.AnnotationManagerCookie;
import org.netbeans.modules.bpel.core.annotations.DiagramAnnotation;
import org.netbeans.modules.bpel.core.debugger.DebuggerHelper;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.decoration.ComponentsDescriptor;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.DecorationProvider;
import org.netbeans.modules.bpel.design.decoration.Descriptor;
import org.netbeans.modules.bpel.design.decoration.DimmDescriptor;
import org.netbeans.modules.bpel.design.decoration.GlowDescriptor;
import org.netbeans.modules.bpel.design.decoration.Positioner;
import org.netbeans.modules.bpel.design.decoration.StripeDescriptor;
import org.netbeans.modules.bpel.design.decoration.components.ButtonRenderer;
import org.netbeans.modules.bpel.design.decoration.components.DecorationComponent;
import org.netbeans.modules.bpel.design.decoration.components.DecorationLabel;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.connections.MessageConnection;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.xml.xam.Model;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DebuggerDecorationProvider
extends DecorationProvider
implements AnnotationListener,
ChangeEventListener {
    private AnnotationManagerCookie cookie;
    private Positioner breakpointPositioner = new Positioner(){

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            VisualElement visualElement = pattern.getFirstElement();
            if (visualElement != null && collection.size() == 1) {
                Component component = collection.iterator().next();
                List<Connection> list = visualElement.getIncomingConnections();
                FBounds fBounds = pattern.getBounds();
                for (Connection connection : list) {
                    if (connection instanceof MessageConnection || connection.getTargetDirection() != Direction.TOP) continue;
                    DiagramView diagramView = pattern.getView();
                    Point point = diagramView.convertDiagramToScreen(new FPoint(connection.getEndPoint().x, fBounds.y));
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(point.x - dimension.width / 2 + 1, point.y - dimension.height / 2, dimension.width, dimension.height);
                    return;
                }
            }
            ComponentsDescriptor.TOP_CENTER.position(pattern, collection, d);
        }
    };
    private Positioner currentlyExecutingPositioner = new Positioner(){

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            FBounds fBounds = 2.getPatternBounds(pattern);
            DiagramView diagramView = pattern.getView();
            Point point = diagramView.convertDiagramToScreen(fBounds.getTopLeft());
            Point point2 = diagramView.convertDiagramToScreen(fBounds.getBottomRight());
            for (Component component : collection) {
                component.setBounds(point.x, point.y, point2.x - point.x, point2.y - point.y);
            }
        }
    };
    public static final String NEVER_EXECUTED_ELEMENT = "NeverExecutedElement";
    public static final String STARTED_ELEMENT = "StartedElement";
    public static final String COMPLETED_ELEMENT = "CompletedElement";
    public static final String FAULTED_ELEMENT = "FaultedElement";
    public static final String CURRENT_POSITION = "CurrentPC";
    public static final String CURRENTLY_EXECUTING = "CurrentlyExecuting";
    public static final String ENABLED_BREAKPOINT = "BpelBreakpoint_normal";
    public static final String DISABLED_BREAKPOINT = "BpelBreakpoint_disabled";
    private static final Decoration DECORATE_CURRENT_POSITION = new Decoration(new Descriptor[]{new GlowDescriptor(new Color(65280))});
    private static final Icon ENABLED_BREAKPOINT_ICON = new ImageIcon(Decoration.class.getResource("resources/enabled_breakpoint.png"));
    private static final Icon DISABLED_BREAKPOINT_ICON = new ImageIcon(Decoration.class.getResource("resources/disabled_breakpoint.png"));
    private static final Icon STARTED_ELEMENT_ICON = new ImageIcon(Decoration.class.getResource("resources/execution.png"));
    private static final Icon COMPLETED_ELEMENT_ICON = new ImageIcon(Decoration.class.getResource("resources/execution_ok.png"));
    private static final Icon FAULTED_ELEMENT_ICON = new ImageIcon(Decoration.class.getResource("resources/execution_faild.png"));

    public DebuggerDecorationProvider(DesignView designView) {
        super(designView);
        DataObject dataObject = (DataObject)designView.getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            this.cookie = (AnnotationManagerCookie)dataObject.getCookie(AnnotationManagerCookie.class);
        }
        this.cookie.addAnnotationListener((AnnotationListener)this);
        designView.getBPELModel().addEntityChangeListener((ChangeEventListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DebuggerDecorationProvider.this.getDesignView().getBPELModel().getState() == Model.State.VALID) {
                    DebuggerDecorationProvider.this.fireDecorationChanged();
                }
            }
        });
    }

    public void release() {
        this.cookie.removeAnnotationListener((AnnotationListener)this);
        this.getDesignView().getBPELModel().removeEntityChangeListener((ChangeEventListener)this);
    }

    public Decoration getDecoration(BpelEntity bpelEntity) {
        if (!this.isDiagramEntity(bpelEntity)) {
            return null;
        }
        DiagramAnnotation[] diagramAnnotationArray = this.cookie.getAnnotations(bpelEntity.getUID());
        Decoration decoration = new Decoration();
        for (DiagramAnnotation diagramAnnotation : diagramAnnotationArray) {
            ComponentsDescriptor componentsDescriptor;
            String string = diagramAnnotation.getAnnotationType();
            Decoration decoration2 = null;
            if (string.equals(CURRENT_POSITION)) {
                decoration2 = DECORATE_CURRENT_POSITION;
            } else if (string.equals(CURRENTLY_EXECUTING)) {
                componentsDescriptor = new ComponentsDescriptor();
                componentsDescriptor.add(new InfiniteRoundProgress(), this.currentlyExecutingPositioner);
                decoration2 = new Decoration(new Descriptor[]{componentsDescriptor});
            } else if (string.equals(ENABLED_BREAKPOINT)) {
                componentsDescriptor = new ComponentsDescriptor();
                componentsDescriptor.add(new BreakpointButton(ENABLED_BREAKPOINT_ICON, bpelEntity, this.getDesignView()), this.breakpointPositioner);
                decoration2 = new Decoration(new Descriptor[]{componentsDescriptor, StripeDescriptor.createBreakpoint()});
            } else if (string.equals(DISABLED_BREAKPOINT)) {
                componentsDescriptor = new ComponentsDescriptor();
                componentsDescriptor.add(new BreakpointButton(DISABLED_BREAKPOINT_ICON, bpelEntity, this.getDesignView()), this.breakpointPositioner);
                decoration2 = new Decoration(new Descriptor[]{componentsDescriptor});
            } else if (string.equals(STARTED_ELEMENT)) {
                componentsDescriptor = new ComponentsDescriptor();
                componentsDescriptor.add(new DecorationLabel(STARTED_ELEMENT_ICON, 0), ComponentsDescriptor.LEFT_TB);
                decoration2 = new Decoration(new Descriptor[]{componentsDescriptor});
            } else if (string.equals(COMPLETED_ELEMENT)) {
                componentsDescriptor = new ComponentsDescriptor();
                componentsDescriptor.add(new DecorationLabel(COMPLETED_ELEMENT_ICON, 0), ComponentsDescriptor.LEFT_TB);
                decoration2 = new Decoration(new Descriptor[]{componentsDescriptor});
            } else if (string.equals(FAULTED_ELEMENT)) {
                componentsDescriptor = new ComponentsDescriptor();
                componentsDescriptor.add(new DecorationLabel(FAULTED_ELEMENT_ICON, 0), ComponentsDescriptor.LEFT_TB);
                decoration2 = new Decoration(new Descriptor[]{componentsDescriptor});
            } else if (string.equals(NEVER_EXECUTED_ELEMENT)) {
                decoration2 = new Decoration(new Descriptor[]{new DimmDescriptor()});
            }
            if (decoration2 == null) continue;
            decoration.combineWith(decoration2);
        }
        return decoration;
    }

    public void notifyPropertyUpdated(final PropertyUpdateEvent propertyUpdateEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (propertyUpdateEvent.getName().equals("<state>") && propertyUpdateEvent.getNewValue().equals(Model.State.VALID)) {
                    DebuggerDecorationProvider.this.fireDecorationChanged();
                }
            }
        });
    }

    public void annotationAdded(DiagramAnnotation diagramAnnotation) {
        this.updateDecorations(diagramAnnotation);
    }

    public void annotationRemoved(DiagramAnnotation diagramAnnotation) {
        this.updateDecorations(diagramAnnotation);
    }

    public void notifyPropertyRemoved(PropertyRemoveEvent propertyRemoveEvent) {
    }

    public void notifyEntityInserted(EntityInsertEvent entityInsertEvent) {
    }

    public void notifyEntityRemoved(EntityRemoveEvent entityRemoveEvent) {
    }

    public void notifyEntityUpdated(EntityUpdateEvent entityUpdateEvent) {
    }

    public void notifyArrayUpdated(ArrayUpdateEvent arrayUpdateEvent) {
    }

    private boolean isDiagramEntity(BpelEntity bpelEntity) {
        if (bpelEntity == null || bpelEntity.getModel() == null) {
            return false;
        }
        Pattern pattern = this.getDesignView().getModel().getPattern(bpelEntity);
        return pattern != null && pattern.isInModel();
    }

    private void updateDecorations(DiagramAnnotation diagramAnnotation) {
        final BpelModel bpelModel = diagramAnnotation.getBpelEntityId().getModel();
        Runnable runnable = new Runnable(){

            public void run() {
                if (bpelModel.getState().equals((Object)Model.State.VALID)) {
                    DebuggerDecorationProvider.this.fireDecorationChanged();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static final class InfiniteRoundProgress
    extends JComponent
    implements HierarchyListener,
    ActionListener,
    DecorationComponent {
        private float angleStart = 0.0f;
        private float angleLimit = (float)Math.PI * 2;
        private float angleCorrection = -0.06283186f;
        private float colorStart = 1.0f;
        private float colorLimit = 0.0f;
        private int steps = 10;
        private Timer timer = new Timer(75, this);
        private static final long serialVersionUID = 1L;

        public InfiniteRoundProgress() {
            this.addHierarchyListener(this);
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            RenderingHints renderingHints2 = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHints(renderingHints2);
            Rectangle rectangle = this.getBounds();
            float f = rectangle.width / 2;
            float f2 = rectangle.height / 2;
            float f3 = rectangle.width < rectangle.height ? (float)rectangle.width : (float)rectangle.height;
            float f4 = f3 / 6.0f;
            float f5 = f3 / 6.0f;
            float f6 = f3 / 30.0f;
            float f7 = (this.angleLimit - this.angleStart) / (float)this.steps;
            float f8 = (this.colorLimit - this.colorStart) / (float)this.steps;
            for (int i = 0; i < this.steps; ++i) {
                float f9 = this.angleStart + f7 * (float)i;
                float f10 = this.colorStart + f8 * (float)i;
                graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, f10));
                graphics2D.setStroke(new BasicStroke(2.0f));
                this.paintTile((Graphics2D)graphics, f, f2, f9, f4, f5, f6);
            }
            graphics2D.setRenderingHints(renderingHints);
        }

        private void paintTile(Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, float f6) {
            float f7 = (float)Math.sin(f3);
            float f8 = (float)Math.cos(f3);
            float f9 = (float)((double)f6 * 2.0);
            float f10 = f6 * f7;
            float f11 = f6 * f8;
            float f12 = f4 * f7;
            float f13 = f4 * f8;
            float f14 = (f4 + f5) * f7;
            float f15 = (f4 + f5) * f8;
            if (f6 < 1.0f) {
                graphics2D.draw(new Line2D.Float(f + f13, f2 - f12, f + f15, f2 - f14));
                return;
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f + f13 + f10, f2 - f12 + f11);
            generalPath.lineTo(f + f13 - f10, f2 - f12 - f11);
            generalPath.lineTo(f + f15 - f10, f2 - f14 - f11);
            generalPath.lineTo(f + f15 + f10, f2 - f14 + f11);
            generalPath.closePath();
            Ellipse2D.Float float_ = new Ellipse2D.Float(f + f13 - f6, f2 - f12 - f6, f9, f9);
            Ellipse2D.Float float_2 = new Ellipse2D.Float(f + f15 - f6, f2 - f14 - f6, f9, f9);
            Area area = new Area(generalPath);
            Area area2 = new Area(float_);
            Area area3 = new Area(float_2);
            area.add(area2);
            area.add(area3);
            graphics2D.fill(area);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.angleLimit += this.angleCorrection;
            this.angleStart += this.angleCorrection;
            this.invalidate();
            this.repaint();
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 1L) > 0L) {
                if (this.getParent() == null) {
                    this.timer.stop();
                } else {
                    this.timer.start();
                }
            }
        }
    }

    public static final class BreakpointButton
    extends JButton
    implements DecorationComponent {
        private Icon myIcon;
        private Node myNode;
        private BpelEntity myEntity;
        private static final Color BACKGROUND = new Color(-855638017, true);
        private static final long serialVersionUID = 1L;

        public BreakpointButton(Icon icon, BpelEntity bpelEntity, DesignView designView) {
            super(icon);
            this.myIcon = icon;
            this.myEntity = bpelEntity;
            this.myNode = designView.getNodeForPattern(designView.getModel().getPattern(bpelEntity));
            this.setOpaque(false);
            this.setBorder(null);
            this.setRolloverEnabled(true);
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setPreferredSize(new Dimension(this.myIcon.getIconWidth() + 6, this.myIcon.getIconHeight() + 6));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DebuggerHelper debuggerHelper = (DebuggerHelper)Lookup.getDefault().lookup(DebuggerHelper.class);
                    debuggerHelper.toggleBreakpointEnabledState(BreakpointButton.this.myNode, BreakpointButton.this.myEntity);
                }
            });
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public String getToolTipText() {
            if (this.myIcon == ENABLED_BREAKPOINT_ICON) {
                return NbBundle.getMessage(DebuggerDecorationProvider.class, (String)"LBL_Disable_Breakpoint");
            }
            return NbBundle.getMessage(DebuggerDecorationProvider.class, (String)"LBL_Enable_Breakpoint");
        }

        protected void paintComponent(Graphics graphics) {
            ButtonModel buttonModel = this.getModel();
            if (buttonModel.isPressed()) {
                ButtonRenderer.paintButton(this, graphics, ButtonRenderer.PRESSED_FILL_COLOR, false, ButtonRenderer.PRESSED_BORDER_COLOR, 1.3f, this.myIcon);
            } else if (buttonModel.isRollover()) {
                ButtonRenderer.paintButton(this, graphics, ButtonRenderer.ROLLOVER_FILL_COLOR, true, ButtonRenderer.ROLLOVER_BORDER_COLOR, 1.0f, this.myIcon);
            } else if (buttonModel.isSelected()) {
                ButtonRenderer.paintButton(this, graphics, BACKGROUND, false, ButtonRenderer.PRESSED_BORDER_COLOR, 1.3f, this.myIcon);
            } else {
                ButtonRenderer.paintButton(this, graphics, BACKGROUND, false, null, 1.0f, this.myIcon);
            }
        }
    }
}

