/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TriScrollPane
extends JScrollPane {
    private JComponent left;
    private JComponent right;
    private JComponent center;
    private JComponent handToolPanel;
    private JComponent overlayPanel;
    private SideComponent leftComponent;
    private SideComponent rightComponent;
    private boolean layoutNow = false;
    private ArrayList<ScrollListener> scrollListeners = new ArrayList(1);
    private static final Border LEFT_SIDE_BORDER = new Border(){

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            graphics.setColor(component.getBackground().darker());
            graphics.drawLine(n5, n2, n5, n6);
            graphics.setColor(color);
        }
    };
    private static final Border RIGHT_SIDE_BORDER = new Border(){

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 1, 0, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n2 + n4 - 1;
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawLine(n, n2, n, n5);
            graphics.setColor(color);
        }
    };
    private ChangeListener myScrollListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() != TriScrollPane.this.getViewport()) {
                TriScrollPane.this.center.repaint();
            }
            for (ScrollListener scrollListener : TriScrollPane.this.scrollListeners) {
                scrollListener.viewScrolled(null);
            }
        }
    };
    private static final int BUTTON_SIZE = 23;
    private static final int BUTTON_PADDING = 4;
    private static final int BUTTON_MARGIN = 4;
    private static final Color BUTTON_FILL = new Color(-1999844148, true);
    private static final Color BUTTON_STROKE = new Color(-2004318072, true);
    private static final Color BUTTON_ROLLOVER_FILL = new Color(0xCCCCCC);
    private static final Color BUTTON_ROLLOVER_STROKE = new Color(0x888888);
    private static final Color BUTTON_PRESSED_FILL = new Color(0xBBBBBB);
    private static final Color BUTTON_PRESSED_STROKE = new Color(0x888888);
    private static final Color ICON_COLOR = new Color(-1996488705, true);
    private static final Color ICON_COLOR_ROLLOVER = new Color(0xFFFFFF);
    private static final float COS_30 = (float)Math.cos(0.5235987755982988);
    private static final float SIN_30 = (float)Math.sin(0.5235987755982988);
    private static final Color SIDE_BACKGROUND = new Color(0x44000000 | new Color(16579317).darker().getRGB() & 0xFFFFFF, true);

    public TriScrollPane(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5) {
        super(jComponent);
        this.setBorder(null);
        this.handToolPanel = jComponent4;
        this.overlayPanel = jComponent5;
        this.left = jComponent2;
        this.right = jComponent3;
        this.center = jComponent;
        jComponent2.setBackground(SIDE_BACKGROUND);
        jComponent3.setBackground(SIDE_BACKGROUND);
        this.leftComponent = new SideComponent(jComponent2);
        this.rightComponent = new SideComponent(jComponent3);
        this.add((Component)this.leftComponent, 0);
        this.add((Component)this.rightComponent, 0);
        if (jComponent5 != null) {
            this.add((Component)jComponent5, 0);
        }
        if (jComponent4 != null) {
            this.add((Component)jComponent4, 0);
        }
        this.getVerticalScrollBar().setUnitIncrement(10);
        this.getHorizontalScrollBar().setUnitIncrement(10);
        this.getViewport().setScrollMode(0);
        this.getViewport().addChangeListener(this.myScrollListener);
        this.leftComponent.getViewport().addChangeListener(this.myScrollListener);
        this.rightComponent.getViewport().addChangeListener(this.myScrollListener);
    }

    public int getLeftPreferredWidth() {
        return this.left.isVisible() ? this.leftComponent.getPreferredSize().width : 0;
    }

    public int getRightPreferredWidth() {
        return this.right.isVisible() ? this.rightComponent.getPreferredSize().width : 0;
    }

    public void addScrollListener(ScrollListener scrollListener) {
        this.scrollListeners.add(scrollListener);
    }

    public void removeScrollListener(ScrollListener scrollListener) {
        this.scrollListeners.remove(scrollListener);
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void doLayout() {
        super.doLayout();
        boolean bl = this.left.isVisible();
        boolean bl2 = this.right.isVisible();
        int n = !bl ? 0 : this.leftComponent.getPreferredSize().width;
        int n2 = !bl2 ? 0 : this.rightComponent.getPreferredSize().width;
        Rectangle rectangle = this.getViewport().getBounds();
        if (bl) {
            this.leftComponent.setVisible(true);
            this.leftComponent.setBounds(rectangle.x, rectangle.y, n, rectangle.height);
        }
        if (bl2) {
            this.rightComponent.setVisible(true);
            this.rightComponent.setBounds(rectangle.x + rectangle.width - n2, rectangle.y, n2, rectangle.height);
        }
        if (this.overlayPanel != null) {
            this.overlayPanel.setBounds(rectangle);
        }
        if (this.handToolPanel != null) {
            this.handToolPanel.setBounds(rectangle);
        }
    }

    public JComponent getComponent(Point point) {
        if (this.rightComponent.getBounds().contains(point)) {
            return this.right;
        }
        if (this.leftComponent.getBounds().contains(point)) {
            return this.left;
        }
        if (this.viewport.getBounds().contains(point)) {
            return this.center;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        boolean bl = this.left.isVisible();
        boolean bl2 = this.right.isVisible();
        int n = !bl ? 0 : this.leftComponent.getPreferredSize().width;
        int n2 = !bl2 ? 0 : this.rightComponent.getPreferredSize().width;
        dimension.width = Math.max(dimension.width, n + 120 + n2);
        return dimension;
    }

    public static interface ScrollListener {
        public void viewScrolled(JComponent var1);
    }

    private static class DownButton
    extends ScrollButton {
        private DownButton() {
        }

        Shape createIconShape() {
            ButtonModel buttonModel = this.getModel();
            float f = 0.5f * (float)this.getWidth();
            float f2 = 0.5f * (float)this.getHeight();
            float f3 = -(Math.min(f, f2) - 6.5f);
            float f4 = f3 * COS_30;
            float f5 = f3 * SIN_30;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f, f2 - f3);
            generalPath.lineTo(f + f4, f2 + f5);
            generalPath.lineTo(f - f4, f2 + f5);
            generalPath.closePath();
            return generalPath;
        }
    }

    private static class UpButton
    extends ScrollButton {
        private UpButton() {
        }

        Shape createIconShape() {
            ButtonModel buttonModel = this.getModel();
            float f = 0.5f * (float)this.getWidth();
            float f2 = 0.5f * (float)this.getHeight();
            float f3 = Math.min(f, f2) - 6.5f;
            float f4 = f3 * COS_30;
            float f5 = f3 * SIN_30;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f, f2 - f3);
            generalPath.lineTo(f + f4, f2 + f5);
            generalPath.lineTo(f - f4, f2 + f5);
            generalPath.closePath();
            return generalPath;
        }
    }

    private static abstract class ScrollButton
    extends JButton {
        ScrollButton() {
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            this.setBorderPainted(false);
            this.setOpaque(false);
            this.setFocusable(false);
        }

        public boolean contains(int n, int n2) {
            double d;
            double d2;
            double d3 = 0.5 * (double)this.getWidth();
            double d4 = (double)n - d3;
            return d4 * d4 / d3 / d3 + (d2 = (double)n2 - (d = 0.5 * (double)this.getHeight())) * d2 / d / d <= 1.0;
        }

        public void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            ButtonModel buttonModel = this.getModel();
            Shape shape = this.createIconShape();
            if (buttonModel.isPressed()) {
                graphics2D.setPaint(BUTTON_PRESSED_FILL);
            } else if (buttonModel.isRollover()) {
                graphics2D.setPaint(BUTTON_ROLLOVER_FILL);
            } else {
                graphics2D.setPaint(BUTTON_FILL);
            }
            graphics2D.translate(0.5, 0.5);
            graphics2D.fillOval(0, 0, n - 1, n2 - 1);
            graphics2D.translate(-0.5, -0.5);
            if (buttonModel.isRollover()) {
                graphics2D.setPaint(ICON_COLOR_ROLLOVER);
            } else {
                graphics2D.setPaint(ICON_COLOR);
            }
            graphics2D.fill(shape);
            if (buttonModel.isPressed()) {
                graphics2D.setPaint(BUTTON_PRESSED_STROKE);
            } else if (buttonModel.isRollover()) {
                graphics2D.setPaint(BUTTON_ROLLOVER_STROKE);
            } else {
                graphics2D.setPaint(BUTTON_STROKE);
            }
            graphics2D.translate(0.5, 0.5);
            graphics2D.drawOval(0, 0, n - 1, n2 - 1);
            graphics2D.translate(-0.5, -0.5);
            graphics2D.draw(shape);
            graphics2D.dispose();
        }

        public Dimension getPreferredSize() {
            return new Dimension(23, 23);
        }

        abstract Shape createIconShape();
    }

    private static class SideComponent
    extends JScrollPane
    implements ChangeListener,
    MouseWheelListener,
    ActionListener {
        JButton scrollUpButton;
        JButton scrollDownButton;
        Timer scrollTimer;
        int scrollTimerDirection = 0;

        SideComponent(JComponent jComponent) {
            super(jComponent);
            this.setOpaque(false);
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(21);
            this.setBorder(null);
            this.getViewport().setScrollMode(0);
            this.getViewport().setOpaque(false);
            this.scrollUpButton = new UpButton();
            this.scrollDownButton = new DownButton();
            this.add((Component)this.scrollUpButton, 0);
            this.add((Component)this.scrollDownButton, 0);
            this.getViewport().addChangeListener(this);
            this.addMouseWheelListener(this);
            this.scrollUpButton.getModel().addChangeListener(this);
            this.scrollDownButton.getModel().addChangeListener(this);
            this.scrollTimer = new Timer(100, this);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = Math.max(dimension.width, 31);
            dimension.height = Math.max(dimension.height, 58);
            return dimension;
        }

        public void doLayout() {
            super.doLayout();
            int n = 0;
            int n2 = 0;
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            int n5 = n + (n3 - 23) / 2;
            this.scrollUpButton.setBounds(n5, n2 + 4, 23, 23);
            this.scrollDownButton.setBounds(n5, n2 + n4 - 23 - 4, 23, 23);
            this.updateButtonsVisibility();
        }

        private void updateButtonsVisibility() {
            JViewport jViewport = this.getViewport();
            Rectangle rectangle = jViewport.getViewRect();
            Dimension dimension = jViewport.getViewSize();
            this.scrollUpButton.setVisible(rectangle.y > 0);
            this.scrollDownButton.setVisible(rectangle.y + rectangle.height < dimension.height);
        }

        private void scroll(int n) {
            if (n == 0) {
                return;
            }
            int n2 = n * 10;
            JViewport jViewport = this.getViewport();
            Point point = jViewport.getViewPosition();
            int n3 = jViewport.getViewSize().height - jViewport.getExtentSize().height;
            point.y = Math.max(0, Math.min(point.y + n2, n3));
            jViewport.setViewPosition(point);
        }

        public boolean isOptimizedDrawingEnabled() {
            return false;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == this.getViewport()) {
                this.updateButtonsVisibility();
            } else if (changeEvent.getSource() == this.scrollUpButton.getModel()) {
                if (this.scrollUpButton.getModel().isPressed()) {
                    this.scrollTimerDirection = -3;
                    this.scroll(this.scrollTimerDirection);
                    this.scrollTimer.restart();
                } else {
                    this.scrollTimer.stop();
                }
            } else if (changeEvent.getSource() == this.scrollDownButton.getModel()) {
                if (this.scrollDownButton.getModel().isPressed()) {
                    this.scrollTimerDirection = 3;
                    this.scroll(this.scrollTimerDirection);
                    this.scrollTimer.restart();
                } else {
                    this.scrollTimer.stop();
                }
            }
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.scroll(mouseWheelEvent.getUnitsToScroll());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.scroll(this.scrollTimerDirection);
        }
    }
}

