/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.TriScrollPane;
import org.openide.util.NbBundle;

public class NavigationTools
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
FocusListener,
ActionListener {
    private DiagramView currentDiagramView;
    private DesignView designView;
    private Mode mode = Mode.OFF;
    private int toolX;
    private int toolY;
    private JToggleButton editingModeButton;
    private JToggleButton navigationModeButton;
    private ButtonGroup buttonGroup;
    private JComponent[] controllers;
    private static Icon HAND_TOOL_ICON = NavigationTools.loadIcon("hand_tool.png");
    private static Icon SELECT_TOOL_ICON = NavigationTools.loadIcon("select_tool.png");

    public NavigationTools(DesignView designView) {
        this.designView = designView;
        this.setFocusable(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBackground(null);
        this.setOpaque(false);
        this.setVisible(false);
        designView.getProcessView().addKeyListener(this);
        designView.getConsumersView().addKeyListener(this);
        designView.getProvidersView().addKeyListener(this);
        designView.getProcessView().addFocusListener(this);
        designView.getConsumersView().addFocusListener(this);
        designView.getProvidersView().addFocusListener(this);
        this.editingModeButton = new JToggleButton(SELECT_TOOL_ICON);
        this.editingModeButton.setSelected(true);
        this.editingModeButton.setFocusable(false);
        this.editingModeButton.setToolTipText(NavigationTools.getMessage("LBL_NavigationTools_EditingMode"));
        this.navigationModeButton = new JToggleButton(HAND_TOOL_ICON);
        this.navigationModeButton.setSelected(false);
        this.navigationModeButton.setFocusable(false);
        this.navigationModeButton.setToolTipText(NavigationTools.getMessage("LBL_NavigationTools_NavigationMode"));
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.editingModeButton);
        this.buttonGroup.add(this.navigationModeButton);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.editingModeButton.addActionListener(this);
        this.navigationModeButton.addActionListener(this);
        this.controllers = new JComponent[]{this.editingModeButton, this.navigationModeButton};
    }

    public int getControllersCount() {
        return this.controllers.length;
    }

    public JComponent getController(int n) {
        return this.controllers[n];
    }

    public DesignView getDesignView() {
        return this.designView;
    }

    private void turnOn(Mode mode) {
        this.mode = mode;
        this.setVisible(true);
    }

    private void turnOff() {
        this.mode = Mode.OFF;
        this.setVisible(false);
    }

    public void setEnabled(boolean bl) {
        this.editingModeButton.setEnabled(bl);
        this.navigationModeButton.setEnabled(bl);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 && this.mode == Mode.OFF) {
            this.turnOn(Mode.WEAK);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 && this.mode == Mode.WEAK) {
            this.turnOff();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.mode == Mode.WEAK) {
            this.turnOff();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWheelRotation() > 0) {
            this.getDesignView().getZoomManager().zoomIn(mouseWheelEvent.getX(), mouseWheelEvent.getY());
        } else {
            this.getDesignView().getZoomManager().zoomOut(mouseWheelEvent.getX(), mouseWheelEvent.getY());
        }
        Point point = this.getDesignView().getMousePosition(true);
        if (point != null) {
            this.toolX = point.x;
            this.toolY = point.y;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n - this.toolX;
        int n4 = n2 - this.toolY;
        this.toolX = n;
        this.toolY = n2;
        if (this.currentDiagramView != null) {
            Rectangle rectangle = this.currentDiagramView.getVisibleRect();
            rectangle.x -= n3;
            rectangle.y -= n4;
            this.currentDiagramView.scrollRectToVisible(rectangle);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TriScrollPane triScrollPane = (TriScrollPane)this.getParent();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        JViewport jViewport = (JViewport)this.designView.getProcessView().getParent();
        JComponent jComponent = (JComponent)this.designView.getConsumersView().getParent().getParent().getParent();
        JComponent jComponent2 = (JComponent)this.designView.getProvidersView().getParent().getParent().getParent();
        this.currentDiagramView = NavigationTools.contains(jViewport, n, n2) ? this.designView.getProcessView() : (NavigationTools.contains(jComponent, n, n2) ? this.designView.getConsumersView() : (NavigationTools.contains(jComponent2, n, n2) ? this.designView.getProvidersView() : null));
        this.toolX = mouseEvent.getX();
        this.toolY = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.currentDiagramView = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.navigationModeButton.isSelected()) {
            this.turnOn(Mode.STRONG);
        }
        if (this.editingModeButton.isSelected()) {
            this.turnOff();
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getBundle(NavigationTools.class).getString(string);
    }

    private static Icon loadIcon(String string) {
        return new ImageIcon(NavigationTools.class.getResource("resources/" + string));
    }

    private static boolean contains(Component component, int n, int n2) {
        if (!component.isVisible()) {
            return false;
        }
        return 0 <= (n -= component.getX()) && 0 <= (n2 -= component.getY()) && n < component.getWidth() && n2 < component.getHeight();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        OFF,
        WEAK,
        STRONG;

    }
}

