/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.JLabel;
import org.netbeans.modules.bpel.design.geometry.FBounds;

public class GUtils {
    private static final JLabel LABEL = new JLabel();

    public static Graphics2D createGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return graphics2D;
    }

    public static float getScale(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return 1.0f;
        }
        return (float)Math.hypot(affineTransform.getScaleX(), affineTransform.getShearY());
    }

    public static FBounds drawString(Graphics2D graphics2D, String string, double d, double d2, double d3) {
        float f = GUtils.getScale(graphics2D.getTransform());
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(font.getSize2D() * f);
        graphics2D.translate(d, d2);
        graphics2D.scale(1.0f / f, 1.0f / f);
        LABEL.setHorizontalAlignment(2);
        LABEL.setText(string);
        LABEL.setForeground(graphics2D.getColor());
        LABEL.setFont(font2);
        Dimension dimension = LABEL.getPreferredSize();
        int n = Math.min((int)Math.round(d3 * (double)f), dimension.width);
        int n2 = dimension.height;
        LABEL.setBounds(0, 0, n, n2);
        LABEL.paint(graphics2D);
        graphics2D.scale(f, f);
        graphics2D.translate(-d, -d2);
        graphics2D.setFont(font);
        return new FBounds(d, d2, (float)n / f, (float)n2 / f);
    }

    public static FBounds drawXCenteredString(Graphics2D graphics2D, String string, double d, double d2, double d3) {
        float f = GUtils.getScale(graphics2D.getTransform());
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(font.getSize2D() * f);
        LABEL.setHorizontalAlignment(0);
        LABEL.setText(string.trim());
        LABEL.setForeground(graphics2D.getColor());
        LABEL.setFont(font2);
        Dimension dimension = LABEL.getPreferredSize();
        int n = (int)Math.min(Math.round(d3 * (double)f), (long)dimension.width);
        int n2 = dimension.height;
        double d4 = d - (double)n / 2.0 / (double)f;
        graphics2D.translate(d4, d2);
        graphics2D.scale(1.0f / f, 1.0f / f);
        LABEL.setBounds(0, 0, n, n2);
        LABEL.paint(graphics2D);
        graphics2D.scale(f, f);
        graphics2D.translate(-d4, -d2);
        graphics2D.setFont(font);
        return new FBounds(d4, d2, (float)n / f, (float)n2 / f);
    }

    public static FBounds drawCenteredString(Graphics2D graphics2D, String string, double d, double d2, double d3) {
        float f = GUtils.getScale(graphics2D.getTransform());
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(font.getSize2D() * f);
        LABEL.setHorizontalAlignment(0);
        LABEL.setText(string);
        LABEL.setFont(font2);
        LABEL.setForeground(graphics2D.getColor());
        Dimension dimension = LABEL.getPreferredSize();
        int n = (int)Math.min(Math.round(d3 * (double)f), (long)dimension.width);
        int n2 = Math.round(dimension.height);
        double d4 = d - 0.5 * (double)n / (double)f;
        double d5 = d2 - 0.5 * (double)n2 / (double)f;
        graphics2D.translate(d4, d5);
        graphics2D.scale(1.0 / (double)f, 1.0 / (double)f);
        LABEL.setBounds(0, 0, n, n2);
        LABEL.paint(graphics2D);
        graphics2D.scale(f, f);
        graphics2D.translate(-d4, -d5);
        graphics2D.setFont(font);
        return new FBounds(d4, d5, (float)n / f, (float)n2 / f);
    }

    public static void drawGlow(Graphics2D graphics2D, Area area, double d, Color color) {
        Shape shape = graphics2D.getClip();
        Stroke stroke = graphics2D.getStroke();
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        AffineTransform affineTransform = graphics2D.getTransform();
        double d2 = (double)GUtils.getScale(graphics2D.getTransform()) * d;
        int n = Math.min(Math.max(2, (int)Math.floor(d2 / 1.4)), 8);
        Area area2 = new Area(shape);
        area2.subtract(area);
        graphics2D.setClip(area2);
        graphics2D.setPaint(color);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f / (float)n));
        d *= 2.0;
        for (int i = n - 1; i >= 0; --i) {
            double d3 = (double)(i + 1) / (double)n;
            graphics2D.setStroke(new BasicStroke((float)((Math.pow(2.0, d3) - 1.0) * d)));
            graphics2D.draw(area);
        }
        graphics2D.setComposite(composite);
        graphics2D.setStroke(stroke);
        graphics2D.setClip(shape);
        graphics2D.setPaint(paint);
    }
}

