/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.javawebstart.CustomizerRunComponent;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JWSCustomizerPanel
extends JPanel
implements HelpCtx.Provider {
    private JWSProjectProperties jwsProps;
    private File lastImageFolder = null;
    public static CustomizerRunComponent runComponent = new CustomizerRunComponent();
    private JButton browseButton;
    private JLabel codeBaseValueLabel;
    private JComboBox codebaseComboBox;
    private JLabel codebaseLabel;
    private JTextField codebaseTextField;
    private JCheckBox enableCheckBox;
    private JLabel iconLabel;
    private JTextField iconTextField;
    private JCheckBox offlineCheckBox;
    private JLabel panelDescLabel;
    private JCheckBox signedCheckBox;

    public JWSCustomizerPanel(JWSProjectProperties jWSProjectProperties) {
        this.jwsProps = jWSProjectProperties;
        this.initComponents();
        this.enableCheckBox.setModel(this.jwsProps.enabledModel);
        this.enableCheckBox.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.enableCheckBox.mnemonic").toCharArray()[0]);
        this.offlineCheckBox.setModel(this.jwsProps.allowOfflineModel);
        this.offlineCheckBox.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.offlineCheckBox.mnemonic").toCharArray()[0]);
        this.signedCheckBox.setModel(this.jwsProps.signedModel);
        this.signedCheckBox.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.signedCheckBox.mnemonic").toCharArray()[0]);
        this.iconTextField.setDocument(this.jwsProps.iconDocument);
        this.codebaseComboBox.setModel(this.jwsProps.codebaseModel);
        this.codebaseTextField.setDocument(this.jwsProps.codebaseURLDocument);
        this.setCodebaseComponents();
        boolean bl = this.enableCheckBox.getModel().isSelected();
        this.setEnabledAllComponents(bl);
        JWSCustomizerPanel.setEnabledRunComponent(bl);
    }

    private static void setEnabledRunComponent(boolean bl) {
        runComponent.setCheckboxEnabled(bl);
        runComponent.setHintVisible(!bl);
    }

    private void initComponents() {
        this.enableCheckBox = new JCheckBox();
        this.iconLabel = new JLabel();
        this.codebaseLabel = new JLabel();
        this.iconTextField = new JTextField();
        this.browseButton = new JButton();
        this.codebaseComboBox = new JComboBox();
        this.codeBaseValueLabel = new JLabel();
        this.codebaseTextField = new JTextField();
        this.offlineCheckBox = new JCheckBox();
        this.panelDescLabel = new JLabel();
        this.signedCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.enableCheckBox, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.enableCheckBox.text"));
        this.enableCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableCheckBox.setMargin(new Insets(0, 0, 0, 2));
        this.enableCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.enableCheckBoxActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.enableCheckBox, gridBagConstraints);
        this.enableCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_EnableWebStart_CheckBox"));
        this.enableCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_EnableWebStart_Label"));
        this.iconLabel.setLabelFor(this.iconTextField);
        Mnemonics.setLocalizedText((JLabel)this.iconLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.iconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.iconLabel, gridBagConstraints);
        this.iconLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Icon_Label"));
        this.iconLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Icon_Label"));
        this.codebaseLabel.setLabelFor(this.codebaseComboBox);
        Mnemonics.setLocalizedText((JLabel)this.codebaseLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.codebaseLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.codebaseLabel, gridBagConstraints);
        this.codebaseLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_Label"));
        this.codebaseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 6, 0, 0);
        this.add((Component)this.iconTextField, gridBagConstraints);
        this.iconTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Icon_TextField"));
        this.iconTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Icon_TextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Browse_Button"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Browse_Button"));
        this.codebaseComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.codebaseComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.codebaseComboBox, gridBagConstraints);
        this.codebaseComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_Combobox"));
        this.codebaseComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_Combobox"));
        this.codeBaseValueLabel.setLabelFor(this.codebaseTextField);
        Mnemonics.setLocalizedText((JLabel)this.codeBaseValueLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.codeBaseValueLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.codeBaseValueLabel, gridBagConstraints);
        this.codeBaseValueLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_Result_Label"));
        this.codeBaseValueLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_Result_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.codebaseTextField, gridBagConstraints);
        this.codebaseTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_TextField"));
        this.codebaseTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_TextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.offlineCheckBox, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.offlineCheckBox.text"));
        this.offlineCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.offlineCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 4, 0, 0);
        this.add((Component)this.offlineCheckBox, gridBagConstraints);
        this.offlineCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_AllowOffline_Checkbox"));
        this.offlineCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_AllowOffline_Checkbox"));
        Mnemonics.setLocalizedText((JLabel)this.panelDescLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.panelDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.panelDescLabel, gridBagConstraints);
        this.panelDescLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_WebStartTitle_Label"));
        this.panelDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_WebStartTitle_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.signedCheckBox, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.signedCheckBox.text"));
        this.signedCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.signedCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 4, 0, 0);
        this.add((Component)this.signedCheckBox, gridBagConstraints);
        this.signedCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_SelfSigned_Checkbox"));
        this.signedCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_SelfSigned_Checkbox"));
    }

    private void codebaseComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setCodebaseComponents();
    }

    private void enableCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.enableCheckBox.getModel().isSelected();
        this.setEnabledAllComponents(bl);
        JWSCustomizerPanel.setEnabledRunComponent(bl);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new IconFileFilter());
        if (this.lastImageFolder != null) {
            jFileChooser.setSelectedFile(this.lastImageFolder);
        }
        jFileChooser.setDialogTitle(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"LBL_Select_Icon_Image"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.iconTextField.setText(file.getAbsolutePath());
            this.lastImageFolder = file.getParentFile();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JWSCustomizerPanel.class);
    }

    private JWSProjectProperties.CodebaseComboBoxModel getCBModel() {
        return (JWSProjectProperties.CodebaseComboBoxModel)this.codebaseComboBox.getModel();
    }

    private void setCodebaseComponents() {
        String string = this.getCBModel().getSelectedCodebaseItem();
        if ("local".equals(string)) {
            this.codebaseTextField.setText(this.jwsProps.getProjectDistDir());
            this.codebaseTextField.setEditable(false);
        } else if ("web".equals(string)) {
            this.codebaseTextField.setText("$$codebase");
            this.codebaseTextField.setEditable(false);
        } else if ("user".equals(string)) {
            this.codebaseTextField.setText(this.jwsProps.getCodebaseLocation());
            this.codebaseTextField.setEditable(true);
        }
    }

    private void setEnabledAllComponents(boolean bl) {
        this.iconLabel.setEnabled(bl);
        this.iconTextField.setEnabled(bl);
        this.browseButton.setEnabled(bl);
        this.codebaseLabel.setEnabled(bl);
        this.codebaseComboBox.setEnabled(bl);
        this.codebaseTextField.setEnabled(bl);
        this.offlineCheckBox.setEnabled(bl);
        this.signedCheckBox.setEnabled(bl);
    }

    private static class IconFileFilter
    extends FileFilter {
        private IconFileFilter() {
        }

        public boolean accept(File file) {
            String string;
            if (file.isDirectory()) {
                return true;
            }
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            return n > 0 && n < string2.length() - 1 && ("gif".equals(string = string2.substring(n + 1).toLowerCase()) || "png".equals(string) || "jpg".equals(string));
        }

        public String getDescription() {
            return NbBundle.getMessage(JWSCustomizerPanel.class, (String)"MSG_IconFileFilter_Description");
        }
    }
}

