/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoRoundRect
extends JGoDrawable {
    public static final int ChangedArcDimension = 404;
    private Dimension myArcDimension = new Dimension();

    public JGoRoundRect() {
        this.init(5, 5);
    }

    public JGoRoundRect(Dimension arcDim) {
        this.init(arcDim.width, arcDim.height);
    }

    public JGoRoundRect(Rectangle rect, Dimension arcDim) {
        super(rect);
        this.init(arcDim.width, arcDim.height);
    }

    public JGoRoundRect(Point location, Dimension size, Dimension arcDim) {
        super(location, size);
        this.init(arcDim.width, arcDim.height);
    }

    private final void init(int w, int h) {
        this.myArcDimension.width = w;
        this.myArcDimension.height = h;
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoRoundRect newobj = (JGoRoundRect)super.copyObject(env);
        if (newobj != null) {
            newobj.myArcDimension.width = this.myArcDimension.width;
            newobj.myArcDimension.height = this.myArcDimension.height;
        }
        return newobj;
    }

    public Dimension getArcDimension() {
        return this.myArcDimension;
    }

    public void setArcDimension(Dimension dim) {
        Dimension oldDim = this.myArcDimension;
        if (oldDim.width != dim.width || oldDim.height != dim.height) {
            Dimension oldArcDimension = new Dimension(oldDim);
            this.myArcDimension.width = dim.width;
            this.myArcDimension.height = dim.height;
            this.update(404, 0, oldArcDimension);
        }
    }

    public void copyOldValueForUndo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 404: {
                e.setOldValue(new Dimension((Dimension)e.getOldValue()));
                return;
            }
        }
        super.copyOldValueForUndo(e);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 404: {
                e.setNewValue(new Dimension(this.getArcDimension()));
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 404: {
                this.setArcDimension((Dimension)e.getValue(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoRoundRect = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoRoundRect", jGoElementGroup);
            jGoRoundRect.setAttribute("arcwidth", Integer.toString(this.myArcDimension.width));
            jGoRoundRect.setAttribute("archeight", Integer.toString(this.myArcDimension.height));
        }
        if (svgDoc.SVGOutputEnabled()) {
            DomElement element = svgDoc.createElement("rect");
            this.SVGWriteAttributes(element);
            jGoElementGroup.appendChild(element);
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            int width = Integer.parseInt(jGoChildElement.getAttribute("arcwidth"));
            int height = Integer.parseInt(jGoChildElement.getAttribute("archeight"));
            this.setArcDimension(new Dimension(width, height));
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        super.SVGWriteAttributes(svgElement);
        svgElement.setAttribute("x", Integer.toString(this.getTopLeft().x));
        svgElement.setAttribute("y", Integer.toString(this.getTopLeft().y));
        svgElement.setAttribute("width", Integer.toString(this.getWidth()));
        svgElement.setAttribute("height", Integer.toString(this.getHeight()));
        svgElement.setAttribute("rx", Double.toString(this.getArcDimension().width / 2));
        svgElement.setAttribute("ry", Double.toString(this.getArcDimension().height / 2));
    }

    public void SVGReadAttributes(DomElement svgElement) {
        super.SVGReadAttributes(svgElement);
        String nX = svgElement.getAttribute("x");
        String nY = svgElement.getAttribute("y");
        this.setTopLeft(new Point(Integer.parseInt(nX), Integer.parseInt(nY)));
        String nWidth = svgElement.getAttribute("width");
        String nHeight = svgElement.getAttribute("height");
        this.setWidth(Integer.parseInt(nWidth));
        this.setHeight(Integer.parseInt(nHeight));
    }

    public void paint(Graphics2D g, JGoView view) {
        Rectangle rect = this.getBoundingRect();
        this.drawRoundRect(g, rect.x, rect.y, rect.width, rect.height, this.myArcDimension.width, this.myArcDimension.height);
    }
}

