/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.palette;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.palette.model.ModelingPaletteNodeDescriptor;
import org.netbeans.modules.uml.palette.model.PaletteElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.Utilities;

public class PaletteConfiguration {
    private static String resourceFileObj = "UML/PaletteDefinition/PaletteItemDefinition.xml";
    private static String PALETTE_ID = "paletteid";
    private static String ELEMENT_NAME = "name";
    private static String ELEMENT_TOOLTIP = "tooltip_key";
    private static String ELEMENT_ICON16 = "icon16";
    private static String ELEMENT_ICON32 = "icon32";
    private static String ELEMENT_ID = "id";
    private static Document document;
    private static Element rootElem;

    public PaletteConfiguration() {
        PaletteConfiguration.load();
    }

    public static ModelingPaletteNodeDescriptor getPaletteElement(FileObject fileObject) {
        String string = "org/netbeans/modules/uml/resources/images/";
        if (document == null) {
            PaletteConfiguration.load();
        }
        String[] stringArray = PaletteConfiguration.getElement((String)fileObject.getAttribute("element_id"));
        PaletteElement paletteElement = null;
        if (stringArray != null) {
            Image image;
            Image image2 = Utilities.loadImage((String)(string + stringArray[2]));
            if (image2 == null) {
                image2 = Utilities.loadImage((String)"org/netbeans/modules/palette/resources/unknown16.gif");
            }
            if ((image = Utilities.loadImage((String)(string + stringArray[3]))) == null) {
                image = image2;
            }
            paletteElement = new PaletteElement(stringArray[0], stringArray[1], image2, image, stringArray[4]);
        } else {
            Log.out((String)("Null elemAttrs[] found for element_id " + fileObject.getName()));
        }
        return paletteElement;
    }

    private static String[] getElement(String string) {
        String[] stringArray = new String[5];
        if (rootElem == null || string == null) {
            return null;
        }
        List list = rootElem.selectNodes("Palette/Button");
        String string2 = null;
        for (Element element : list) {
            string2 = PaletteConfiguration.getAttrValue(element, PALETTE_ID);
            if (!string2.equals(string)) continue;
            stringArray[0] = PaletteConfiguration.getAttrValue(element, ELEMENT_NAME);
            stringArray[1] = PaletteConfiguration.getAttrValue(element, ELEMENT_TOOLTIP);
            stringArray[2] = PaletteConfiguration.getAttrValue(element, ELEMENT_ICON16);
            stringArray[3] = PaletteConfiguration.getAttrValue(element, ELEMENT_ICON32);
            stringArray[4] = PaletteConfiguration.getAttrValue(element, ELEMENT_ID);
            break;
        }
        return stringArray;
    }

    private static String getAttrValue(Element element, String string) {
        String string2 = "";
        if (element == null) {
            return string2;
        }
        Attribute attribute = element.attribute(string);
        if (attribute != null) {
            string2 = attribute.getValue();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        if (document == null) {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(resourceFileObj);
            InputStream inputStream = null;
            URL uRL = (URL)fileObject.getAttribute("originalFile");
            if (uRL != null) {
                String string = uRL.getPath();
                inputStream = PaletteConfiguration.class.getResourceAsStream(string);
                if (inputStream == null) {
                    return;
                }
                try {
                    SAXReader sAXReader = new SAXReader();
                    sAXReader.setStripWhitespaceText(true);
                    sAXReader.setIgnoreComments(true);
                    document = sAXReader.read(inputStream);
                    rootElem = document.getRootElement();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

