/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.NodeFilter;
import org.dom4j.XPath;
import org.dom4j.rule.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public abstract class AbstractNode
implements Node,
Cloneable,
Serializable {
    protected static final String[] NODE_TYPE_NAMES = new String[]{"Node", "Element", "Attribute", "Text", "CDATA", "Entity", "Entity", "ProcessingInstruction", "Comment", "Document", "DocumentType", "DocumentFragment", "Notation", "Namespace", "Unknown"};
    private static final DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();

    public short getNodeType() {
        return 14;
    }

    public String getNodeTypeName() {
        short type = this.getNodeType();
        if (type < 0 || type >= NODE_TYPE_NAMES.length) {
            return "Unknown";
        }
        return NODE_TYPE_NAMES[type];
    }

    public Document getDocument() {
        Element element = this.getParent();
        return element != null ? element.getDocument() : null;
    }

    public void setDocument(Document document) {
    }

    public Element getParent() {
        return null;
    }

    public void setParent(Element parent) {
    }

    public boolean supportsParent() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean hasContent() {
        return false;
    }

    public String getPath() {
        return this.getPath(null);
    }

    public String getUniquePath() {
        return this.getUniquePath(null);
    }

    public Object clone() {
        if (this.isReadOnly()) {
            return this;
        }
        try {
            Node answer = (Node)super.clone();
            answer.setParent(null);
            answer.setDocument(null);
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should never happen. Caught: " + e);
        }
    }

    public Node detach() {
        Element parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
        } else {
            Document document = this.getDocument();
            if (document != null) {
                document.remove(this);
            }
        }
        this.setParent(null);
        this.setDocument(null);
        return this;
    }

    public String getName() {
        return null;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("This node cannot be modified");
    }

    public String getText() {
        return null;
    }

    public String getStringValue() {
        return this.getText();
    }

    public void setText(String text) {
        throw new UnsupportedOperationException("This node cannot be modified");
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.asXML());
    }

    public Object selectObject(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.selectObject(this);
    }

    public List selectNodes(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.selectNodes(this);
    }

    public List selectNodes(String xpathExpression, String comparisonXPathExpression) {
        return this.selectNodes(xpathExpression, comparisonXPathExpression, false);
    }

    public List selectNodes(String xpathExpression, String comparisonXPathExpression, boolean removeDuplicates) {
        XPath xpath = this.createXPath(xpathExpression);
        XPath sortBy = this.createXPath(comparisonXPathExpression);
        return xpath.selectNodes(this, sortBy, removeDuplicates);
    }

    public Node selectSingleNode(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.selectSingleNode(this);
    }

    public String valueOf(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.valueOf(this);
    }

    public Number numberValueOf(String xpathExpression) {
        XPath xpath = this.createXPath(xpathExpression);
        return xpath.numberValueOf(this);
    }

    public boolean matches(String patternText) {
        NodeFilter filter = this.createXPathFilter(patternText);
        return filter.matches(this);
    }

    public XPath createXPath(String xpathExpression) {
        return this.getDocumentFactory().createXPath(xpathExpression);
    }

    public NodeFilter createXPathFilter(String patternText) {
        return this.getDocumentFactory().createXPathFilter(patternText);
    }

    public Pattern createPattern(String patternText) {
        return this.getDocumentFactory().createPattern(patternText);
    }

    public Node asXPathResult(Element parent) {
        if (this.supportsParent()) {
            return this;
        }
        return this.createXPathResult(parent);
    }

    protected DocumentFactory getDocumentFactory() {
        return DOCUMENT_FACTORY;
    }

    protected Node createXPathResult(Element parent) {
        throw new RuntimeException("asXPathResult() not yet implemented fully for: " + this);
    }

    public boolean isId() {
        throw new DOMException(8, this.getClass().getName());
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new DOMException(9, this.getClass().getName());
    }

    public Object getUserData(String key) {
        throw new DOMException(9, this.getClass().getName());
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new DOMException(9, this.getClass().getName());
    }

    public Object getFeature(String feature, String version) {
        throw new DOMException(9, this.getClass().getName());
    }

    public boolean isEqualNode(org.w3c.dom.Node arg) {
        throw new DOMException(9, this.getClass().getName());
    }

    public String lookupNamespaceURI(String prefix) {
        throw new DOMException(8, this.getClass().getName());
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new DOMException(9, this.getClass().getName());
    }

    public String lookupPrefix(String namespaceURI) {
        throw new DOMException(9, this.getClass().getName());
    }

    public boolean isSameNode(org.w3c.dom.Node other) {
        throw new DOMException(9, this.getClass().getName());
    }

    public String getTextContent() throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public String getBaseURI() {
        throw new DOMException(9, this.getClass().getName());
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public Text replaceWholeText(String content) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public String getWholeText() {
        throw new DOMException(9, this.getClass().getName());
    }

    public boolean isElementContentWhitespace() {
        throw new DOMException(9, this.getClass().getName());
    }

    public org.w3c.dom.Node renameNode(org.w3c.dom.Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public void normalizeDocument() {
        throw new DOMException(9, this.getClass().getName());
    }

    public DOMConfiguration getDomConfig() {
        throw new DOMException(9, this.getClass().getName());
    }

    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node source) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public String getDocumentURI() {
        throw new DOMException(9, this.getClass().getName());
    }

    public void setDocumentURI(String documentURI) {
        throw new DOMException(9, this.getClass().getName());
    }

    public boolean getStrictErrorChecking() {
        throw new DOMException(9, this.getClass().getName());
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new DOMException(9, this.getClass().getName());
    }

    public String getXmlVersion() {
        throw new DOMException(9, this.getClass().getName());
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public boolean getXmlStandalone() {
        throw new DOMException(9, this.getClass().getName());
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new DOMException(9, this.getClass().getName());
    }

    public String getXmlEncoding() {
        throw new DOMException(9, this.getClass().getName());
    }

    public String getInputEncoding() {
        throw new DOMException(9, this.getClass().getName());
    }
}

