/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.tree.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.bpel.mapper.cast.AbstractTypeCast;
import org.netbeans.modules.bpel.mapper.cast.CastManager;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.predicates.AbstractPredicate;
import org.netbeans.modules.bpel.mapper.predicates.PredicateManager;
import org.netbeans.modules.bpel.mapper.predicates.SpecialStepManager;
import org.netbeans.modules.bpel.mapper.tree.models.VariableDeclarationWrapper;
import org.netbeans.modules.bpel.mapper.tree.models.VariableTreeInfoProvider;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeExtensionModel;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.RestartableIterator;
import org.netbeans.modules.bpel.mapper.tree.spi.TreeItemInfoProvider;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableDeclarationScope;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.VisibilityScope;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.schema.FindAllChildrenSchemaVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableTreeModel
implements MapperTreeExtensionModel<Object> {
    private FindAllChildrenSchemaVisitor sSchemaSearcher = new FindAllChildrenSchemaVisitor(true, true);
    private Set<VariableDeclaration> mOverriddenVariables;
    private BpelDesignContext mDesignContext;
    private PredicateManager mPredManager;
    private SpecialStepManager mSStepManager;
    private CastManager mCastManager;
    private TreeItemInfoProvider mTreeInfoProvider;

    public VariableTreeModel(BpelDesignContext bpelDesignContext, boolean bl, Object object) {
        this(bpelDesignContext, new PredicateManager(), new SpecialStepManager(), new CastManager(bl, object));
    }

    public VariableTreeModel(BpelDesignContext bpelDesignContext, PredicateManager predicateManager, SpecialStepManager specialStepManager, CastManager castManager) {
        this(bpelDesignContext, predicateManager, specialStepManager, castManager, VariableTreeInfoProvider.getInstance());
    }

    public VariableTreeModel(BpelDesignContext bpelDesignContext, PredicateManager predicateManager, SpecialStepManager specialStepManager, CastManager castManager, TreeItemInfoProvider treeItemInfoProvider) {
        this.mDesignContext = bpelDesignContext;
        this.mPredManager = predicateManager;
        this.mSStepManager = specialStepManager;
        this.mCastManager = castManager;
        this.mTreeInfoProvider = treeItemInfoProvider;
        this.mOverriddenVariables = this.mDesignContext.getVisibilityScope().getVisibleVariables().getAllOverridenVariables();
    }

    @Override
    public List getChildren(RestartableIterator<Object> restartableIterator) {
        Object e = restartableIterator.next();
        if (e == MapperTreeModel.TREE_ROOT) {
            Process process = this.mDesignContext.getBpelModel().getProcess();
            return Collections.singletonList(process);
        }
        if (e instanceof VariableDeclarationScope) {
            Object object;
            List list = this.mDesignContext.getVisibilityScope().getVarScopeChain();
            int n = -1;
            for (int i = 0; i < list.size(); ++i) {
                object = (VariableDeclarationScope)list.get(i);
                if (object != e) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return null;
            }
            VariableDeclarationScope variableDeclarationScope = null;
            if (n + 1 < list.size()) {
                variableDeclarationScope = (VariableDeclarationScope)list.get(n + 1);
            }
            object = VisibilityScope.Utils.getVarDeclInScope((VariableDeclarationScope)((VariableDeclarationScope)e));
            object.removeAll(this.mOverriddenVariables);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2;
                VariableDeclaration variableDeclaration = (VariableDeclaration)iterator.next();
                Object object3 = null;
                if (variableDeclaration == e) {
                    object2 = new VariableDeclarationWrapper(variableDeclaration);
                    object3 = object2;
                } else {
                    object3 = variableDeclaration;
                }
                if (object3 == null) continue;
                arrayList.add(object3);
                if (this.mCastManager == null) continue;
                object2 = this.mCastManager.getCastedVariables((AbstractVariableDeclaration)object3, null);
                arrayList.addAll((Collection<Object>)object2);
            }
            if (variableDeclarationScope != null) {
                arrayList.add(variableDeclarationScope);
            }
            return arrayList;
        }
        if (e instanceof AbstractVariableDeclaration) {
            AbstractVariableDeclaration abstractVariableDeclaration = (AbstractVariableDeclaration)e;
            WSDLReference wSDLReference = abstractVariableDeclaration.getMessageType();
            if (wSDLReference != null) {
                Collection collection;
                Message message = (Message)wSDLReference.get();
                Collection collection2 = collection = message != null ? message.getParts() : null;
                if (this.mCastManager == null) {
                    ArrayList arrayList = collection != null ? new ArrayList(collection) : new ArrayList();
                    return arrayList;
                }
                ArrayList<AbstractTypeCast> arrayList = new ArrayList<AbstractTypeCast>();
                arrayList.addAll(collection);
                for (Part part : collection) {
                    List<AbstractTypeCast> list = this.mCastManager.getCastedVariables(abstractVariableDeclaration, part);
                    arrayList.addAll(list);
                }
                return arrayList;
            }
            SchemaReference schemaReference = abstractVariableDeclaration.getType();
            if (schemaReference != null) {
                GlobalType globalType = (GlobalType)schemaReference.get();
                if (globalType != null) {
                    return this.loadSchemaComponents(restartableIterator, (SchemaComponent)globalType);
                }
            } else {
                GlobalElement globalElement;
                SchemaReference schemaReference2 = abstractVariableDeclaration.getElement();
                if (schemaReference2 != null && (globalElement = (GlobalElement)schemaReference2.get()) != null) {
                    return this.loadSchemaComponents(restartableIterator, (SchemaComponent)globalElement);
                }
            }
        } else if (e instanceof Part) {
            Part part = (Part)e;
            NamedComponentReference namedComponentReference = part.getType();
            if (namedComponentReference != null) {
                GlobalType globalType = (GlobalType)namedComponentReference.get();
                if (globalType != null) {
                    return this.loadSchemaComponents(restartableIterator, (SchemaComponent)globalType);
                }
            } else {
                GlobalElement globalElement;
                NamedComponentReference namedComponentReference2 = part.getElement();
                if (namedComponentReference2 != null && (globalElement = (GlobalElement)namedComponentReference2.get()) != null) {
                    return this.loadSchemaComponents(restartableIterator, (SchemaComponent)globalElement);
                }
            }
        } else {
            GlobalType globalType;
            if (e instanceof SchemaComponent) {
                return this.loadSchemaComponents(restartableIterator, (SchemaComponent)e);
            }
            if (e instanceof AbstractPredicate) {
                SchemaComponent schemaComponent = ((AbstractPredicate)e).getSComponent();
                if (schemaComponent != null) {
                    return this.loadSchemaComponents(restartableIterator, schemaComponent);
                }
            } else if (e instanceof LocationStep) {
                LocationStep locationStep = (LocationStep)e;
                XPathSchemaContext xPathSchemaContext = locationStep.getSchemaContext();
                if (xPathSchemaContext != null) {
                    Set set = xPathSchemaContext.getSchemaCompPairs();
                    ArrayList arrayList = new ArrayList();
                    for (XPathSchemaContext.SchemaCompPair schemaCompPair : set) {
                        SchemaComponent schemaComponent = schemaCompPair.getComp();
                        arrayList.addAll(this.loadSchemaComponents(restartableIterator, schemaComponent));
                    }
                    return arrayList;
                }
            } else if (e instanceof AbstractTypeCast && (globalType = ((AbstractTypeCast)e).getCastTo()) != null) {
                return this.loadSchemaComponents(restartableIterator, (SchemaComponent)globalType);
            }
        }
        return null;
    }

    public PredicateManager getPredicateManager() {
        return this.mPredManager;
    }

    public SpecialStepManager getSStepManager() {
        return this.mSStepManager;
    }

    public CastManager getCastManager() {
        return this.mCastManager;
    }

    private List loadSchemaComponents(RestartableIterator<Object> restartableIterator, SchemaComponent schemaComponent) {
        Object object;
        this.sSchemaSearcher.lookForSubcomponents(schemaComponent);
        List list = this.sSchemaSearcher.getFound();
        if (this.mPredManager == null && this.mSStepManager == null && this.mCastManager == null) {
            return list;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() + 5);
        if (this.mSStepManager != null && (object = this.mSStepManager.getSteps(restartableIterator)) != null && !object.isEmpty()) {
            arrayList.addAll((Collection<Object>)object);
        }
        for (SchemaComponent schemaComponent2 : list) {
            List<Object> list2;
            arrayList.add(schemaComponent2);
            if (this.mPredManager != null) {
                list2 = this.mPredManager.getPredicates(restartableIterator, schemaComponent2);
                arrayList.addAll(list2);
            }
            if (this.mCastManager == null) continue;
            list2 = this.mCastManager.getTypeCast(restartableIterator, schemaComponent2);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    @Override
    public Boolean isLeaf(Object object) {
        return null;
    }

    @Override
    public Boolean isConnectable(Object object) {
        if (object instanceof Element || object instanceof Attribute || object instanceof Part || object instanceof AbstractPredicate || object instanceof LocationStep || object instanceof AbstractTypeCast) {
            return Boolean.TRUE;
        }
        if (object instanceof AbstractVariableDeclaration && !(object instanceof VariableDeclarationScope)) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public TreeItemInfoProvider getTreeItemInfoProvider() {
        return this.mTreeInfoProvider;
    }
}

