/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.VertexFactory;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextControllerImpl2;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.search.FinderListBuilder;
import org.netbeans.modules.bpel.mapper.tree.search.PartFinder;
import org.netbeans.modules.bpel.mapper.tree.search.TreeFinderProcessor;
import org.netbeans.modules.bpel.mapper.tree.search.VariableFinder;
import org.netbeans.modules.bpel.mapper.tree.spi.TreeItemFinder;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.support.XPathBpelVariable;
import org.netbeans.modules.soa.mappercore.model.Constant;
import org.netbeans.modules.soa.mappercore.model.Function;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.Operation;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xpath.ext.AbstractLocationPath;
import org.netbeans.modules.xml.xpath.ext.CoreFunctionType;
import org.netbeans.modules.xml.xpath.ext.CoreOperationType;
import org.netbeans.modules.xml.xpath.ext.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.ext.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentDescriptor;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentGroup;
import org.netbeans.modules.xml.xpath.ext.metadata.ExtFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.StubExtFunction;
import org.netbeans.modules.xml.xpath.ext.spi.XPathVariable;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphBuilderVisitor
extends XPathVisitorAdapter {
    protected Graph mGraph;
    protected MapperSwingTreeModel mLeftTreeModel;
    protected boolean mConnectToTargetTree;
    protected Stack<VertexBuilderData> mVertexStack = new Stack();
    protected BpelDesignContext currentBpelDesignContext;

    public GraphBuilderVisitor(Graph graph, MapperSwingTreeModel mapperSwingTreeModel, boolean bl, BpelDesignContext bpelDesignContext) {
        this.mGraph = graph;
        this.mLeftTreeModel = mapperSwingTreeModel;
        this.mConnectToTargetTree = bl;
        this.currentBpelDesignContext = bpelDesignContext;
    }

    public void visit(XPathCoreFunction xPathCoreFunction) {
        CoreFunctionType coreFunctionType = xPathCoreFunction.getFunctionType();
        Function function = VertexFactory.getInstance().createCoreFunction(coreFunctionType);
        this.mGraph.addVertex((Vertex)function);
        this.linkToParent((SourcePin)function);
        this.processChildren((Vertex)function, (XPathOperationOrFuntion)xPathCoreFunction);
    }

    public void visit(XPathCoreOperation xPathCoreOperation) {
        CoreOperationType coreOperationType = xPathCoreOperation.getOperationType();
        Operation operation = VertexFactory.getInstance().createCoreOperation(coreOperationType);
        this.mGraph.addVertex((Vertex)operation);
        this.linkToParent((SourcePin)operation);
        this.processChildren((Vertex)operation, (XPathOperationOrFuntion)xPathCoreOperation);
    }

    public void visit(XPathExtensionFunction xPathExtensionFunction) {
        if (StubExtFunction.STUB_FUNC_NAME.equals(xPathExtensionFunction.getName())) {
            this.stubLinkToParent();
        } else {
            ExtFunctionMetadata extFunctionMetadata = xPathExtensionFunction.getMetadata();
            Function function = VertexFactory.getInstance().createExtFunction(extFunctionMetadata);
            if (function != null) {
                this.mGraph.addVertex((Vertex)function);
                this.linkToParent((SourcePin)function);
                this.processChildren((Vertex)function, (XPathOperationOrFuntion)xPathExtensionFunction);
            }
        }
    }

    public void visit(XPathLocationPath xPathLocationPath) {
    }

    public void visit(XPathNumericLiteral xPathNumericLiteral) {
        Number number = xPathNumericLiteral.getValue();
        Constant constant = VertexFactory.getInstance().createNumericLiteral(number);
        this.mGraph.addVertex((Vertex)constant);
        this.linkToParent((SourcePin)constant);
    }

    public void visit(XPathStringLiteral xPathStringLiteral) {
        String string = xPathStringLiteral.getValue();
        Constant constant = VertexFactory.getInstance().createStringLiteral(string);
        this.mGraph.addVertex((Vertex)constant);
        this.linkToParent((SourcePin)constant);
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        this.connectToLeftTree(xPathExpressionPath);
    }

    public void visit(XPathVariableReference xPathVariableReference) {
        XPathVariable xPathVariable = xPathVariableReference.getVariable();
        if (xPathVariable != null && xPathVariable instanceof XPathBpelVariable) {
            this.connectToLeftTree((XPathBpelVariable)xPathVariable);
        }
    }

    protected void linkToParent(SourcePin sourcePin) {
        VertexBuilderData vertexBuilderData;
        Graph graph = null;
        if (this.mVertexStack.isEmpty()) {
            if (!this.mConnectToTargetTree) {
                return;
            }
            graph = this.mGraph;
        } else {
            vertexBuilderData = this.mVertexStack.peek();
            VertexItem vertexItem = vertexBuilderData.freeVertexItemRequired();
            graph = vertexItem;
        }
        if (graph != null) {
            vertexBuilderData = new Link(sourcePin, (TargetPin)graph);
            this.mGraph.addLink((Link)vertexBuilderData);
        }
    }

    protected void stubLinkToParent() {
        if (!this.mVertexStack.isEmpty()) {
            VertexBuilderData vertexBuilderData = this.mVertexStack.peek();
            vertexBuilderData.freeVertexItemRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChildren(Vertex vertex, XPathOperationOrFuntion xPathOperationOrFuntion) {
        VertexBuilderData vertexBuilderData = new VertexBuilderData(vertex);
        this.mVertexStack.push(vertexBuilderData);
        try {
            this.visitChildren(xPathOperationOrFuntion);
        }
        finally {
            this.mVertexStack.pop();
        }
    }

    protected void connectToLeftTree(XPathBpelVariable xPathBpelVariable) {
        AbstractVariableDeclaration abstractVariableDeclaration;
        ArrayList<TreeItemFinder> arrayList = new ArrayList<TreeItemFinder>();
        if (xPathBpelVariable != null && (abstractVariableDeclaration = xPathBpelVariable.getVarDecl()) != null) {
            arrayList.add(new VariableFinder(abstractVariableDeclaration));
            Part part = xPathBpelVariable.getPart();
            if (part != null) {
                arrayList.add(new PartFinder(part));
            }
        }
        this.connectToLeftTree(arrayList);
    }

    protected void connectToLeftTree(XPathExpressionPath xPathExpressionPath) {
        if (!this.connectToLeftTree(FinderListBuilder.build((AbstractLocationPath)xPathExpressionPath)) && this.currentBpelDesignContext != null) {
            DesignContextControllerImpl2.addErrMessage(this.currentBpelDesignContext.getValidationErrMsgBuffer(), xPathExpressionPath.getExpressionString(), "from");
        }
    }

    protected boolean connectToLeftTree(List<TreeItemFinder> list) {
        TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor(this.mLeftTreeModel);
        TreePath treePath = treeFinderProcessor.findFirstNode(list);
        if (treePath != null) {
            TreeSourcePin treeSourcePin = new TreeSourcePin(treePath);
            this.linkToParent((SourcePin)treeSourcePin);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VertexBuilderData {
        private Vertex mVertex;
        private int mLastOccupiedVertexItem = -1;

        public VertexBuilderData(Vertex vertex) {
            this.mVertex = vertex;
        }

        public Vertex getVertex() {
            return this.mVertex;
        }

        public VertexItem freeVertexItemRequired() {
            List<VertexItem> list;
            VertexItem vertexItem = null;
            for (int i = this.mLastOccupiedVertexItem + 1; i < this.mVertex.getItemCount(); ++i) {
                Link link;
                VertexItem vertexItem2 = this.mVertex.getItem(i);
                if (vertexItem2 == null || vertexItem2.isHairline() || (link = vertexItem2.getIngoingLink()) != null) continue;
                vertexItem = vertexItem2;
                this.mLastOccupiedVertexItem = i;
                break;
            }
            if (vertexItem == null && (list = this.createNewVertexItems()) != null && !list.isEmpty()) {
                this.mLastOccupiedVertexItem = this.mVertex.getItemCount();
                vertexItem = list.get(0);
                for (VertexItem vertexItem2 : list) {
                    this.mVertex.addItem(vertexItem2);
                }
            }
            return vertexItem;
        }

        private List<VertexItem> createNewVertexItems() {
            VertexItem vertexItem = this.mVertex.getItem(this.mVertex.getItemCount() - 1);
            if (vertexItem.isHairline()) {
                return this.calculateReplaceForHairline(vertexItem);
            }
            VertexItem vertexItem2 = new VertexItem(this.mVertex, "Unexpected");
            return Collections.singletonList(vertexItem2);
        }

        public List<VertexItem> calculateReplaceForHairline(VertexItem vertexItem) {
            ArrayList<VertexItem> arrayList = new ArrayList<VertexItem>();
            Object object = vertexItem.getDataObject();
            if (object instanceof ArgumentDescriptor) {
                VertexItem vertexItem2 = VertexFactory.constructVItem(this.mVertex, (ArgumentDescriptor)object);
                arrayList.add(vertexItem2);
                VertexItem vertexItem3 = VertexFactory.constructHairline(this.mVertex, object);
                arrayList.add(vertexItem3);
            } else if (object instanceof ArgumentGroup) {
                List<VertexItem> list = VertexFactory.getInstance().createGroupItems(this.mVertex, (ArgumentGroup)object);
                arrayList.addAll(list);
                VertexItem vertexItem4 = VertexFactory.constructHairline(this.mVertex, object);
                arrayList.add(vertexItem4);
            }
            return arrayList;
        }
    }
}

