/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.logging.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.cast.AbstractTypeCast;
import org.netbeans.modules.bpel.mapper.logging.tree.AlertItem;
import org.netbeans.modules.bpel.mapper.logging.tree.LogItem;
import org.netbeans.modules.bpel.mapper.model.BpelModelUpdater;
import org.netbeans.modules.bpel.mapper.model.GraphInfoCollector;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.ExtensionEntity;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.support.EnumValue;
import org.netbeans.modules.bpel.model.ext.logging.api.Alert;
import org.netbeans.modules.bpel.model.ext.logging.api.AlertLevel;
import org.netbeans.modules.bpel.model.ext.logging.api.Location;
import org.netbeans.modules.bpel.model.ext.logging.api.Log;
import org.netbeans.modules.bpel.model.ext.logging.api.LogLevel;
import org.netbeans.modules.bpel.model.ext.logging.api.Trace;
import org.netbeans.modules.soa.mappercore.model.Graph;

public class LoggingBpelModelUpdater
extends BpelModelUpdater {
    public LoggingBpelModelUpdater(MapperTcContext mapperTcContext) {
        super(mapperTcContext);
    }

    public Object updateOnChanges(TreePath treePath) throws Exception {
        BpelEntity bpelEntity = this.getDesignContext().getContextEntity();
        if (bpelEntity instanceof ExtensibleElements) {
            this.updateExtensileElements(treePath, (ExtensibleElements)bpelEntity);
        }
        return null;
    }

    private Log findLog(Trace trace, Location location, LogLevel logLevel) {
        assert (trace != null && location != null && logLevel != null);
        Log[] logArray = trace.getLogs();
        Log log = null;
        if (logArray != null) {
            for (Log log2 : logArray) {
                if (logLevel == null || !logLevel.equals((Object)log2.getLevel()) || location == null || !location.equals((Object)log2.getLocation())) continue;
                log = log2;
                break;
            }
        }
        return log;
    }

    private Alert findAlert(Trace trace, Location location, AlertLevel alertLevel) {
        assert (trace != null && location != null && alertLevel != null);
        Alert[] alertArray = trace.getAlerts();
        Alert alert = null;
        if (alertArray != null) {
            for (Alert alert2 : alertArray) {
                if (alertLevel == null || !alertLevel.equals((Object)alert2.getLevel()) || location == null || !location.equals((Object)alert2.getLocation())) continue;
                alert = alert2;
                break;
            }
        }
        return alert;
    }

    private void updateExtensileElements(TreePath treePath, ExtensibleElements extensibleElements) throws Exception {
        Object object;
        assert (extensibleElements != null);
        Graph graph = this.getMapperModel().graphRequired(treePath);
        GraphInfoCollector graphInfoCollector = new GraphInfoCollector(graph);
        BpelModel bpelModel = extensibleElements.getBpelModel();
        Trace trace = null;
        if (graph.isEmpty()) {
            trace = this.getTrace(extensibleElements, false);
            if (trace == null) {
                return;
            }
            this.removeEmptyGraph(trace, treePath);
            return;
        }
        Trace trace2 = trace = trace == null ? this.getTrace(extensibleElements) : trace;
        if (trace == null) {
            return;
        }
        Object object2 = MapperSwingTreeModel.getDataObject(treePath);
        From from = null;
        if (object2 instanceof LogItem) {
            object = ((LogItem)object2).getLevel();
            Location location = ((LogItem)object2).getLocation();
            Log log = this.findLog(trace, location, (LogLevel)object);
            if (log == null) {
                log = (Log)bpelModel.getBuilder().createExtensionEntity(Log.class);
                log.setLevel((EnumValue)object);
                log.setLocation(location);
                trace.addLog(log);
                log = this.findLog(trace, location, (LogLevel)object);
            }
            if (log == null) {
                return;
            }
            From from2 = log.getFrom();
            if (from2 == null) {
                from2 = bpelModel.getBuilder().createFrom();
                log.setFrom(from2);
                from2 = log.getFrom();
            }
            from = from2;
        } else if (object2 instanceof AlertItem) {
            object = ((AlertItem)object2).getLevel();
            Location location = ((AlertItem)object2).getLocation();
            Alert alert = this.findAlert(trace, location, (AlertLevel)object);
            if (alert == null) {
                alert = (Alert)bpelModel.getBuilder().createExtensionEntity(Alert.class);
                alert.setLevel((EnumValue)object);
                alert.setLocation(location);
                trace.addAlert(alert);
                alert = this.findAlert(trace, location, (AlertLevel)object);
            }
            if (alert == null) {
                return;
            }
            From from3 = alert.getFrom();
            if (from3 == null) {
                from3 = bpelModel.getBuilder().createFrom();
                alert.setFrom(from3);
                from3 = alert.getFrom();
            }
            from = from3;
        } else {
            return;
        }
        object = new HashSet();
        this.updateFrom(graph, (Set<AbstractTypeCast>)object, from);
        this.registerTypeCasts(extensibleElements, (Collection<AbstractTypeCast>)object, true);
    }

    private void removeEmptyGraph(Trace trace, TreePath treePath) {
        Location location;
        Object object;
        assert (trace != null);
        assert (treePath != null);
        Object object2 = MapperSwingTreeModel.getDataObject(treePath);
        if (object2 instanceof LogItem) {
            object = ((LogItem)object2).getLevel();
            location = ((LogItem)object2).getLocation();
            Log log = this.findLog(trace, location, (LogLevel)object);
            if (log != null) {
                trace.remove((BpelEntity)log);
            }
        } else if (object2 instanceof AlertItem) {
            object = ((AlertItem)object2).getLevel();
            location = ((AlertItem)object2).getLocation();
            Alert alert = this.findAlert(trace, location, (AlertLevel)object);
            if (alert != null) {
                trace.remove((BpelEntity)alert);
            }
        }
        object = trace.getChildren();
        if ((object == null || object.isEmpty()) && (location = trace.getParent()) != null) {
            location.remove((BpelEntity)trace);
        }
        this.getMapperModel().deleteGraph(treePath);
    }

    private Trace getTrace(ExtensibleElements extensibleElements) {
        return this.getTrace(extensibleElements, true);
    }

    private Trace getTrace(ExtensibleElements extensibleElements, boolean bl) {
        List list = extensibleElements.getChildren(Trace.class);
        if (list != null && list.size() > 0) {
            return (Trace)list.get(0);
        }
        if (!bl) {
            return null;
        }
        BpelModel bpelModel = extensibleElements.getBpelModel();
        if (bpelModel == null) {
            return null;
        }
        Trace trace = (Trace)bpelModel.getBuilder().createExtensionEntity(Trace.class);
        extensibleElements.addExtensionEntity(Trace.class, (ExtensionEntity)trace);
        list = extensibleElements.getChildren(Trace.class);
        return list != null && list.size() > 0 ? (Trace)list.get(0) : null;
    }
}

