/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.openide.util.Parameters;

public class SourceUtils {
    private final CompilationController controller;
    private TypeElement typeElement;
    private ClassTree classTree;

    SourceUtils(CompilationController compilationController, TypeElement typeElement) {
        this.controller = compilationController;
        this.typeElement = typeElement;
    }

    SourceUtils(CompilationController compilationController, ClassTree classTree) {
        this.controller = compilationController;
        this.classTree = classTree;
    }

    public static SourceUtils newInstance(CompilationController compilationController, TypeElement typeElement) {
        Parameters.notNull((CharSequence)"controller", (Object)compilationController);
        Parameters.notNull((CharSequence)"typeElement", (Object)typeElement);
        return new SourceUtils(compilationController, typeElement);
    }

    public static SourceUtils newInstance(CompilationController compilationController, ClassTree classTree) {
        Parameters.notNull((CharSequence)"controller", (Object)compilationController);
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        return new SourceUtils(compilationController, classTree);
    }

    public static SourceUtils newInstance(CompilationController compilationController) throws IOException {
        Parameters.notNull((CharSequence)"controller", (Object)compilationController);
        ClassTree classTree = SourceUtils.findPublicTopLevelClass(compilationController);
        if (classTree != null) {
            return SourceUtils.newInstance(compilationController, classTree);
        }
        return null;
    }

    static ClassTree findPublicTopLevelClass(CompilationController compilationController) throws IOException {
        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        String string = compilationController.getFileObject().getName();
        for (Tree tree : compilationController.getCompilationUnit().getTypeDecls()) {
            ClassTree classTree;
            if (tree.getKind() != Tree.Kind.CLASS || !(classTree = (ClassTree)tree).getSimpleName().contentEquals(string) || !classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
            return classTree;
        }
        return null;
    }

    public TypeElement getTypeElement() {
        if (this.typeElement == null) {
            assert (this.classTree != null);
            TreePath treePath = this.controller.getTrees().getPath(this.getCompilationController().getCompilationUnit(), this.classTree);
            this.typeElement = (TypeElement)this.controller.getTrees().getElement(treePath);
        }
        return this.typeElement;
    }

    public ClassTree getClassTree() {
        if (this.classTree == null) {
            assert (this.typeElement != null);
            this.classTree = this.controller.getTrees().getTree(this.typeElement);
        }
        return this.classTree;
    }

    public boolean isSubtype(String string) {
        Parameters.notNull((CharSequence)"type", (Object)string);
        TypeMirror typeMirror = this.getCompilationController().getTreeUtilities().parseType(string, this.getTypeElement());
        if (typeMirror != null) {
            return this.getCompilationController().getTypes().isSubtype(this.getTypeElement().asType(), typeMirror);
        }
        return false;
    }

    CompilationController getCompilationController() {
        return this.controller;
    }

    ExecutableElement getNoArgConstructor() throws IOException {
        this.controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        ElementUtilities elementUtilities = this.controller.getElementUtilities();
        for (Element element : this.getTypeElement().getEnclosedElements()) {
            ExecutableElement executableElement;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (executableElement = (ExecutableElement)element).getParameters().size() != 0 || elementUtilities.isSynthetic((Element)executableElement)) continue;
            return executableElement;
        }
        return null;
    }

    private boolean isMainMethod(ExecutableElement executableElement) {
        if (!executableElement.getSimpleName().contentEquals("main")) {
            return false;
        }
        Set<Modifier> set = executableElement.getModifiers();
        if (!set.contains((Object)Modifier.PUBLIC) || !set.contains((Object)Modifier.STATIC)) {
            return false;
        }
        if (TypeKind.VOID != executableElement.getReturnType().getKind()) {
            return false;
        }
        List<? extends VariableElement> list = executableElement.getParameters();
        if (list.size() != 1) {
            return false;
        }
        VariableElement variableElement = list.get(0);
        TypeMirror typeMirror = variableElement.asType();
        if (TypeKind.ARRAY != typeMirror.getKind()) {
            return false;
        }
        ArrayType arrayType = (ArrayType)typeMirror;
        TypeElement typeElement = this.controller.getElements().getTypeElement(String.class.getName());
        return this.controller.getTypes().isSameType(typeElement.asType(), arrayType.getComponentType());
    }
}

