/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.j2ee.common.project.ui.ProjectImportLocationPanel;
import org.netbeans.modules.j2ee.common.project.ui.ProjectLocationWizardPanel;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ProjectLocationPanel
extends JPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String PROP_PROJECT_LOCATION = "projectLocation";
    static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private String generatedProjectName = "";
    private int generatedProjectNameIndex = 0;
    private String currentLibrariesLocation;
    private ProjectLocationWizardPanel wizard;
    private Object j2eeModuleType;
    private String nameFormatter;
    private JButton browseButton;
    private JButton browseLibraries;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JLabel lblHint;
    private JLabel librariesLabel;
    private JTextField librariesLocation;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    protected JTextField projectNameTextField;
    private JCheckBox setAsMainCheckBox;
    private JCheckBox sharableProject;

    public ProjectLocationPanel(Object object, String string, String string2, ProjectLocationWizardPanel projectLocationWizardPanel, String string3) {
        this.initComponents();
        this.wizard = projectLocationWizardPanel;
        this.j2eeModuleType = object;
        this.nameFormatter = string3;
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.librariesLocation.setText(this.currentLibrariesLocation);
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.setName(string);
        this.putClientProperty("NewProjectWizard_Title", string2);
        this.sharableProjectActionPerformed(null);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.librariesLabel = new JLabel();
        this.librariesLocation = new JTextField();
        this.browseLibraries = new JButton();
        this.sharableProject = new JCheckBox();
        this.setAsMainCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.lblHint = new JLabel();
        this.projectNameLabel.setDisplayedMnemonic(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_ProjectName_LabelMnemonic").charAt(0));
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        this.projectNameLabel.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_ProjectName_Label"));
        this.projectLocationLabel.setDisplayedMnemonic(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_ProjectLocation_LabelMnemonic").charAt(0));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        this.projectLocationLabel.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        this.browseButton.setMnemonic(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_Browse_LabelMnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectLocationPanel.this.browseLocationAction(actionEvent);
            }
        });
        this.createdFolderLabel.setDisplayedMnemonic(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_LabelMnemonic").charAt(0));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        this.createdFolderLabel.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_Label"));
        this.createdFolderTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(ProjectLocationPanel.class, (String)"ProjectLocationPanel.librariesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLibraries, (String)NbBundle.getMessage(ProjectLocationPanel.class, (String)"PanelSharabilityVisual.browseLibraries.text"));
        this.browseLibraries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectLocationPanel.this.browseLibrariesActionPerformed(actionEvent);
            }
        });
        this.sharableProject.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        Mnemonics.setLocalizedText((AbstractButton)this.sharableProject, (String)NbBundle.getMessage(ProjectLocationPanel.class, (String)"ProjectLocationPanel.sharableProject.text"));
        this.sharableProject.setMargin(new Insets(2, 0, 2, 2));
        this.sharableProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectLocationPanel.this.sharableProjectActionPerformed(actionEvent);
            }
        });
        this.setAsMainCheckBox.setSelected(true);
        this.setAsMainCheckBox.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_SetAsMain_CheckBox"));
        this.setAsMainCheckBox.setMargin(new Insets(2, 0, 2, 2));
        this.lblHint.setText(NbBundle.getMessage(ProjectLocationPanel.class, (String)"HINT_LibrariesFolder"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.createdFolderLabel).add(339, 339, 339)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectLocationLabel).add((Component)this.projectNameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.projectNameTextField, -1, 371, Short.MAX_VALUE).add(1, (Component)this.createdFolderTextField, -1, 371, Short.MAX_VALUE).add(1, (Component)this.projectLocationTextField, -1, 371, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton)).add((Component)this.jSeparator1, -1, 580, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.sharableProject).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.librariesLabel).addPreferredGap(0).add((Component)this.librariesLocation, -1, 373, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.browseLibraries)).add((Component)this.jPanel1, -1, 580, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.setAsMainCheckBox).addContainerGap()).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.lblHint)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.browseButton).add((Component)this.projectLocationTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.sharableProject).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.librariesLabel).add((Component)this.browseLibraries).add((Component)this.librariesLocation, -2, -1, -2)).addPreferredGap(0).add((Component)this.lblHint).addPreferredGap(0).add((Component)this.setAsMainCheckBox).addPreferredGap(0, 100, Short.MAX_VALUE).add((Component)this.jPanel1, -2, 14, -2)));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSD_projectNameLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSD_projectLocationLabel"));
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSD_browseButton"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSN_createdFolderLabel"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProjectLocationPanel.class).getString("ACSD_createdFolderLabel"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSN_PanelProjectLocationVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_PanelProjectLocationVisual"));
    }

    private void browseLocationAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_NWP1_SelectProjectLocation"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(file.getAbsolutePath());
            }
            this.wizard.fireChangeEvent();
        }
    }

    private void browseLibrariesActionPerformed(ActionEvent actionEvent) {
        File file = new File(this.createdFolderTextField.getText());
        String string = SharableLibrariesUtils.browseForLibraryLocation((String)this.librariesLocation.getText().trim(), (Component)this, (File)file);
        if (string != null) {
            this.currentLibrariesLocation = string;
            if (this.sharableProject.isSelected()) {
                this.librariesLocation.setText(this.currentLibrariesLocation);
            }
        }
    }

    private void sharableProjectActionPerformed(ActionEvent actionEvent) {
        this.librariesLocation.setEnabled(this.sharableProject.isSelected());
        this.browseLibraries.setEnabled(this.sharableProject.isSelected());
        this.librariesLabel.setEnabled(this.sharableProject.isSelected());
        this.lblHint.setEnabled(this.sharableProject.isSelected());
        if (this.sharableProject.isSelected()) {
            this.librariesLocation.setText(this.currentLibrariesLocation);
        } else {
            this.librariesLocation.setText("");
        }
        this.wizard.fireChangeEvent();
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File file2 = new File(this.projectLocationTextField.getText()).getAbsoluteFile();
        if (ProjectLocationPanel.getCanonicalFile(file2) == null) {
            String string = NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)string);
            return false;
        }
        File file3 = ProjectLocationPanel.getCanonicalFile(new File(this.createdFolderTextField.getText()).getAbsoluteFile());
        if (file3 == null) {
            String string = NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_IllegalProjectName");
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)string);
            return false;
        }
        for (file = file3; file != null && !file.exists(); file = file.getParentFile()) {
        }
        if (file == null || !file.canWrite()) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (FileUtil.toFileObject((File)file) == null) {
            String string = NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)string);
            return false;
        }
        File[] fileArray = file3.listFiles();
        if (file3.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ProjectLocationPanel.class, (String)"MSG_ProjectFolderExists"));
            return false;
        }
        wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)"");
        if (this.sharableProject.isSelected()) {
            String string = this.librariesLocation.getText();
            if (new File(string).isAbsolute()) {
                wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectLocationPanel.class, (String)"PanelSharability.absolutePathWarning.text")));
            } else {
                File file4;
                File file5 = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()));
                if (!CollocationQuery.areCollocated((File)file5, (File)(file4 = PropertyUtils.resolveFile((File)file5, (String)string)))) {
                    wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectLocationPanel.class, (String)"PanelSharability.relativePathWarning.text")));
                }
            }
        }
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.createdFolderTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string2));
        wizardDescriptor.putProperty("name", (Object)string);
        wizardDescriptor.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        wizardDescriptor.putProperty("sharedLibraries", this.sharableProject.isSelected() ? this.librariesLocation.getText() : null);
    }

    void read(WizardDescriptor wizardDescriptor) {
        Object object;
        Object object2 = (File)wizardDescriptor.getProperty("projdir");
        if (object2 == null || ((File)object2).getParentFile() == null || !((File)object2).getParentFile().isDirectory()) {
            File file;
            object = null;
            FileObject fileObject = Templates.getExistingSourcesFolder((WizardDescriptor)wizardDescriptor);
            if (fileObject != null && (file = FileUtil.toFile((FileObject)fileObject)) != null && file.isDirectory()) {
                object = file;
            }
            object2 = object != null ? object : ProjectChooser.getProjectsFolder();
        } else {
            object2 = ((File)object2).getParentFile();
        }
        this.projectLocationTextField.setText(((File)object2).getAbsolutePath());
        object = (String)wizardDescriptor.getProperty("name");
        if (object == null) {
            int n = 1;
            while ((object = this.validFreeProjectName((File)object2, this.nameFormatter, n)) == null) {
                ++n;
            }
        }
        this.projectNameTextField.setText((String)object);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, n);
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            Object object;
            String string = this.projectNameTextField.getText();
            if (document == this.projectLocationTextField.getDocument()) {
                if (string.equals(this.generatedProjectName)) {
                    object = new File(this.projectLocationTextField.getText().trim());
                    this.generatedProjectNameIndex = ProjectLocationPanel.getValidProjectNameIndex(this.nameFormatter, this.generatedProjectNameIndex, (File)object);
                } else {
                    this.generatedProjectNameIndex = 0;
                }
                String string2 = this.generatedProjectName = this.generatedProjectNameIndex > 0 ? ProjectLocationPanel.getProjectName(this.nameFormatter, this.generatedProjectNameIndex) : null;
                if (this.generatedProjectNameIndex > 0) {
                    string = this.generatedProjectName;
                    this.projectNameTextField.setText(this.generatedProjectName);
                    this.projectNameTextField.selectAll();
                }
            }
            object = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText((String)object + File.separatorChar + string);
        }
        this.wizard.fireChangeEvent();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getProjectName(String string, int n) {
        return MessageFormat.format(string, String.valueOf(n));
    }

    private static int getValidProjectNameIndex(String string, int n, File file) {
        int n2;
        int n3 = n2 = n > 0 ? n : UserProjectSettings.getDefault().getNewProjectCount() + 1;
        if (file != null) {
            while (new File(file, ProjectLocationPanel.getProjectName(string, n2)).exists()) {
                ++n2;
            }
        }
        return n2;
    }

    public static String decorateMessage(String string) {
        if (string != null) {
            return "<html>" + string.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</html>";
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectImportLocationPanel.generateHelpID(ProjectLocationPanel.class, this.j2eeModuleType));
    }
}

