/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static void setMessage(JLabel jLabel, MessageType messageType, String string) {
        Parameters.notNull((CharSequence)"type", (Object)((Object)messageType));
        Parameters.notNull((CharSequence)"message", (Object)string);
        jLabel.setForeground(messageType.getColor());
        MessageUtils.setMessage(jLabel, messageType.getIcon(), string);
    }

    public static void clear(JLabel jLabel) {
        MessageUtils.setMessage(jLabel, (Icon)null, (String)null);
    }

    private static void setMessage(JLabel jLabel, Icon icon, String string) {
        jLabel.setIcon(string == null ? null : icon);
        jLabel.setText(string);
        jLabel.setToolTipText(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        ERROR{

            protected Icon getIcon() {
                return new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/error.gif"));
            }

            protected Color getColor() {
                Color color = UIManager.getColor("nb.errorForeground");
                if (color == null) {
                    color = new Color(255, 0, 0);
                }
                return color;
            }
        }
        ,
        WARNING{

            protected Icon getIcon() {
                return new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/warning.gif"));
            }

            protected Color getColor() {
                Color color = UIManager.getColor("nb.warningForeground");
                if (color == null) {
                    color = new Color(51, 51, 51);
                }
                return color;
            }
        };


        protected abstract Icon getIcon();

        protected abstract Color getColor();
    }
}

