/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.openide.filesystems.FileUtil;

public class FileChooser
extends JFileChooser {
    private String key;
    protected String initialPath;

    public FileChooser(String string, String string2) {
        super(FileChooser.getInitialDirectory(string, string2));
        this.key = string;
    }

    public FileChooser(String string) {
        this(string, (String)null);
        this.key = string;
    }

    private static File getInitialDirectory(String string, String string2) {
        return FileChooser.getInitialDirectory(string, string2 == null ? null : new File(string2));
    }

    private static File getInitialDirectory(String string, File file) {
        File file2;
        while (file != null) {
            if (file.exists() && file.isDirectory()) {
                return file;
            }
            file = file.getParentFile();
        }
        File file3 = FileChooser.getLastChooserLocation(string);
        if (file3 != null && file3.exists()) {
            return file3;
        }
        String string2 = System.getProperty("user.home");
        if (string2 != null && (file2 = new File(string2).getAbsoluteFile()).exists()) {
            return file2;
        }
        file2 = new File("").getAbsoluteFile();
        assert (file2.exists()) : "Default directory '" + file2.getAbsolutePath() + "' does not exist";
        return file;
    }

    public int showDialog(Component component, String string) throws HeadlessException {
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)this, (File)FileChooser.getInitialDirectory(this.key, this.getCurrentDirectory()));
        return super.showDialog(component, string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("SelectedFileChangedProperty".equals(string)) {
            object2 = FileChooser.correctFile((File)object2);
        }
        super.firePropertyChange(string, object, object2);
    }

    public void approveSelection() {
        this.saveCurrentLocation();
        super.approveSelection();
    }

    private static File correctFile(File file) {
        while (file != null && ".".equals(file.getName())) {
            file = file.getParentFile();
        }
        return file;
    }

    private void saveCurrentLocation() {
        if (!this.isMultiSelectionEnabled() && this.isDirectorySelectionEnabled() && this.saveLocation(this.getSelectedFile())) {
            return;
        }
        this.saveLocation(this.getCurrentDirectory());
    }

    private boolean saveLocation(File file) {
        if (file != null && file.isDirectory()) {
            FileChooser.setLastChooserLocation(this.key, file);
            return true;
        }
        return false;
    }

    public static File getLastChooserLocation(String string) {
        String string2 = UserProjectSettings.getPreferences().get("lastUsedChooserLocations" + string, null);
        return string2 != null ? new File(string2) : null;
    }

    public static void setLastChooserLocation(String string, File file) {
        UserProjectSettings.getPreferences().put("lastUsedChooserLocations" + string, file.getPath());
    }

    public static FileChooser createDirectoryChooser(String string) {
        return FileChooser.createDirectoryChooser(string, null);
    }

    public static FileChooser createDirectoryChooser(String string, String string2) {
        FileChooser fileChooser = new FileChooser(string, string2);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(false);
        return fileChooser;
    }

    public static FileChooser createFileChooser(String string, String string2, FileFilter fileFilter) {
        FileChooser fileChooser = new FileChooser(string);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setDialogTitle(string2);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(fileFilter);
        return fileChooser;
    }
}

