/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.ProjectProperties;
import org.netbeans.modules.j2ee.common.project.ui.RemoveClassPathRootAction;
import org.netbeans.modules.j2ee.common.project.ui.ShowJavadocAction;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.actions.EditAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class ActionFilterNode
extends FilterNode {
    private static final int MODE_ROOT = 1;
    private static final int MODE_PACKAGE = 2;
    private static final int MODE_FILE = 3;
    private static final int MODE_FILE_CONTENT = 4;
    private final int mode;
    private Action[] actionCache;

    static ActionFilterNode create(Node node, UpdateHelper updateHelper, String string, String string2, String string3, ClassPathSupport classPathSupport, String[] stringArray, ReferenceHelper referenceHelper) {
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        assert (dataObject != null);
        FileObject fileObject = dataObject.getPrimaryFile();
        ProxyLookup proxyLookup = new ProxyLookup(new Lookup[]{node.getLookup(), updateHelper == null ? Lookups.singleton((Object)new JavadocProvider(fileObject, fileObject)) : Lookups.fixed((Object[])new Object[]{new Removable(updateHelper, string, string2, string3, classPathSupport, stringArray, referenceHelper), new JavadocProvider(fileObject, fileObject)})});
        return new ActionFilterNode(node, updateHelper == null ? 2 : 1, fileObject, (Lookup)proxyLookup);
    }

    private ActionFilterNode(Node node, int n, FileObject fileObject, FileObject fileObject2) {
        this(node, n, fileObject, (Lookup)new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.singleton((Object)new JavadocProvider(fileObject, fileObject2))}));
    }

    private ActionFilterNode(Node node, int n) {
        super(node, (Children)new ActionFilterChildren(node, n, null));
        this.mode = n;
    }

    private ActionFilterNode(Node node, int n, FileObject fileObject, Lookup lookup) {
        super(node, (Children)new ActionFilterChildren(node, n, fileObject), lookup);
        this.mode = n;
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray = this.initActions();
        return actionArray;
    }

    public Action getPreferredAction() {
        Action[] actionArray;
        if (this.mode == 3 && (actionArray = this.initActions()).length > 0 && (actionArray[0] instanceof OpenAction || actionArray[0] instanceof EditAction)) {
            return actionArray[0];
        }
        return null;
    }

    private Action[] initActions() {
        if (this.actionCache == null) {
            ArrayList<Action> arrayList = new ArrayList<Action>(2);
            if (this.mode == 3) {
                Action[] actionArray = super.getActions(false);
                for (int i = 0; i < actionArray.length; ++i) {
                    if (!(actionArray[i] instanceof OpenAction) && !(actionArray[i] instanceof EditAction)) continue;
                    arrayList.add(actionArray[i]);
                }
                arrayList.add((Action)SystemAction.get(ShowJavadocAction.class));
            } else if (this.mode == 2 || this.mode == 1) {
                arrayList.add((Action)SystemAction.get(ShowJavadocAction.class));
                Action[] actionArray = super.getActions(false);
                for (int i = 0; i < actionArray.length; ++i) {
                    if (!(actionArray[i] instanceof FindAction)) continue;
                    arrayList.add(actionArray[i]);
                }
                if (this.mode == 1) {
                    arrayList.add((Action)SystemAction.get(RemoveClassPathRootAction.class));
                }
            }
            this.actionCache = arrayList.toArray(new Action[arrayList.size()]);
        }
        return this.actionCache;
    }

    static class Removable
    implements RemoveClassPathRootAction.Removable {
        private final UpdateHelper helper;
        private final String classPathId;
        private final String entryId;
        private final String webModuleElementName;
        private final ClassPathSupport cs;
        private String[] libUpdaterProperties;
        private ReferenceHelper rh;

        Removable(UpdateHelper updateHelper, String string, String string2, String string3, ClassPathSupport classPathSupport, String[] stringArray, ReferenceHelper referenceHelper) {
            this.helper = updateHelper;
            this.classPathId = string;
            this.entryId = string2;
            this.webModuleElementName = string3;
            this.cs = classPathSupport;
            this.libUpdaterProperties = stringArray;
            this.rh = referenceHelper;
        }

        public boolean canRemove() {
            EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
            return editableProperties.getProperty(this.classPathId) != null;
        }

        public Project remove() {
            Object object;
            boolean bl = false;
            EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
            String string = editableProperties.getProperty(this.classPathId);
            List<ClassPathSupport.Item> list = this.cs.itemsList(string, this.webModuleElementName);
            String[] stringArray = list.iterator();
            while (stringArray.hasNext()) {
                object = stringArray.next();
                if (!this.entryId.equals(CommonProjectUtils.getAntPropertyName((String)((ClassPathSupport.Item)object).getReference()))) continue;
                stringArray.remove();
                if (Removable.isLastReference(this.entryId, editableProperties, this.classPathId)) {
                    Removable.destroyReference(this.rh, this.helper, (ClassPathSupport.Item)object);
                }
                bl = true;
            }
            if (bl) {
                stringArray = this.cs.encodeToStrings(list, this.webModuleElementName);
                editableProperties = this.helper.getProperties("nbproject/project.properties");
                editableProperties.setProperty(this.classPathId, stringArray);
                if (this.libUpdaterProperties != null) {
                    object = new HashSet();
                    for (String string2 : this.libUpdaterProperties) {
                        List<ClassPathSupport.Item> list2 = this.cs.itemsList(editableProperties.getProperty(string2), null);
                        ((AbstractCollection)object).addAll(list2);
                    }
                    ProjectProperties.storeLibrariesLocations(this.helper.getAntProjectHelper(), ((HashSet)object).iterator(), editableProperties);
                }
                this.helper.putProperties("nbproject/project.properties", editableProperties);
                return FileOwnerQuery.getOwner((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
            }
            return null;
        }

        private static boolean isLastReference(String string, EditableProperties editableProperties, String string2) {
            for (Map.Entry entry : editableProperties.entrySet()) {
                if (string2.equals(entry.getKey()) || !((String)entry.getValue()).contains(string)) continue;
                return false;
            }
            return true;
        }

        private static void destroyReference(ReferenceHelper referenceHelper, UpdateHelper updateHelper, ClassPathSupport.Item item) {
            if (item.getType() == 2 || item.getType() == 0) {
                referenceHelper.destroyReference(item.getReference());
                if (item.getType() == 0) {
                    EditableProperties editableProperties = updateHelper.getProperties("nbproject/project.properties");
                    if (item.getJavadocProperty() != null) {
                        editableProperties.remove((Object)item.getJavadocProperty());
                    }
                    if (item.getSourceProperty() != null) {
                        editableProperties.remove((Object)item.getSourceProperty());
                    }
                    updateHelper.putProperties("nbproject/project.properties", editableProperties);
                }
            }
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final FileObject cpRoot;
        private final FileObject resource;

        JavadocProvider(FileObject fileObject, FileObject fileObject2) {
            this.cpRoot = fileObject;
            this.resource = fileObject2;
        }

        public boolean hasJavadoc() {
            try {
                return this.resource != null && JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots().length > 0;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return false;
            }
        }

        public void showJavadoc() {
            try {
                URL uRL;
                String string = FileUtil.getRelativePath((FileObject)this.cpRoot, (FileObject)this.resource);
                URL[] uRLArray = JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots();
                if (string.length() == 0) {
                    uRL = ShowJavadocAction.findJavadoc("overview-summary.html", uRLArray);
                    if (uRL == null) {
                        uRL = ShowJavadocAction.findJavadoc("index.html", uRLArray);
                    }
                } else if (this.resource.isFolder()) {
                    uRL = ShowJavadocAction.findJavadoc("package-summary.html", uRLArray);
                } else {
                    String string2 = string.substring(0, string.lastIndexOf(46)) + ".html";
                    uRL = ShowJavadocAction.findJavadoc(string2, uRLArray);
                }
                ShowJavadocAction.showJavaDoc(uRL, string.replace('/', '.'));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
    }

    private static class ActionFilterChildren
    extends FilterNode.Children {
        private final int mode;
        private final FileObject cpRoot;

        ActionFilterChildren(Node node, int n, FileObject fileObject) {
            super(node);
            this.mode = n;
            this.cpRoot = fileObject;
        }

        protected Node[] createNodes(Node node) {
            switch (this.mode) {
                case 1: 
                case 2: {
                    DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                    if (dataObject == null) {
                        assert (false) : "DataNode without DataObject in Lookup";
                        return new Node[0];
                    }
                    if (dataObject.getPrimaryFile().isFolder()) {
                        return new Node[]{new ActionFilterNode(node, 2, this.cpRoot, dataObject.getPrimaryFile())};
                    }
                    return new Node[]{new ActionFilterNode(node, 3, this.cpRoot, dataObject.getPrimaryFile())};
                }
                case 3: 
                case 4: {
                    return new Node[]{new ActionFilterNode(node, 4)};
                }
            }
            assert (false) : "Unknown mode";
            return new Node[0];
        }
    }
}

