/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.StyledDocument;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.SourcePath;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.bpel.model.spi.FindHelper;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ModelUtil {
    private static FindHelper findHelper = (FindHelper)Lookup.getDefault().lookup(FindHelper.class);

    private ModelUtil() {
    }

    public static FindHelper getFindHelper() {
        return findHelper;
    }

    public static String getUrl(QName qName) {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        SourcePath sourcePath = (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
        if (sourcePath == null) {
            return null;
        }
        return sourcePath.getSourcePath(qName);
    }

    public static BpelModel getBpelModel(QName qName) {
        String string = ModelUtil.getUrl(qName);
        if (string == null) {
            return null;
        }
        return EditorUtil.getBpelModel(string);
    }

    public static String getXpath(final UniqueId uniqueId) {
        final BpelModel bpelModel = uniqueId.getModel();
        try {
            bpelModel.sync();
        }
        catch (IOException iOException) {
            return null;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyRunnable
        implements Runnable {
            private String result = null;

            MyRunnable() {
            }

            public String getResult() {
                return this.result;
            }

            @Override
            public void run() {
                if (!bpelModel.getState().equals((Object)Model.State.VALID)) {
                    return;
                }
                BpelEntity bpelEntity = bpelModel.getEntity(uniqueId);
                if (bpelEntity != null) {
                    this.result = EditorContextBridge.normalizeXpath((String)findHelper.getXPath(bpelEntity));
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        bpelModel.invoke((Runnable)myRunnable);
        return myRunnable.getResult();
    }

    public static UniqueId getBpelEntityId(final BpelModel bpelModel, final String string) {
        try {
            bpelModel.sync();
        }
        catch (IOException iOException) {
            return null;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyRunnable
        implements Runnable {
            private UniqueId result = null;

            MyRunnable() {
            }

            public UniqueId getResult() {
                return this.result;
            }

            @Override
            public void run() {
                if (!bpelModel.getState().equals((Object)Model.State.VALID)) {
                    return;
                }
                BpelEntity bpelEntity = ModelUtil.findBpelEntity(bpelModel, string);
                if (bpelEntity != null) {
                    this.result = bpelEntity.getUID();
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        bpelModel.invoke((Runnable)myRunnable);
        return myRunnable.getResult();
    }

    public static BpelEntity findBpelEntity(BpelModel bpelModel, String string) {
        Node node;
        if (bpelModel.getProcess() == null) {
            return null;
        }
        Document document = bpelModel.getProcess().getPeer().getOwnerDocument();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NamespaceContext namespaceContext = new NamespaceContext(){

            public String getNamespaceURI(String string) {
                if ("bpws".equals(string)) {
                    return "http://docs.oasis-open.org/wsbpel/2.0/process/executable";
                }
                return "";
            }

            public String getPrefix(String string) {
                if ("http://docs.oasis-open.org/wsbpel/2.0/process/executable".equals(string)) {
                    return "bpws";
                }
                return null;
            }

            public Iterator getPrefixes(String string) {
                String string2 = this.getPrefix(string);
                if (string2 != null) {
                    return Collections.singletonList(string2).iterator();
                }
                return Collections.emptyList().iterator();
            }
        };
        xPath.setNamespaceContext(namespaceContext);
        try {
            node = (Node)xPath.evaluate(string, document, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
        if (node instanceof Element) {
            AbstractDocumentModel abstractDocumentModel = (AbstractDocumentModel)bpelModel;
            List list = abstractDocumentModel.getAccess().getPathFromRoot(abstractDocumentModel.getDocument(), (Element)node);
            DocumentComponent documentComponent = abstractDocumentModel.findComponent(list);
            if (documentComponent instanceof BpelEntity) {
                return (BpelEntity)documentComponent;
            }
            return null;
        }
        return null;
    }

    public static UniqueId getBpelEntityId(final BpelModel bpelModel, final int n) {
        try {
            bpelModel.sync();
        }
        catch (IOException iOException) {
            return null;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyRunnable
        implements Runnable {
            private UniqueId result = null;

            MyRunnable() {
            }

            public UniqueId getResult() {
                return this.result;
            }

            @Override
            public void run() {
                if (!bpelModel.getState().equals((Object)Model.State.VALID)) {
                    return;
                }
                BpelEntity bpelEntity = bpelModel.findElement(n);
                if (bpelEntity != null) {
                    this.result = bpelEntity.getUID();
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        bpelModel.invoke((Runnable)myRunnable);
        return myRunnable.getResult();
    }

    public static int getLineNumber(final UniqueId uniqueId) {
        if (uniqueId == null) {
            return -1;
        }
        final BpelModel bpelModel = uniqueId.getModel();
        try {
            bpelModel.sync();
        }
        catch (IOException iOException) {
            return -1;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyRunnable
        implements Runnable {
            private int result = -1;

            MyRunnable() {
            }

            public int getResult() {
                return this.result;
            }

            @Override
            public void run() {
                if (!bpelModel.getState().equals((Object)Model.State.VALID)) {
                    return;
                }
                BpelEntity bpelEntity = bpelModel.getEntity(uniqueId);
                if (bpelEntity != null) {
                    this.result = bpelEntity.findPosition();
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        bpelModel.invoke((Runnable)myRunnable);
        int n = myRunnable.getResult();
        if (n < 0) {
            return -1;
        }
        StyledDocument styledDocument = (StyledDocument)bpelModel.getModelSource().getLookup().lookup(StyledDocument.class);
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n) + 1;
    }

    public static int getLineNumber(BpelModel bpelModel, String string) {
        return ModelUtil.getLineNumber(ModelUtil.getBpelEntityId(bpelModel, string));
    }
}

