/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BpelSessionView
implements TableModel,
Constants,
PropertyChangeListener {
    private Vector listeners = new Vector();

    public BpelSessionView(ContextProvider contextProvider) {
        BpelDebugger bpelDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
        bpelDebugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    private static String loc(String string) {
        return NbBundle.getBundle(BpelSessionView.class).getString(string);
    }

    private static String getSessionState(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return "";
        }
        BpelDebugger bpelDebugger = (BpelDebugger)debuggerEngine.lookupFirst(null, BpelDebugger.class);
        if (bpelDebugger != null) {
            switch (bpelDebugger.getState()) {
                case 4: {
                    return BpelSessionView.loc("MSG_Session_State_Disconnected");
                }
                case 2: {
                    return BpelSessionView.loc("MSG_Session_State_Running");
                }
                case 1: {
                    return BpelSessionView.loc("MSG_Session_State_Starting");
                }
            }
        }
        return "";
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof Session) {
            if (string.equals("SessionState")) {
                return BpelSessionView.getSessionState((Session)object);
            }
            if (string.equals("SessionLanguage")) {
                return object;
            }
            if (string.equals("SessionHostName")) {
                return ((Session)object).getLocationName();
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof Session) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireTreeChanged();
        if (propertyChangeEvent.getNewValue().equals(4)) {
            ((BpelDebugger)propertyChangeEvent.getSource()).removePropertyChangeListener("state", (PropertyChangeListener)this);
        }
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }
}

