/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.output;

import java.awt.EventQueue;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.netbeans.modules.bpel.debugger.api.Tracer;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class BpelOutputView
implements Tracer {
    private DateFormat myDateFormat = new SimpleDateFormat("HH:mm:ss");
    private OutputWriter myOutputWriter;
    private static boolean ourEnabled = System.getProperty("org.netbeans.modules.bpel.debugger.debug") != null;

    BpelOutputView(String string) {
        final String string2 = string == null ? NbBundle.getMessage(BpelOutputView.class, (String)"CTL_DebuggerConsoleName") : NbBundle.getMessage(BpelOutputView.class, (String)"CTL_DebuggerConsole", (Object)string);
        if (EventQueue.isDispatchThread()) {
            this.prepareOutput(string2);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BpelOutputView.this.prepareOutput(string2);
                }
            });
        }
    }

    public void println(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.myOutputWriter.println(this.myDateFormat.format(new Date()) + " " + string);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BpelOutputView.this.myOutputWriter.println(BpelOutputView.this.myDateFormat.format(new Date()) + " " + string);
                }
            });
        }
    }

    public void println(final Throwable throwable) {
        if (EventQueue.isDispatchThread()) {
            throwable.printStackTrace((PrintWriter)this.myOutputWriter);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    throwable.printStackTrace((PrintWriter)BpelOutputView.this.myOutputWriter);
                }
            });
        }
    }

    public void println(String string, Throwable throwable) {
        this.println(string);
        this.println(throwable);
    }

    public void debug(String string) {
        if (ourEnabled) {
            this.println(string);
        }
    }

    public void debug(Throwable throwable) {
        if (ourEnabled) {
            this.println(throwable);
        }
    }

    public void debug(String string, Throwable throwable) {
        if (ourEnabled) {
            this.println(string, throwable);
        }
    }

    private void prepareOutput(String string) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("output");
        if (topComponent != null) {
            topComponent.open();
            topComponent.requestActive();
        }
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        inputOutput.setFocusTaken(false);
        inputOutput.select();
        this.myOutputWriter = inputOutput.getOut();
    }
}

