/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.action;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class ToggleBreakpointGutterAction
extends SystemAction
implements AWTEventListener,
KeyListener {
    private JTextComponent textComponent;
    private JLabel tooltip;
    private Popup popup;
    private PopupFactory pf = null;
    private static String[] c = new String[]{"&", "<", ">", "\n", "\""};
    private static String[] tags = new String[]{"&amp;", "&lt;", "&gt;", "<br>", "&quot;"};

    public String getName() {
        return "bpel-toggle-breakpoint-gutter-action";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.invokeDefaultAction((JTextComponent)actionEvent.getSource())) {
            DebuggerManager.getDebuggerManager().getActionsManager().doAction(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
        }
    }

    private boolean invokeDefaultAction(final JTextComponent jTextComponent) {
        final Document document = jTextComponent.getDocument();
        if (document instanceof BaseDocument) {
            final int n = jTextComponent.getCaretPosition();
            final Annotations annotations = ((BaseDocument)document).getAnnotations();
            final boolean[] blArray = new boolean[]{true};
            final String[] stringArray = new String[1];
            final Point[] pointArray = new Point[1];
            document.render(new Runnable(){

                public void run() {
                    try {
                        Rectangle rectangle = jTextComponent.modelToView(n);
                        int n3 = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)n);
                        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)n3);
                        AnnotationDesc annotationDesc = annotations.getActiveAnnotation(n3);
                        if (annotationDesc == null || annotationDesc.getAnnotationType().equals("BpelBreakpoint_broken") || annotationDesc.getAnnotationType().equals("BpelBreakpoint_disabled") || annotationDesc.getAnnotationType().equals("BpelBreakpoint_normal")) {
                            blArray[0] = false;
                        } else {
                            Point point = jTextComponent.modelToView(n2).getLocation();
                            point.y += rectangle.height;
                            if (jTextComponent.getParent() instanceof JViewport) {
                                point.x += ((JViewport)jTextComponent.getParent()).getViewPosition().x;
                            }
                            stringArray[0] = annotationDesc.getShortDescription();
                            pointArray[0] = point;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify((Throwable)badLocationException);
                    }
                }
            });
            if (blArray[0]) {
                this.showPopup(stringArray[0], jTextComponent, pointArray[0]);
                return true;
            }
        }
        return false;
    }

    private void setComponent(JTextComponent jTextComponent) {
        boolean bl;
        boolean bl2 = bl = this.textComponent != jTextComponent;
        if (bl) {
            this.unregister();
            this.textComponent = jTextComponent;
            this.register();
        }
    }

    private void register() {
        if (this.textComponent == null) {
            return;
        }
        this.textComponent.addKeyListener(this);
    }

    private void unregister() {
        if (this.textComponent == null) {
            return;
        }
        this.textComponent.removeKeyListener(this);
    }

    private void showPopup(String string, JTextComponent jTextComponent, Point point) {
        if (jTextComponent == null) {
            return;
        }
        this.setComponent(jTextComponent);
        SwingUtilities.convertPointToScreen(point, jTextComponent);
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        this.tooltip = new JLabel("<html>" + this.translate(string));
        this.tooltip.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        this.popup = this.getPopupFactory().getPopup(jTextComponent, this.tooltip, point.x, point.y);
        this.popup.show();
    }

    private void removePopup() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.popup != null) {
            this.popup.hide();
            this.tooltip = null;
            this.popup = null;
        }
    }

    private PopupFactory getPopupFactory() {
        if (this.pf == null) {
            this.pf = PopupFactory.getSharedInstance();
        }
        return this.pf;
    }

    private String translate(String string) {
        for (int i = 0; i < c.length; ++i) {
            string = string.replaceAll(c[i], tags[i]);
        }
        return string;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        MouseEvent mouseEvent;
        if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getID() == 500 && mouseEvent.getClickCount() > 0) {
            this.removePopup();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        if (this.textComponent == null) {
            return;
        }
        boolean bl2 = bl = this.tooltip != null && this.tooltip.isShowing();
        if (bl) {
            this.removePopup();
            return;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

