/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.IdentityHashMap;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.bpel.debugger.api.AnnotationType;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.SourcePath;
import org.netbeans.modules.bpel.debugger.api.pem.PemEntity;
import org.netbeans.modules.bpel.debugger.api.pem.ProcessExecutionModel;
import org.netbeans.modules.bpel.debugger.api.psm.ProcessStaticModel;
import org.netbeans.modules.bpel.debugger.api.psm.PsmEntity;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.debugger.ui.util.ModelUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.openide.util.RequestProcessor;

public class ExecutionAnnotationsListener
extends DebuggerManagerAdapter
implements ProcessExecutionModel.Listener {
    private ProcessInstance myCurrentProcessInstance;
    private ProcessExecutionModel myCurrentPem;
    private BpelDebugger myCurrentDebugger;
    private SourcePath mySourcePath;
    private final AnnotationsHolder myAnnotationsHolder = new AnnotationsHolder();
    private RequestProcessor.Task myAnnotationTask;

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("currentEngine".equals(propertyChangeEvent.getPropertyName())) {
            this.updateCurrentDebugger();
            this.updateCurrentProcessInstance();
            this.annotate();
        } else if ("currentProcessInstance".equals(propertyChangeEvent.getPropertyName())) {
            this.updateCurrentProcessInstance();
            this.annotate();
        }
    }

    public void modelUpdated() {
        this.annotate();
    }

    private void updateCurrentDebugger() {
        BpelDebugger bpelDebugger = ExecutionAnnotationsListener.getCurrentDebugger();
        if (this.myCurrentDebugger == bpelDebugger) {
            return;
        }
        if (this.myCurrentDebugger != null) {
            this.myCurrentDebugger.removePropertyChangeListener("currentProcessInstance", (PropertyChangeListener)((Object)this));
        }
        if (bpelDebugger != null) {
            bpelDebugger.addPropertyChangeListener("currentProcessInstance", (PropertyChangeListener)((Object)this));
            this.mySourcePath = ExecutionAnnotationsListener.getCurrentSourcePath();
        }
        this.myCurrentDebugger = bpelDebugger;
    }

    private static BpelDebugger getCurrentDebugger() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return (BpelDebugger)debuggerEngine.lookupFirst(null, BpelDebugger.class);
    }

    private static SourcePath getCurrentSourcePath() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        return (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
    }

    private void updateCurrentProcessInstance() {
        this.myCurrentProcessInstance = this.myCurrentDebugger != null ? this.myCurrentDebugger.getCurrentProcessInstance() : null;
        this.updatePem();
    }

    private void updatePem() {
        if (this.myCurrentPem != null) {
            this.myCurrentPem.removeListener((ProcessExecutionModel.Listener)this);
        }
        if (this.myCurrentProcessInstance != null) {
            this.myCurrentPem = this.myCurrentProcessInstance.getProcessExecutionModel();
            if (this.myCurrentPem != null) {
                this.myCurrentPem.addListener((ProcessExecutionModel.Listener)this);
            }
        } else {
            this.myCurrentPem = null;
        }
    }

    private void annotate() {
        RequestProcessor.Task task = null;
        if (this.myAnnotationTask != null && !this.myAnnotationTask.cancel()) {
            task = this.myAnnotationTask;
        }
        AnnotationRunnable annotationRunnable = new AnnotationRunnable(task, this.myCurrentPem);
        this.myAnnotationTask = RequestProcessor.getDefault().post((Runnable)annotationRunnable, 200);
    }

    private class AnnotationsHolder {
        private ProcessStaticModel myAnnotatedPsm;
        private String myAnnotatedUrl;
        private BpelModel myModel;
        private Map<PsmEntity, Object> myAnnotations = new IdentityHashMap<PsmEntity, Object>();
        private Map<PsmEntity, AnnotationType> myAnnotationTypes = new IdentityHashMap<PsmEntity, AnnotationType>();

        private AnnotationsHolder() {
        }

        public synchronized void annotate(ProcessExecutionModel processExecutionModel) {
            if (processExecutionModel == null) {
                this.clearAll();
                return;
            }
            ProcessStaticModel processStaticModel = processExecutionModel.getProcessStaticModel();
            String string = ExecutionAnnotationsListener.this.mySourcePath.getSourcePath(processStaticModel.getProcessQName());
            if (string == null) {
                this.clearAll();
                return;
            }
            BpelModel bpelModel = EditorUtil.getBpelModel(string);
            if (!(string.equals(this.myAnnotatedUrl) && processStaticModel.equals(this.myAnnotatedPsm) && bpelModel.equals(this.myModel))) {
                this.clearAll();
                this.myAnnotatedPsm = processStaticModel;
                this.myAnnotatedUrl = string;
                this.myModel = bpelModel;
            }
            if (processExecutionModel.getRoot() != null) {
                this.annotatePemEntity(processExecutionModel.getRoot());
            } else {
                this.annotatePsmEntity(processStaticModel.getRoot());
            }
        }

        private void clearAll() {
            for (Object object : this.myAnnotations.values()) {
                if (object == null) continue;
                EditorContextBridge.removeAnnotation((Object)object);
            }
            this.myAnnotations.clear();
            this.myAnnotationTypes.clear();
            this.myAnnotatedPsm = null;
            this.myAnnotatedUrl = null;
        }

        private void annotatePemEntity(PemEntity pemEntity) {
            PsmEntity psmEntity = pemEntity.getPsmEntity();
            AnnotationType annotationType = this.annotationTypeByState(pemEntity.getState());
            this.updateAnnotation(psmEntity, annotationType);
            this.annotatePemEntityChildren(pemEntity);
        }

        private void annotatePemEntityChildren(PemEntity pemEntity) {
            PsmEntity psmEntity = pemEntity.getPsmEntity();
            if (!pemEntity.hasChildren()) {
                this.annotatePsmEntityChildren(psmEntity);
                return;
            }
            if (psmEntity.isLoop()) {
                int n = -1;
                PemEntity pemEntity2 = null;
                for (PemEntity pemEntity3 : pemEntity.getChildren()) {
                    if (pemEntity3.getLastStartedEventIndex() <= n) continue;
                    pemEntity2 = pemEntity3;
                    n = pemEntity3.getLastStartedEventIndex();
                }
                this.annotatePemEntity(pemEntity2);
                return;
            }
            for (PsmEntity psmEntity2 : psmEntity.getChildren()) {
                PemEntity[] pemEntityArray = pemEntity.getChildren(psmEntity2);
                if (pemEntityArray.length > 0) {
                    this.annotatePemEntity(pemEntityArray[0]);
                    continue;
                }
                this.annotatePsmEntity(psmEntity2);
            }
        }

        private void annotatePsmEntity(PsmEntity psmEntity) {
            this.updateAnnotation(psmEntity, AnnotationType.NEVER_EXECUTED_ELEMENT);
            this.annotatePsmEntityChildren(psmEntity);
        }

        private void annotatePsmEntityChildren(PsmEntity psmEntity) {
            for (PsmEntity psmEntity2 : psmEntity.getChildren()) {
                this.annotatePsmEntity(psmEntity2);
            }
        }

        private void updateAnnotation(PsmEntity psmEntity, AnnotationType annotationType) {
            if (this.myAnnotationTypes.get(psmEntity) != annotationType) {
                Object object = this.myAnnotations.get(psmEntity);
                if (object != null) {
                    EditorContextBridge.removeAnnotation((Object)object);
                }
                int n = ModelUtil.getLineNumber(this.myModel, psmEntity.getXpath());
                object = EditorContextBridge.addAnnotation((String)this.myAnnotatedUrl, (String)psmEntity.getXpath(), (int)n, (AnnotationType)annotationType);
                this.myAnnotations.put(psmEntity, object);
                this.myAnnotationTypes.put(psmEntity, annotationType);
            }
        }

        private AnnotationType annotationTypeByState(PemEntity.State state) {
            switch (state) {
                case STARTED: {
                    return AnnotationType.STARTED_ELEMENT;
                }
                case COMPLETED: {
                    return AnnotationType.COMPLETED_ELEMENT;
                }
            }
            return AnnotationType.STARTED_ELEMENT;
        }
    }

    private class AnnotationRunnable
    implements Runnable {
        private final RequestProcessor.Task myDependantTask;
        private final ProcessExecutionModel myPem;

        public AnnotationRunnable(RequestProcessor.Task task, ProcessExecutionModel processExecutionModel) {
            this.myDependantTask = task;
            this.myPem = processExecutionModel;
        }

        public void run() {
            if (this.myDependantTask != null) {
                this.myDependantTask.waitFinished();
            }
            ExecutionAnnotationsListener.this.myAnnotationsHolder.annotate(this.myPem);
        }
    }
}

