/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.editor.ClassFileReferenceFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.util.MethodInfoLinker;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberInfoVisitor;
import proguard.classfile.visitor.BottomClassFileFilter;
import proguard.classfile.visitor.ClassFileCleaner;
import proguard.classfile.visitor.ClassFileHierarchyTraveler;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.MemberInfoAccessFilter;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.MultiClassFileVisitor;
import proguard.classfile.visitor.MultiClassPoolVisitor;
import proguard.classfile.visitor.MultiMemberInfoVisitor;
import proguard.obfuscate.AttributeShrinker;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.obfuscate.ClassFileObfuscator;
import proguard.obfuscate.ClassFileOpener;
import proguard.obfuscate.ClassFileRenamer;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.MapCleaner;
import proguard.obfuscate.MappingKeeper;
import proguard.obfuscate.MappingPrinter;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.obfuscate.MemberInfoNameCleaner;
import proguard.obfuscate.MemberInfoNameCollector;
import proguard.obfuscate.MemberInfoNameConflictFilter;
import proguard.obfuscate.MemberInfoObfuscator;
import proguard.obfuscate.MemberInfoSpecialNameFilter;
import proguard.obfuscate.MultiMappingProcessor;
import proguard.obfuscate.NameAndTypeShrinker;
import proguard.obfuscate.NameAndTypeUsageMarker;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NameMarker;
import proguard.obfuscate.SimpleNameFactory;
import proguard.obfuscate.SourceFileRenamer;
import proguard.obfuscate.SpecialNameFactory;
import proguard.obfuscate.Utf8Shrinker;
import proguard.obfuscate.Utf8UsageMarker;

public class Obfuscator {
    private Configuration configuration;

    public Obfuscator(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        ClassFileVisitor classFileVisitor;
        if (this.configuration.keep == null && this.configuration.keepNames == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the obfuscation step.");
        }
        classPool.classFilesAccept(new ClassFileCleaner());
        classPool2.classFilesAccept(new ClassFileCleaner());
        if (this.configuration.useUniqueClassMemberNames) {
            classFileVisitor = new AllMemberInfoVisitor(new MethodInfoLinker());
            classPool.classFilesAccept(classFileVisitor);
            classPool2.classFilesAccept(classFileVisitor);
        } else {
            classPool.classFilesAccept(new BottomClassFileFilter(new MethodInfoLinker()));
        }
        classFileVisitor = new NameMarker();
        MultiClassPoolVisitor multiClassPoolVisitor = new MultiClassPoolVisitor(new ClassPoolVisitor[]{ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, classFileVisitor, (MemberInfoVisitor)((Object)classFileVisitor)), ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keepNames, classFileVisitor, (MemberInfoVisitor)((Object)classFileVisitor))});
        classPool.accept(multiClassPoolVisitor);
        classPool2.accept(multiClassPoolVisitor);
        classPool2.classFilesAccept(classFileVisitor);
        classPool2.classFilesAccept(new AllMemberInfoVisitor((MemberInfoVisitor)((Object)classFileVisitor)));
        if (this.configuration.applyMapping != null) {
            int n2;
            object3 = this.configuration.warn ? new WarningPrinter(System.err) : null;
            object2 = new MappingReader(this.configuration.applyMapping);
            object = new MultiMappingProcessor(new MappingProcessor[]{new MappingKeeper(classPool, (WarningPrinter)object3), new MappingKeeper(classPool2, null)});
            ((MappingReader)object2).pump((MappingProcessor)object);
            if (this.configuration.warn && (n2 = ((WarningPrinter)object3).getWarningCount()) > 0) {
                System.err.println("Warning: there were " + n2 + " kept classes and class members that were remapped anyway.");
                System.err.println("         You should adapt your configuration or edit the mapping file.");
                if (!this.configuration.ignoreWarnings) {
                    System.err.println("         If you are sure this remapping won't hurt,");
                    System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                    throw new IOException("Please correct the above warnings first.");
                }
            }
        }
        object3 = new AttributeUsageMarker();
        if (this.configuration.keepAttributes != null) {
            if (!this.configuration.keepAttributes.isEmpty()) {
                ((AttributeUsageMarker)object3).setKeepAttributes(this.configuration.keepAttributes);
            } else {
                ((AttributeUsageMarker)object3).setKeepAllAttributes();
            }
        }
        classPool.classFilesAccept((ClassFileVisitor)object3);
        classPool.classFilesAccept(new AttributeShrinker());
        classPool.classFilesAccept(new ClassFileObfuscator(classPool, this.configuration.defaultPackage, this.configuration.useMixedCaseClassNames));
        object2 = new SimpleNameFactory();
        if (this.configuration.obfuscationDictionary != null) {
            object2 = new DictionaryNameFactory(this.configuration.obfuscationDictionary, (NameFactory)object2);
        }
        object = this.configuration.warn ? new WarningPrinter(System.err) : null;
        HashMap hashMap = new HashMap();
        if (this.configuration.useUniqueClassMemberNames) {
            classPool.classFilesAccept(new AllMemberInfoVisitor(new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap)));
            classPool.classFilesAccept(new AllMemberInfoVisitor(new MemberInfoObfuscator(this.configuration.overloadAggressively, (NameFactory)object2, hashMap, (WarningPrinter)object)));
        } else {
            classPool.classFilesAccept(new MultiClassFileVisitor(new ClassFileVisitor[]{new AllMemberInfoVisitor(new MemberInfoAccessFilter(2, 0, new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap))), new ClassFileHierarchyTraveler(true, false, false, true, new BottomClassFileFilter(new ClassFileHierarchyTraveler(true, true, true, false, new AllMemberInfoVisitor(new MemberInfoAccessFilter(0, 2, new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap)))))), new AllMemberInfoVisitor(new MemberInfoAccessFilter(0, 2, new MemberInfoObfuscator(this.configuration.overloadAggressively, (NameFactory)object2, hashMap, (WarningPrinter)object))), new MapCleaner(hashMap)}));
            classPool.classFilesAccept(new MultiClassFileVisitor(new ClassFileVisitor[]{new AllMemberInfoVisitor(new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap)), new ClassFileHierarchyTraveler(false, true, true, false, new AllMemberInfoVisitor(new MemberInfoAccessFilter(0, 2, new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap)))), new AllMemberInfoVisitor(new MemberInfoAccessFilter(2, 0, new MemberInfoObfuscator(this.configuration.overloadAggressively, (NameFactory)object2, hashMap, (WarningPrinter)object))), new MapCleaner(hashMap)}));
        }
        classPool.classFilesAccept(new AllMemberInfoVisitor(new MemberInfoSpecialNameFilter(new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap))));
        classPool2.classFilesAccept(new AllMemberInfoVisitor(new MemberInfoSpecialNameFilter(new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap))));
        classPool.classFilesAccept(new AllMemberInfoVisitor(new MemberInfoNameConflictFilter(new MultiMemberInfoVisitor(new MemberInfoVisitor[]{new MemberInfoNameCleaner(), new MemberInfoObfuscator(this.configuration.overloadAggressively, new SpecialNameFactory(new SimpleNameFactory()), hashMap, (WarningPrinter)object)}))));
        if (this.configuration.warn && (n = ((WarningPrinter)object).getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n + " conflicting class member name mappings.");
            System.err.println("         Your configuration may be inconsistent.");
            if (!this.configuration.ignoreWarnings) {
                System.err.println("         If you are sure the conflicts are harmless,");
                System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
        if (this.configuration.printMapping != null) {
            PrintStream printStream = this.isFile(this.configuration.printMapping) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printMapping))) : System.out;
            classPool.classFilesAcceptAlphabetically(new MappingPrinter(printStream));
            if (printStream != System.out) {
                printStream.close();
            }
        }
        classPool.classFilesAccept(new ClassFileRenamer());
        classPool2.classFilesAccept(new ClassFileRenamer());
        classPool.classFilesAccept(new ClassFileReferenceFixer(false));
        classPool2.classFilesAccept(new ClassFileReferenceFixer(false));
        classPool.classFilesAccept(new MemberReferenceFixer(1024));
        if (this.configuration.defaultPackage != null) {
            classPool.classFilesAccept(new ClassFileOpener());
        }
        if (this.configuration.newSourceFileAttribute != null) {
            classPool.classFilesAccept(new SourceFileRenamer(this.configuration.newSourceFileAttribute));
        }
        classPool.classFilesAccept(new NameAndTypeUsageMarker());
        classPool.classFilesAccept(new NameAndTypeShrinker(1024));
        classPool.classFilesAccept(new Utf8UsageMarker());
        classPool.classFilesAccept(new Utf8Shrinker(1024));
    }

    private boolean isFile(File file) {
        return file.getPath().length() > 0;
    }
}

