/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.InstructionConstants;
import proguard.classfile.instruction.InstructionVisitor;

public abstract class Instruction {
    private static final boolean[] IS_CATEGORY2 = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, false, true, true, false, false, false, false, true, false, true, false, true, false, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, false, true, false, true, false, false, false, false, false, true, false, true, false, false, false, false, false, true, true, true, true, false, false, false, false, true, true, true, true, false, false, false, false, false, true, false, true, false, false, false, false, false, true, false, false, false, true, true, true, false, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, false, false, false, true, true, true, false, false, false, true, true, true, false, false, false, true, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final int[] STACK_POP_COUNTS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 3, 4, 3, 4, 3, 3, 3, 3, 1, 2, 1, 2, 3, 2, 3, 4, 2, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 1, 2, 1, 2, 2, 3, 2, 3, 2, 3, 2, 4, 2, 4, 2, 4, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 4, 2, 2, 4, 4, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 1, 2, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0};
    private static final int[] STACK_PUSH_COUNTS = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 4, 5, 6, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 2, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1};
    public byte opcode;

    public abstract Instruction shrink();

    public final void write(CodeAttrInfo codeAttrInfo, int n) {
        byte[] byArray = codeAttrInfo.code;
        if (this.isWide()) {
            byArray[n++] = -60;
        }
        byArray[n++] = this.opcode;
        this.writeInfo(byArray, n);
    }

    protected boolean isWide() {
        return false;
    }

    protected abstract void readInfo(byte[] var1, int var2);

    protected abstract void writeInfo(byte[] var1, int var2);

    public abstract int length(int var1);

    public abstract void accept(ClassFile var1, MethodInfo var2, CodeAttrInfo var3, int var4, InstructionVisitor var5);

    public abstract String toString(int var1);

    public String getName() {
        return InstructionConstants.NAMES[this.opcode & 0xFF];
    }

    public boolean isCategory2() {
        return IS_CATEGORY2[this.opcode & 0xFF];
    }

    public int stackPopCount(ClassFile classFile) {
        return STACK_POP_COUNTS[this.opcode & 0xFF];
    }

    public int stackPushCount(ClassFile classFile) {
        return STACK_PUSH_COUNTS[this.opcode & 0xFF];
    }

    protected static int readByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    protected static int readShort(byte[] byArray, int n) {
        return (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    protected static int readInt(byte[] byArray, int n) {
        return byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    protected static int readValue(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return Instruction.readByte(byArray, n);
            }
            case 2: {
                return Instruction.readShort(byArray, n);
            }
            case 4: {
                return Instruction.readInt(byArray, n);
            }
        }
        throw new IllegalArgumentException("Unsupported value size [" + n2 + "]");
    }

    protected static int readSignedByte(byte[] byArray, int n) {
        return byArray[n];
    }

    protected static int readSignedShort(byte[] byArray, int n) {
        return byArray[n++] << 8 | byArray[n] & 0xFF;
    }

    protected static int readSignedValue(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return Instruction.readSignedByte(byArray, n);
            }
            case 2: {
                return Instruction.readSignedShort(byArray, n);
            }
            case 4: {
                return Instruction.readInt(byArray, n);
            }
        }
        throw new IllegalArgumentException("Unsupported value size [" + n2 + "]");
    }

    protected static void writeByte(byte[] byArray, int n, int n2) {
        if (n2 > 255) {
            throw new IllegalArgumentException("Byte value larger than 0xff [" + n2 + "]");
        }
        byArray[n] = (byte)n2;
    }

    protected static void writeShort(byte[] byArray, int n, int n2) {
        if (n2 > 65535) {
            throw new IllegalArgumentException("Short value larger than 0xffff [" + n2 + "]");
        }
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n] = (byte)n2;
    }

    protected static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n] = (byte)n2;
    }

    protected static void writeValue(byte[] byArray, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                Instruction.writeByte(byArray, n, n2);
                break;
            }
            case 2: {
                Instruction.writeShort(byArray, n, n2);
                break;
            }
            case 4: {
                Instruction.writeInt(byArray, n, n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value size [" + n3 + "]");
            }
        }
    }
}

