/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.visitor.CpInfoVisitor;

public class Utf8CpInfo
extends CpInfo {
    private static final String ENCODING = "UTF-8";
    private static final char TWO_BYTE_LIMIT = '\u0080';
    private static final byte TWO_BYTE_CONSTANT1 = -64;
    private static final byte TWO_BYTE_CONSTANT2 = -128;
    private static final int TWO_BYTE_SHIFT1 = 6;
    private static final byte TWO_BYTE_MASK1 = 31;
    private static final byte TWO_BYTE_MASK2 = 63;
    private static final char THREE_BYTE_LIMIT = '\u0800';
    private static final byte THREE_BYTE_CONSTANT1 = -32;
    private static final byte THREE_BYTE_CONSTANT2 = -128;
    private static final byte THREE_BYTE_CONSTANT3 = -128;
    private static final int THREE_BYTE_SHIFT1 = 12;
    private static final int THREE_BYTE_SHIFT2 = 6;
    private static final byte THREE_BYTE_MASK1 = 15;
    private static final byte THREE_BYTE_MASK2 = 63;
    private static final byte THREE_BYTE_MASK3 = 63;
    private byte[] bytes;
    private String utf8string;

    protected Utf8CpInfo() {
    }

    public Utf8CpInfo(String string) {
        this.bytes = null;
        this.utf8string = string;
    }

    public String getString() {
        try {
            this.switchToStringRepresentation();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.utf8string;
    }

    public void setString(String string) throws Exception {
        this.bytes = null;
        this.utf8string = string;
    }

    public int getTag() {
        return 1;
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        this.bytes = new byte[n];
        dataInput.readFully(this.bytes);
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        byte[] byArray = this.getByteArrayRepresentation();
        int n = byArray.length;
        dataOutput.writeShort(n);
        dataOutput.write(byArray);
    }

    public void accept(ClassFile classFile, CpInfoVisitor cpInfoVisitor) {
        cpInfoVisitor.visitUtf8CpInfo(classFile, this);
    }

    private void switchToStringRepresentation() throws UnsupportedEncodingException {
        if (this.utf8string == null) {
            this.utf8string = new String(this.bytes, ENCODING);
            this.bytes = null;
        }
    }

    private byte[] getByteArrayRepresentation() throws UnsupportedEncodingException {
        int n;
        if (this.bytes != null) {
            return this.bytes;
        }
        int n2 = 0;
        int n3 = this.utf8string.length();
        for (int i = 0; i < n3; ++i) {
            n = this.utf8string.charAt(i);
            n2 += n == 0 ? 2 : (n < 128 ? 1 : (n < 2048 ? 2 : 3));
        }
        byte[] byArray = new byte[n2];
        n = 0;
        for (int i = 0; i < n3; ++i) {
            char c = this.utf8string.charAt(i);
            if (c == '\u0000') {
                byArray[n++] = -64;
                byArray[n++] = -128;
                continue;
            }
            if (c < '\u0080') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n++] = (byte)(0xFFFFFFC0 | c >>> 6 & 0x1F);
                byArray[n++] = (byte)(0xFFFFFF80 | c & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xFFFFFFE0 | c >>> 12 & 0xF);
            byArray[n++] = (byte)(0xFFFFFF80 | c >>> 6 & 0x3F);
            byArray[n++] = (byte)(0xFFFFFF80 | c & 0x3F);
        }
        return byArray;
    }
}

