/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.search.impl.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.modules.bpel.search.api.SearchElement;
import org.netbeans.modules.bpel.search.api.SearchEvent;
import org.netbeans.modules.bpel.search.api.SearchException;
import org.netbeans.modules.bpel.search.api.SearchMatch;
import org.netbeans.modules.bpel.search.api.SearchOption;
import org.netbeans.modules.bpel.search.spi.SearchEngine;
import org.netbeans.modules.bpel.search.spi.SearchListener;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.xam.ui.search.Query;
import org.netbeans.modules.xml.xam.ui.search.SearchControlPanel;
import org.netbeans.modules.xml.xam.ui.search.SearchProvider;
import org.openide.actions.FindAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Find
extends SearchControlPanel {
    private List<Object> myElements;
    private List<Provider> myProviders;

    public Find(List<SearchEngine> list, Object object, JComponent jComponent) {
        this.bindAction(jComponent);
        this.myProviders = new ArrayList<Provider>();
        for (SearchEngine searchEngine : list) {
            this.myProviders.add(new Provider(searchEngine, object));
        }
        this.setProviders(this.myProviders);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            return;
        }
        for (Provider provider : this.myProviders) {
            provider.release();
        }
    }

    protected void hideResults() {
        if (this.myElements == null) {
            return;
        }
        for (Object object : this.myElements) {
            ((SearchElement)object).unhighlight();
        }
        this.myElements = null;
    }

    protected void showSearchResult(Object object) {
        if (!(object instanceof SearchElement)) {
            return;
        }
        ((SearchElement)object).gotoDesign();
    }

    private void bindAction(JComponent jComponent) {
        FindAction findAction = (FindAction)FindAction.get(FindAction.class);
        Object object = findAction.getActionMapKey();
        jComponent.getActionMap().put(object, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Find.this.setVisible(true);
            }
        });
        InputMap inputMap = jComponent.getInputMap(1);
        KeyStroke keyStroke = (KeyStroke)findAction.getValue("AcceleratorKey");
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke(70, 2);
        }
        inputMap.put(keyStroke, object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Provider
    implements SearchProvider,
    SearchListener {
        private Object mySource;
        private SearchEngine mySearchEngine;

        private Provider(SearchEngine searchEngine, Object object) {
            this.mySearchEngine = searchEngine;
            this.mySearchEngine.addSearchListener(this);
            this.mySource = object;
        }

        void release() {
            this.mySearchEngine.removeSearchListeners();
        }

        public String getDisplayName() {
            return this.mySearchEngine.getDisplayName();
        }

        public String getShortDescription() {
            return this.mySearchEngine.getShortDescription();
        }

        public String getInputDescription() {
            return UI.i18n(Provider.class, (String)"LBL_Input_Description");
        }

        public List<Object> search(Query query) throws org.netbeans.modules.xml.xam.ui.search.SearchException {
            SearchMatch searchMatch = this.getMatch(query);
            String string = this.getText(query, searchMatch);
            SearchOption.Adapter adapter = new SearchOption.Adapter(string, this.mySource, null, searchMatch, false, query.useSelected());
            try {
                this.mySearchEngine.search(adapter);
            }
            catch (SearchException searchException) {
                throw new org.netbeans.modules.xml.xam.ui.search.SearchException(searchException.getMessage(), (Throwable)searchException);
            }
            return Find.this.myElements;
        }

        private SearchMatch getMatch(Query query) {
            if (query.isRegularExpression()) {
                return SearchMatch.REGULAR_EXPRESSION;
            }
            return SearchMatch.PATTERN;
        }

        private String getText(Query query, SearchMatch searchMatch) {
            String string = query.getQuery().trim();
            if (searchMatch == SearchMatch.PATTERN) {
                return "*" + string + "*";
            }
            return string;
        }

        @Override
        public void searchStarted(SearchEvent searchEvent) {
            Find.this.myElements = new ArrayList();
        }

        @Override
        public void searchFound(SearchEvent searchEvent) {
            Find.this.myElements.add(searchEvent.getSearchElement());
        }

        @Override
        public void searchFinished(SearchEvent searchEvent) {
        }
    }
}

