/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.search.impl.output;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.search.api.SearchElement;
import org.netbeans.modules.bpel.search.impl.ui.Export;
import org.netbeans.modules.bpel.search.impl.util.Util;
import org.netbeans.modules.print.api.PrintManager;
import org.netbeans.modules.soa.ui.util.UI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Tree
extends JTree {
    private int myIndex;
    private String myText;
    private Export myExport;
    private boolean myIsReformAll;
    private DefaultMutableTreeNode myRoot = (DefaultMutableTreeNode)this.getModel().getRoot();
    private List<DefaultMutableTreeNode> myOccurences;
    private static final Icon EMPTY = UI.icon(Util.class, (String)"empty");

    Tree() {
        super(new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    void addElement(SearchElement searchElement) {
        this.addElement(this.myRoot, searchElement, this.getParents(searchElement));
    }

    private void addElement(MutableTreeNode mutableTreeNode, SearchElement searchElement, Iterator<SearchElement> iterator) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        SearchElement searchElement2 = null;
        if (iterator.hasNext()) {
            searchElement2 = iterator.next();
        }
        if (searchElement2 == null) {
            mutableTreeNode.insert(new DefaultMutableTreeNode(searchElement), 0);
            return;
        }
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.isLeaf() || !defaultMutableTreeNode.getUserObject().equals(searchElement2)) continue;
            this.addElement(defaultMutableTreeNode, searchElement, iterator);
            return;
        }
        defaultMutableTreeNode = new DefaultMutableTreeNode(searchElement2);
        mutableTreeNode.insert(defaultMutableTreeNode, 0);
        this.addElement(defaultMutableTreeNode, searchElement, iterator);
    }

    void finished(String string, String string2, int n) {
        this.myText = UI.i18n(Tree.class, (String)"LBL_Search_Tab", (String)string, (String)string2);
        String string3 = UI.i18n(Tree.class, (String)"LBL_Found", (String)string, (String)string2, (String)("" + n));
        String string4 = UI.i18n(Tree.class, (String)"LBL_Catchword", (String)string, (String)string2, (String)("" + n));
        this.myRoot.setUserObject(new SearchElement.Adapter(string3, string3, UI.icon(Util.class, (String)"find"), null));
        this.putClientProperty(Printable.class, string4);
        this.createOccurences();
        this.updateRoot();
        this.expose(this.myRoot);
    }

    @Override
    public String toString() {
        return this.myText;
    }

    private void createOccurences() {
        this.myOccurences = new ArrayList<DefaultMutableTreeNode>();
        this.createOccurences(this.myRoot);
        this.myIndex = -1;
    }

    private void createOccurences(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (defaultMutableTreeNode.isLeaf()) {
            this.myOccurences.add(defaultMutableTreeNode);
        }
        while (enumeration.hasMoreElements()) {
            this.createOccurences((DefaultMutableTreeNode)enumeration.nextElement());
        }
    }

    private void updateRoot() {
        this.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TreeRenderer());
        this.setShowsRootHandles(false);
        this.setRootVisible(true);
        this.setSelectionPath(new TreePath(this.myRoot.getPath()));
        this.expandPath(new TreePath(this.myRoot.getPath()));
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
                Tree.this.collapseChildren(Tree.this.getNode(treeExpansionEvent.getPath()));
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Tree.this.expandChildren(Tree.this.getNode(treeExpansionEvent.getPath()));
                Tree.this.updateSize();
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                Tree.this.updateSize();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    Tree.this.showPopupMenu(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && Tree.this.getSelectedNode().isLeaf()) {
                    Tree.this.gotoDesign(Tree.this.getSelectedNode());
                    mouseEvent.consume();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Tree.this.handleEvent(keyEvent);
            }
        });
        this.updateSize();
    }

    private void handleEvent(KeyEvent keyEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n == 121 && UI.isShift((int)n2)) {
            this.showPopupMenu(keyEvent, 0, 0);
        } else {
            this.handleAction(n, n2, defaultMutableTreeNode);
        }
    }

    private void handleAction(int n, int n2, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (n == 67 && UI.isCtrl((int)n2)) {
            this.copy(defaultMutableTreeNode);
        } else if (n == 123 && UI.isShift((int)n2)) {
            this.previousOccurence(defaultMutableTreeNode);
        } else if (n == 123) {
            this.nextOccurence(defaultMutableTreeNode);
        } else if (n == 127) {
            this.remove(defaultMutableTreeNode);
        } else if (n == 79 && UI.isAlt((int)n2)) {
            this.gotoSource(defaultMutableTreeNode);
        }
    }

    private void showPopupMenu(ComponentEvent componentEvent, int n, int n2) {
        final DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.createAction(jPopupMenu, defaultMutableTreeNode);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = this.createItem("LBL_Remove");
        jMenuItem.setEnabled(!defaultMutableTreeNode.isRoot());
        jMenuItem.setIcon(EMPTY);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.remove(defaultMutableTreeNode);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = this.createItem("LBL_Previous_Occurence");
        jMenuItem.setEnabled(true);
        jMenuItem.setIcon(UI.icon(Util.class, (String)"previous"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.previousOccurence(defaultMutableTreeNode);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(123, 1));
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Next_Occurence");
        jMenuItem.setEnabled(true);
        jMenuItem.setIcon(UI.icon(Util.class, (String)"next"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.nextOccurence(defaultMutableTreeNode);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = this.createItem("LBL_Export");
        jMenuItem.setIcon(UI.icon(Util.class, (String)"export"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.export(defaultMutableTreeNode);
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Print_Preview");
        jMenuItem.setEnabled(true);
        jMenuItem.setIcon(this.getPrintIcon());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.getDefault().getPrintPreviewAction().actionPerformed(actionEvent);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 11));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(componentEvent.getComponent(), n, n2);
    }

    private void createAction(JPopupMenu jPopupMenu, final DefaultMutableTreeNode defaultMutableTreeNode) {
        JMenuItem jMenuItem = this.createItem("LBL_Go_to_Design");
        jMenuItem.setEnabled(!defaultMutableTreeNode.isRoot());
        jMenuItem.setIcon(EMPTY);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.gotoDesign(defaultMutableTreeNode);
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Go_to_Source");
        jMenuItem.setEnabled(!defaultMutableTreeNode.isRoot());
        jMenuItem.setIcon(EMPTY);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.gotoSource(defaultMutableTreeNode);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Copy");
        jMenuItem.setIcon(UI.icon(Util.class, (String)"copy"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.copy(defaultMutableTreeNode);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createItem("LBL_Collapse_Expand");
        jMenuItem.setEnabled(!defaultMutableTreeNode.isLeaf());
        jMenuItem.setIcon(UI.icon(Util.class, (String)"expose"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tree.this.expose(defaultMutableTreeNode);
            }
        });
        jPopupMenu.add(jMenuItem);
    }

    private Icon getPrintIcon() {
        Object object = PrintManager.getDefault().getPrintPreviewAction().getValue("SmallIcon");
        if (object instanceof Icon) {
            return (Icon)object;
        }
        return EMPTY;
    }

    private void updateSize() {
        this.putClientProperty(Dimension.class, this.getMaximumSize());
    }

    private void gotoSource(DefaultMutableTreeNode defaultMutableTreeNode) {
        ((SearchElement)defaultMutableTreeNode.getUserObject()).gotoSource();
    }

    private void gotoDesign(DefaultMutableTreeNode defaultMutableTreeNode) {
        ((SearchElement)defaultMutableTreeNode.getUserObject()).gotoDesign();
    }

    void previousOccurence() {
        this.previousOccurence(this.getSelectedNode());
    }

    private void previousOccurence(TreeNode treeNode) {
        --this.myIndex;
        if (this.myIndex < 0) {
            this.myIndex = this.myOccurences.size() - 1;
        }
        this.selectOccurence();
        this.requestFocus();
    }

    void nextOccurence() {
        this.nextOccurence(this.getSelectedNode());
    }

    private void nextOccurence(TreeNode treeNode) {
        ++this.myIndex;
        if (this.myIndex == this.myOccurences.size()) {
            this.myIndex = 0;
        }
        this.selectOccurence();
        this.requestFocus();
    }

    private void selectOccurence() {
        TreePath treePath = new TreePath(this.myOccurences.get(this.myIndex).getPath());
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void copy(TreeNode treeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        this.copy(treeNode, stringBuffer, "");
        stringBuffer.append(UI.LS);
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    private void copy(TreeNode treeNode, StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + treeNode + UI.LS);
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            this.copy(treeNode2, stringBuffer, string + "    ");
        }
    }

    void export() {
        this.export(this.getSelectedNode());
    }

    private void export(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        this.export(defaultMutableTreeNode, arrayList);
        arrayList.add(null);
        if (this.myExport == null) {
            this.myExport = new Export();
        }
        this.myExport.show(arrayList, this.myRoot.toString());
        this.requestFocus();
    }

    private void export(DefaultMutableTreeNode defaultMutableTreeNode, List<List<String>> list) {
        Object object;
        if (defaultMutableTreeNode.isLeaf()) {
            object = new ArrayList();
            object.add(this.getDescription(defaultMutableTreeNode));
            object.add(defaultMutableTreeNode.toString());
            list.add((List<String>)object);
        }
        object = defaultMutableTreeNode.children();
        while (object.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object.nextElement();
            this.export(defaultMutableTreeNode2, list);
        }
    }

    private String getDescription(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.isRoot(defaultMutableTreeNode)) {
            return "";
        }
        String string = this.getDescription((DefaultMutableTreeNode)defaultMutableTreeNode.getParent());
        if (!defaultMutableTreeNode.isLeaf()) {
            if (!this.isRoot((DefaultMutableTreeNode)defaultMutableTreeNode.getParent())) {
                string = string + UI.LS;
            }
            string = string + defaultMutableTreeNode;
        }
        return string;
    }

    private boolean isRoot(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return true;
        }
        if (defaultMutableTreeNode.getParent() == null) {
            return true;
        }
        return defaultMutableTreeNode.getParent().getParent() == null;
    }

    void expose() {
        this.expose(this.getSelectedNode());
    }

    private void expose(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.isLeaf()) {
            return;
        }
        this.myIsReformAll = true;
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        boolean bl = this.isExpanded(treePath);
        if (defaultMutableTreeNode.isRoot()) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            bl = false;
            while (enumeration.hasMoreElements() && !(bl = this.isExpanded(new TreePath((defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement()).getPath())))) {
            }
        }
        if (bl) {
            if (defaultMutableTreeNode.isRoot()) {
                this.collapseChildren(defaultMutableTreeNode);
            } else {
                this.collapsePath(treePath);
            }
        } else {
            this.expandPath(treePath);
            if (this.isExpanded(treePath)) {
                this.expandChildren(defaultMutableTreeNode);
            }
        }
        this.myIsReformAll = false;
        this.requestFocus();
    }

    private void expandChildren(TreeNode treeNode) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        if (this.myIsReformAll) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                this.expandPath(treePath);
                if (!this.isExpanded(treePath)) continue;
                this.expandChildren(defaultMutableTreeNode);
            }
        } else if (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!enumeration.hasMoreElements()) {
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                this.expandPath(treePath);
                if (this.isExpanded(treePath)) {
                    this.expandChildren(defaultMutableTreeNode);
                }
            }
        }
    }

    private void collapseChildren(TreeNode treeNode) {
        if (this.myIsReformAll) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                this.collapsePath(treePath);
            }
        }
    }

    private void remove(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode2 == null) {
            return;
        }
        if (UI.printConfirmation((String)UI.i18n(Tree.class, (String)"LBL_Are_You_Sure"))) {
            defaultMutableTreeNode2.remove(defaultMutableTreeNode);
            this.updateUI();
        }
    }

    private DefaultMutableTreeNode getNode(TreePath treePath) {
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return this.myRoot;
        }
        TreePath treePath = treePathArray[0];
        if (treePath == null) {
            return this.myRoot;
        }
        return this.getNode(treePath);
    }

    private JMenuItem createItem(String string) {
        return new JMenuItem(UI.i18n(Tree.class, (String)string));
    }

    private Iterator<SearchElement> getParents(SearchElement searchElement) {
        ArrayList<SearchElement> arrayList = new ArrayList<SearchElement>();
        for (SearchElement searchElement2 = searchElement.getParent(); searchElement2 != null; searchElement2 = searchElement2.getParent()) {
            arrayList.add(0, searchElement2);
        }
        return arrayList.iterator();
    }

    @Override
    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string;
        if (object != null && (string = object.toString()) != null) {
            int n2 = string.lastIndexOf(".");
            if (n2 == -1) {
                return string;
            }
            return string.substring(n2 + 1);
        }
        return "";
    }

    private static final class TreeRenderer
    extends DefaultTreeCellRenderer {
        private TreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            SearchElement searchElement = (SearchElement)((DefaultMutableTreeNode)object).getUserObject();
            this.setText("<html>" + this.getHtmlName(searchElement.getName(), bl3, n) + "</html>");
            this.setToolTipText(searchElement.getToolTip());
            this.setIcon(searchElement.getIcon());
            return this;
        }

        private String getHtmlName(String string, boolean bl, int n) {
            if (n == 0) {
                return string;
            }
            if (bl) {
                int n2 = string.lastIndexOf(".");
                if (n2 == -1) {
                    return this.getBold(string);
                }
                return this.getGrey(string.substring(0, n2 + 1)) + this.getBold(string.substring(n2 + 1));
            }
            return this.getGrey(string);
        }

        private String getGrey(String string) {
            return "<font color=\"#999999\">" + string + "</font>";
        }

        private String getBold(String string) {
            return "<b>" + string + "</b>";
        }
    }
}

