/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.model.lang.syntax;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.asm.model.lang.AsmOffsetable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmModelStream
implements Iterable<AsmOffsetable> {
    private final List<AsmOffsetable> elements;

    public AsmModelStream(List<AsmOffsetable> list) {
        this.elements = Collections.unmodifiableList(list);
    }

    @Override
    public Iterator<AsmOffsetable> iterator() {
        return this.elements.iterator();
    }

    public AsmOffsetable get(int n) {
        return this.elements.get(n);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean equals(Object object) {
        if (object instanceof AsmModelStream) {
            return ((Object)this.elements).equals(((AsmModelStream)object).elements);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    public void forEach(ElementVisitor elementVisitor, AsmFilter asmFilter) {
        for (AsmOffsetable asmOffsetable : this) {
            if (asmFilter.accept(asmOffsetable) && !elementVisitor.visit(asmOffsetable)) break;
        }
    }

    public void forEach(ElementVisitor elementVisitor) {
        this.forEach(elementVisitor, TrueFilter.instance);
    }

    public static final class TrueFilter
    implements AsmFilter {
        public static final AsmFilter instance = new TrueFilter();

        public boolean accept(AsmOffsetable asmOffsetable) {
            return true;
        }

        private TrueFilter() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClazzFilter
    implements AsmFilter {
        private Class<?> cl;

        @Override
        public boolean accept(AsmOffsetable asmOffsetable) {
            return asmOffsetable.getClass() == this.cl;
        }

        public ClazzFilter(Class<?> clazz) {
            this.cl = clazz;
        }
    }

    public static interface AsmFilter {
        public boolean accept(AsmOffsetable var1);
    }

    static interface ElementVisitor {
        public boolean visit(AsmOffsetable var1);
    }
}

