/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.dialog.NewSequenceDialog;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceContainerEditor;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SequenceContainer
extends Editable {
    public static final String PROPERTY_DEFAULT_SEQUENCE = "sequencecontainer.prop.defaultsequence";

    @Override
    public void addPropertyChangeListener(PropertyChangeListener var1);

    @Override
    public void removePropertyChangeListener(PropertyChangeListener var1);

    public void addSequenceContainerListener(SequenceContainerListener var1);

    public void removeSequenceContainerListener(SequenceContainerListener var1);

    public boolean append(Sequence var1);

    public boolean insert(Sequence var1, int var2);

    public boolean remove(Sequence var1);

    public void move(Sequence var1, int var2);

    public Sequence createSequence(String var1, Sequence var2);

    public Sequence createSequence(String var1, int var2, int var3, int var4);

    public Sequence getDefaultSequence();

    public Sequence getSequenceAt(int var1);

    public Sequence getSequenceByName(String var1);

    public int getSequenceCount();

    public List<Sequence> getSequences();

    public void setDefaultSequence(Sequence var1);

    @Override
    public String getName();

    public int indexOf(Sequence var1);

    public List<Action> getActionsForSequence(Sequence var1);

    public String getNextSequenceName(String var1);

    public GlobalRepository getGameDesign();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequenceContainerImpl
    implements SequenceContainer {
        public static final boolean DEBUG = false;
        EventListenerList listenerList;
        PropertyChangeSupport propertyChangeSupport;
        private List<Sequence> sequences;
        private Sequence defaultSequence;
        private SequenceContainer aggregator;
        private ImageResource imageResource;
        private SequenceContainerEditor editor;
        private int frameWidth;
        private int frameHeight;
        boolean zeroBasedIndex;

        public SequenceContainerImpl(SequenceContainer sequenceContainer, EventListenerList eventListenerList, PropertyChangeSupport propertyChangeSupport, ImageResource imageResource, int n, int n2, boolean bl) {
            this.aggregator = sequenceContainer;
            this.listenerList = eventListenerList == null ? new EventListenerList() : eventListenerList;
            this.propertyChangeSupport = propertyChangeSupport == null ? new PropertyChangeSupport(sequenceContainer) : propertyChangeSupport;
            this.sequences = new ArrayList<Sequence>();
            this.imageResource = imageResource;
            this.frameWidth = n;
            this.frameHeight = n2;
            this.zeroBasedIndex = bl;
        }

        @Override
        public GlobalRepository getGameDesign() {
            return this.imageResource.getGameDesign();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void addSequenceContainerListener(SequenceContainerListener sequenceContainerListener) {
            this.listenerList.add(SequenceContainerListener.class, sequenceContainerListener);
        }

        @Override
        public void removeSequenceContainerListener(SequenceContainerListener sequenceContainerListener) {
            this.listenerList.remove(SequenceContainerListener.class, sequenceContainerListener);
        }

        protected void fireSequenceAdded(Sequence sequence, int n) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != SequenceContainerListener.class) continue;
                ((SequenceContainerListener)objectArray[i + 1]).sequenceAdded(this.aggregator, sequence, n);
            }
        }

        protected void fireSequenceMoved(Sequence sequence, int n, int n2) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != SequenceContainerListener.class) continue;
                ((SequenceContainerListener)objectArray[i + 1]).sequenceMoved(this.aggregator, sequence, n, n2);
            }
        }

        protected void fireSequenceRemoved(Sequence sequence, int n) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != SequenceContainerListener.class) continue;
                ((SequenceContainerListener)objectArray[i + 1]).sequenceRemoved(this.aggregator, sequence, n);
            }
        }

        @Override
        public Sequence createSequence(String string, int n, int n2, int n3) {
            Sequence sequence = this.imageResource.createSequence(string, n, n2, n3, this.zeroBasedIndex);
            this.append(sequence);
            return sequence;
        }

        @Override
        public Sequence createSequence(String string, Sequence sequence) {
            Sequence sequence2 = this.imageResource.createSequence(string, sequence);
            this.append(sequence2);
            return sequence2;
        }

        @Override
        public String getNextSequenceName(String string) {
            String string2;
            int n = 0;
            for (Sequence object2 : this.getSequences()) {
                String string3 = object2.getName();
                if (!string3.startsWith(string)) continue;
                try {
                    int n2 = Integer.parseInt(string3.substring(string.length()));
                    if (n2 <= n) continue;
                    n = n2;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            DecimalFormat decimalFormat = new DecimalFormat("000");
            do {
                string2 = string + decimalFormat.format(++n);
            } while (!this.getGameDesign().isComponentNameAvailable(string2));
            return string2;
        }

        @Override
        public boolean append(Sequence sequence) {
            if (this.sequences.contains(sequence) && !this.remove(sequence)) {
                return false;
            }
            this.sequences.add(sequence);
            int n = this.sequences.indexOf(sequence);
            this.fireSequenceAdded(sequence, n);
            return true;
        }

        @Override
        public boolean insert(Sequence sequence, int n) {
            if (this.sequences.contains(sequence) && !this.remove(sequence)) {
                return false;
            }
            this.sequences.add(n, sequence);
            this.fireSequenceAdded(sequence, n);
            return true;
        }

        @Override
        public boolean remove(Sequence sequence) {
            if (this.getDefaultSequence() == sequence) {
                return false;
            }
            int n = this.sequences.indexOf(sequence);
            if (this.sequences.remove(sequence)) {
                this.fireSequenceRemoved(sequence, n);
            }
            return true;
        }

        @Override
        public void move(Sequence sequence, int n) {
            int n2 = this.sequences.indexOf(sequence);
            if (n2 == -1) {
                return;
            }
            this.sequences.remove(sequence);
            this.sequences.add(n, sequence);
            this.fireSequenceMoved(sequence, n2, n);
        }

        @Override
        public Sequence getSequenceByName(String string) {
            Sequence sequence = null;
            for (Sequence sequence2 : this.sequences) {
                if (!sequence2.getName().equals(string)) continue;
                sequence = sequence2;
                break;
            }
            return sequence;
        }

        @Override
        public void setDefaultSequence(Sequence sequence) {
            Sequence sequence2 = this.defaultSequence;
            if (!this.sequences.contains(sequence)) {
                this.append(sequence);
            }
            this.defaultSequence = sequence;
            this.propertyChangeSupport.firePropertyChange(SequenceContainer.PROPERTY_DEFAULT_SEQUENCE, sequence2, sequence);
        }

        @Override
        public Sequence getDefaultSequence() {
            return this.defaultSequence;
        }

        @Override
        public int indexOf(Sequence sequence) {
            return this.sequences.indexOf(sequence);
        }

        @Override
        public Sequence getSequenceAt(int n) {
            return this.sequences.get(n);
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException("Must be overriden by aggregating class.");
        }

        @Override
        public List<Sequence> getSequences() {
            return Collections.unmodifiableList(this.sequences);
        }

        @Override
        public int getSequenceCount() {
            return this.sequences.size();
        }

        @Override
        public JComponent getEditor() {
            return this.editor == null ? (this.editor = new SequenceContainerEditor(this)) : this.editor;
        }

        @Override
        public Editable.ImageResourceInfo getImageResourceInfo() {
            return new Editable.ImageResourceInfo(this.imageResource, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
        }

        @Override
        public JComponent getNavigator() {
            return null;
        }

        @Override
        public List<Action> getActions() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<Action> getActionsForSequence(Sequence sequence) {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            CreateSequenceAction createSequenceAction = new CreateSequenceAction();
            DuplicateSequenceAction duplicateSequenceAction = new DuplicateSequenceAction(sequence);
            DefaultSequenceAction defaultSequenceAction = new DefaultSequenceAction(sequence);
            RemoveSequenceAction removeSequenceAction = new RemoveSequenceAction(sequence);
            if (this.getDefaultSequence() == sequence) {
                removeSequenceAction.setEnabled(false);
                defaultSequenceAction.setEnabled(false);
            }
            arrayList.add(createSequenceAction);
            arrayList.add(duplicateSequenceAction);
            arrayList.add(defaultSequenceAction);
            arrayList.add(removeSequenceAction);
            arrayList.addAll(sequence.getActions());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Action action = (Action)iterator.next();
                if (!(action instanceof Sequence.EditSequenceAction)) continue;
                iterator.remove();
            }
            return Collections.unmodifiableList(arrayList);
        }

        public class RemoveSequenceAction
        extends AbstractAction {
            private Sequence sequence;

            public RemoveSequenceAction(Sequence sequence) {
                this.sequence = sequence;
                this.putValue("Name", NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.RemoveSequenceAction.text"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SequenceContainerImpl.this.remove(this.sequence);
            }
        }

        public class DefaultSequenceAction
        extends AbstractAction {
            private Sequence sequence;

            public DefaultSequenceAction(Sequence sequence) {
                this.sequence = sequence;
                this.putValue("Name", NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.DefaultSequenceAction.text"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SequenceContainerImpl.this.setDefaultSequence(this.sequence);
            }
        }

        public class DuplicateSequenceAction
        extends AbstractAction {
            private Sequence sequence;

            public DuplicateSequenceAction(Sequence sequence) {
                this.sequence = sequence;
                this.putValue("Name", NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.DuplicateSequenceAction.text"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NewSequenceDialog newSequenceDialog = new NewSequenceDialog(SequenceContainerImpl.this, this.sequence);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newSequenceDialog, NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.DuplicateSequenceAction.text"));
                dialogDescriptor.setButtonListener((ActionListener)newSequenceDialog);
                dialogDescriptor.setValid(false);
                newSequenceDialog.setDialogDescriptor(dialogDescriptor);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
            }
        }

        public class CreateSequenceAction
        extends AbstractAction {
            public CreateSequenceAction() {
                this.putValue("Name", NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.CreateSequenceAction.text"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NewSequenceDialog newSequenceDialog = new NewSequenceDialog(SequenceContainerImpl.this, SequenceContainerImpl.this.frameWidth, SequenceContainerImpl.this.frameHeight);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newSequenceDialog, NbBundle.getMessage(SequenceContainer.class, (String)"SequenceContainer.CreateSequenceAction.text"));
                dialogDescriptor.setButtonListener((ActionListener)newSequenceDialog);
                dialogDescriptor.setValid(false);
                newSequenceDialog.setDialogDescriptor(dialogDescriptor);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
            }
        }
    }
}

