/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.tiledlayer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.game.dialog.NewAnimatedTileDialog;
import org.netbeans.modules.vmd.game.editor.tiledlayer.AnimatedTileList;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerEditorComponent;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class TiledLayerEditor
extends JPanel
implements TiledLayerListener,
PropertyChangeListener {
    private TiledLayer tiledLayer;
    private TiledLayerEditorComponent editorComponent;
    private JScrollPane editorScroll;
    public JButton buttonAddAnimatedTile;
    public ButtonGroup buttonGroupMouseMode;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JPanel jPanel1;
    private JPanel jPanel2;
    public JSplitPane jSplitPane1;
    public JPanel panelAnimatedTiles;
    public JTextField textFieldCols;
    public JTextField textFieldName;
    public JTextField textFieldRows;
    public JToggleButton toggleButtonPaint;
    public JToggleButton toggleButtonSelect;

    public TiledLayerEditor(final TiledLayer tiledLayer) {
        this.tiledLayer = tiledLayer;
        this.tiledLayer.addTiledLayerListener(this);
        this.tiledLayer.addPropertyChangeListener(this);
        this.editorComponent = new TiledLayerEditorComponent(this.tiledLayer);
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.accessible.description"));
        this.toggleButtonPaint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TiledLayerEditor.this.toggleButtonPaint.isSelected()) {
                    TiledLayerEditor.this.editorComponent.setEditMode(0);
                }
            }
        });
        this.toggleButtonSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TiledLayerEditor.this.toggleButtonSelect.isSelected()) {
                    TiledLayerEditor.this.editorComponent.setEditMode(1);
                }
            }
        });
        this.toggleButtonPaint.setSelected(true);
        this.buttonAddAnimatedTile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewAnimatedTileDialog newAnimatedTileDialog = new NewAnimatedTileDialog(tiledLayer.getImageResource(), tiledLayer.getTileWidth(), tiledLayer.getTileHeight());
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newAnimatedTileDialog, NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.newAnimatedTileButton.txt"));
                dialogDescriptor.setButtonListener((ActionListener)newAnimatedTileDialog);
                dialogDescriptor.setValid(false);
                newAnimatedTileDialog.setDialogDescriptor(dialogDescriptor);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
            }
        });
        this.textFieldName.setBackground(this.textFieldName.getParent().getBackground());
        this.textFieldRows.setBackground(this.textFieldRows.getParent().getBackground());
        this.textFieldCols.setBackground(this.textFieldCols.getParent().getBackground());
        this.editorScroll = new JScrollPane();
        this.editorScroll.getViewport().setBackground(Color.WHITE);
        this.editorScroll.setViewportView(this.editorComponent);
        this.editorScroll.setColumnHeaderView(this.editorComponent.rulerHorizontal);
        this.editorScroll.setRowHeaderView(this.editorComponent.rulerVertical);
        this.editorScroll.setCorner("UPPER_LEFT_CORNER", this.editorComponent.getGridButton());
        this.jPanel2.add((Component)this.editorScroll, "Center");
        JScrollPane jScrollPane = new JScrollPane(new AnimatedTileList(this.editorComponent));
        jScrollPane.setBorder(null);
        this.panelAnimatedTiles.add((Component)jScrollPane, "Center");
    }

    private void initComponents() {
        this.buttonGroupMouseMode = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textFieldName = new JTextField();
        this.toggleButtonPaint = new JToggleButton();
        this.toggleButtonSelect = new JToggleButton();
        this.jLabel2 = new JLabel();
        this.textFieldRows = new JTextField();
        this.jLabel3 = new JLabel();
        this.textFieldCols = new JTextField();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.panelAnimatedTiles = new JPanel();
        this.buttonAddAnimatedTile = new JButton();
        this.setLayout(new BorderLayout());
        this.jLabel1.setText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.tiledLayerLabel.txt"));
        this.textFieldName.setEditable(false);
        this.textFieldName.setHorizontalAlignment(2);
        this.textFieldName.setText(this.tiledLayer.getName());
        this.textFieldName.setBorder(null);
        this.buttonGroupMouseMode.add(this.toggleButtonPaint);
        this.toggleButtonPaint.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/drawing_mode_16.png")));
        this.toggleButtonPaint.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.paintModeButton.tooltip"));
        this.toggleButtonPaint.setBorder(null);
        this.toggleButtonPaint.setBorderPainted(false);
        this.toggleButtonPaint.setRolloverEnabled(true);
        this.buttonGroupMouseMode.add(this.toggleButtonSelect);
        this.toggleButtonSelect.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/selection_mode_16.png")));
        this.toggleButtonSelect.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.selectModeButton.tooltip"));
        this.toggleButtonSelect.setBorder(null);
        this.toggleButtonSelect.setBorderPainted(false);
        this.toggleButtonSelect.setRolloverEnabled(true);
        this.jLabel2.setText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.tiledLayerRowsLabel.txt"));
        this.textFieldRows.setEditable(false);
        this.textFieldRows.setHorizontalAlignment(2);
        this.textFieldRows.setText(Integer.toString(this.tiledLayer.getRowCount()));
        this.textFieldRows.setBorder(null);
        this.jLabel3.setText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.tiledLayerColsLabel.txt"));
        this.textFieldCols.setEditable(false);
        this.textFieldCols.setHorizontalAlignment(2);
        this.textFieldCols.setText(Integer.toString(this.tiledLayer.getColumnCount()));
        this.textFieldCols.setBorder(null);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.toggleButtonPaint, -2, 26, -2).addPreferredGap(0).add((Component)this.toggleButtonSelect, -2, 23, -2).addPreferredGap(1).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.textFieldName, -1, 0, Short.MAX_VALUE).add(36, 36, 36).add((Component)this.jLabel2).add(6, 6, 6).add((Component)this.textFieldRows, -2, 41, -2).addPreferredGap(0).add((Component)this.jLabel3).add(6, 6, 6).add((Component)this.textFieldCols, -2, 41, -2).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.toggleButtonPaint, this.toggleButtonSelect}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.textFieldRows, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabel2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabel3)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.textFieldCols, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(5, 5, 5).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.textFieldName, -2, -1, -2).add(2, (Component)this.jLabel1))).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.toggleButtonSelect, -2, 25, -2).add((Component)this.toggleButtonPaint, -2, 25, -2)));
        this.add((Component)this.jPanel1, "North");
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(5);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setToolTipText("");
        this.jPanel2.setPreferredSize(new Dimension(10000, 10000));
        this.jPanel2.setLayout(new BorderLayout());
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.panelAnimatedTiles.setBorder(BorderFactory.createEtchedBorder());
        this.panelAnimatedTiles.setLayout(new BorderLayout());
        this.buttonAddAnimatedTile.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/new_animated_tile_16.png")));
        this.buttonAddAnimatedTile.setText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.newAnimatedTileButton.txt"));
        this.buttonAddAnimatedTile.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.newAnimTileButton.tooltip"));
        this.panelAnimatedTiles.add((Component)this.buttonAddAnimatedTile, "North");
        this.jSplitPane1.setRightComponent(this.panelAnimatedTiles);
        this.add((Component)this.jSplitPane1, "Center");
    }

    public void setPaintTile(Tile tile) {
        this.editorComponent.setPaintTileIndex(tile.getIndex());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.tiledLayer && propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
            this.textFieldName.setText(this.tiledLayer.getName());
        }
    }

    public void updateTextLabels() {
        this.textFieldRows.setText(Integer.toString(this.tiledLayer.getRowCount()));
        this.textFieldCols.setText(Integer.toString(this.tiledLayer.getColumnCount()));
    }

    public void tileChanged(TiledLayer tiledLayer, int n, int n2) {
    }

    public void tilesChanged(TiledLayer tiledLayer, Set set) {
    }

    public void tilesStructureChanged(TiledLayer tiledLayer) {
        this.updateTextLabels();
    }

    public void columnsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.updateTextLabels();
    }

    public void columnsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.updateTextLabels();
    }

    public void rowsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.updateTextLabels();
    }

    public void rowsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.updateTextLabels();
    }
}

