/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.bridge;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.bridge.ProjectBridge;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.AbstractRoot;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.UnusedFactory;
import org.netbeans.modules.cnd.discovery.wizard.tree.FileSystemFactory;
import org.netbeans.modules.cnd.loaders.HDataLoader;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryProjectGenerator {
    private static boolean DEBUG = Boolean.getBoolean("cnd.discovery.trace.project_update");
    private ProjectBridge projectBridge;
    private DiscoveryDescriptor wizard;
    private String baseFolder;
    private String level;

    public DiscoveryProjectGenerator(DiscoveryDescriptor discoveryDescriptor) throws IOException {
        this.wizard = discoveryDescriptor;
        this.baseFolder = discoveryDescriptor.getRootFolder();
        Project project = discoveryDescriptor.getProject();
        this.projectBridge = project != null ? new ProjectBridge(project) : new ProjectBridge(this.baseFolder);
    }

    public Set makeProject() {
        List<ProjectConfiguration> list = this.wizard.getConfigurations();
        Folder folder = this.projectBridge.getRoot();
        this.level = this.wizard.getLevel();
        HashSet<Item> hashSet = new HashSet<Item>();
        for (ProjectConfiguration projectConfiguration : list) {
            this.setupCompilerConfiguration(projectConfiguration);
            this.addConfiguration(folder, projectConfiguration, hashSet);
        }
        this.addAdditional(folder, this.baseFolder, hashSet);
        return this.projectBridge.getResult();
    }

    private Set<String> getSourceFolders() {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = new HashSet();
        List<ProjectConfiguration> list = this.wizard.getConfigurations();
        for (ProjectConfiguration projectConfiguration : list) {
            for (FileConfiguration fileConfiguration : projectConfiguration.getFiles()) {
                int n;
                String string = fileConfiguration.getFilePath();
                if (Utilities.isWindows()) {
                    string = string.replace('\\', '/');
                }
                if ((n = string.lastIndexOf(47)) > 0) {
                    string = string.substring(0, n + 1);
                }
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private Map<String, Folder> prefferedFolders() {
        HashMap<String, Folder> hashMap = new HashMap<String, Folder>();
        for (Item item : this.projectBridge.getAllSources()) {
            int n;
            String string = item.getAbsPath();
            if (Utilities.isWindows()) {
                string = string.replace('\\', '/');
            }
            if (string.indexOf("/../") >= 0 || string.indexOf("/./") >= 0) {
                string = FileUtil.normalizeFile((File)new File(string)).getAbsolutePath();
            }
            if ((n = string.lastIndexOf(47)) < 0) continue;
            String string2 = string.substring(0, n);
            hashMap.put(string2, item.getFolder());
        }
        return hashMap;
    }

    private void addAdditional(Folder folder, String string, Set<Item> set) {
        Object object;
        Folder folder2;
        Object object2;
        Set<String> set2 = this.getSourceFolders();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        List<String> list = this.wizard.getIncludedFiles();
        Map<String, Folder> map = this.prefferedFolders();
        for (String hashSet4 : list) {
            hashSet2.add(hashSet4);
            object2 = this.projectBridge.getRelativepath(hashSet4);
            Item item = this.projectBridge.getProjectItem((String)object2);
            if (item == null) {
                String string2;
                int n;
                object2 = hashSet4;
                if (Utilities.isWindows()) {
                    object2 = ((String)object2).replace('\\', '/');
                }
                boolean bl = false;
                if (((String)object2).startsWith(string)) {
                    bl = true;
                } else {
                    for (String string3 : set2) {
                        if (!((String)object2).startsWith(string3)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl && (n = ((String)object2).lastIndexOf(47)) >= 0 && (folder2 = map.get(string2 = ((String)object2).substring(0, n))) != null) {
                    Item item3 = this.projectBridge.createItem(hashSet4);
                    item3 = folder2.addItem(item3);
                    bl = false;
                }
                if (!bl) continue;
                hashSet3.add(hashSet4);
                continue;
            }
            if (set.contains(item)) continue;
            this.projectBridge.setExclude(item, false);
            this.projectBridge.setHeaderTool(item);
        }
        if (hashSet3.size() > 0) {
            this.addNewExtension(hashSet3);
            object = UnusedFactory.createRoot(hashSet3);
            this.addAdditionalFolder(folder, (AbstractRoot)object);
        }
        object = this.wizard.getConfigurations();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object2 = (ProjectConfiguration)iterator.next();
            for (FileConfiguration fileConfiguration : object2.getFiles()) {
                hashSet2.add(fileConfiguration.getFilePath());
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string4 : hashSet2) {
            hashSet.add(this.projectBridge.getRelativepath(string4));
        }
        object2 = new TreeMap();
        for (Item item : this.projectBridge.getAllSources()) {
            if (set.contains(item)) continue;
            ((TreeMap)object2).put(item.getPath(), item);
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : ((TreeMap)object2).entrySet()) {
            String string5 = (String)entry.getKey();
            folder2 = (Item)entry.getValue();
            String string6 = folder2.getCanonicalFile().getAbsolutePath();
            if (hashSet.contains(string5) || hashSet2.contains(string5) || hashSet.contains(string6) || hashSet2.contains(string6)) continue;
            Folder folder3 = folder2.getFolder();
            if (DEBUG) {
                System.out.println("Exclude Item " + string5);
            }
            this.projectBridge.setExclude((Item)folder2, true);
        }
    }

    private void addNewExtension(Set<String> set) {
        Set<String> set2 = FileSystemFactory.getHeaderSuffixes();
        Set<String> set3 = FileSystemFactory.getSourceSuffixes();
        Set<String> set4 = FileSystemFactory.createExtensionSet();
        for (String string : set) {
            String string2;
            int n = (string = string.replace('\\', '/')).lastIndexOf(47);
            if (n >= 0) {
                string = string.substring(n);
            }
            if ((n = string.lastIndexOf(46)) <= 0 || (string2 = string.substring(n + 1)).length() <= 0 || set2.contains(string2) || set3.contains(string2)) continue;
            set4.add(string2);
        }
        if (set4.size() > 0 && this.addNewExtensionDialog(set4)) {
            HDataLoader.getInstance().addExtensions(set4);
        }
    }

    private boolean addNewExtensionDialog(Set<String> set) {
        String string = this.getString("ADD_EXTENSION_QUESTION" + (set.size() == 1 ? "" : "S"));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string2);
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(string, stringBuilder.toString()), this.getString("ADD_EXTENSION_DIALOG_TITLE" + (set.size() == 1 ? "" : "S")), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION;
    }

    private String getString(String string) {
        return NbBundle.getBundle(DiscoveryProjectGenerator.class).getString(string);
    }

    private void addAdditionalFolder(Folder folder, AbstractRoot abstractRoot) {
        String string = abstractRoot.getName();
        Folder folder2 = folder.findFolderByName(string);
        if (folder2 == null) {
            folder2 = this.projectBridge.createFolder(folder, string);
            folder.addFolder(folder2);
        }
        for (AbstractRoot object : abstractRoot.getChildren()) {
            this.addAdditionalFolder(folder2, object);
        }
        List<String> list = abstractRoot.getFiles();
        if (list != null) {
            for (String string2 : list) {
                String string3 = this.projectBridge.getRelativepath(string2);
                Item item = this.projectBridge.getProjectItem(string3);
                if (item != null) {
                    if (item.getFolder() != folder2) {
                        Object object = this.projectBridge.getAuxObject(item);
                        item.getFolder().removeItem(item);
                        item = folder2.addItem(item);
                        if (object != null) {
                            this.projectBridge.setAuxObject(item, object);
                        }
                    }
                    this.projectBridge.setExclude(item, false);
                    this.projectBridge.setHeaderTool(item);
                    continue;
                }
                item = this.projectBridge.createItem(string2);
                item = folder2.addItem(item);
                this.projectBridge.setExclude(item, false);
                this.projectBridge.setHeaderTool(item);
            }
        }
    }

    private void setupCompilerConfiguration(ProjectConfiguration projectConfiguration) {
        if ("project".equals(this.level)) {
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (FileConfiguration object2 : projectConfiguration.getFiles()) {
                this.reConsolidatePaths(hashSet, object2);
                hashMap.putAll(object2.getUserMacros());
            }
            ArrayList arrayList = new ArrayList(hashSet);
            List<String> list = this.buildMacrosString(hashMap);
            this.projectBridge.setupProject(arrayList, list, projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP);
        } else {
            List list = Collections.emptyList();
            List list2 = Collections.emptyList();
            this.projectBridge.setupProject(list, list2, projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP);
        }
    }

    private List<String> buildMacrosString(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() != null) {
                arrayList.add(entry.getKey() + "=" + entry.getValue());
                continue;
            }
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    private void setupFile(FileConfiguration fileConfiguration, Item item, boolean bl) {
        this.projectBridge.setSourceTool(item, bl);
        if ("file".equals(this.level)) {
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.reConsolidatePaths(hashSet, fileConfiguration);
            hashMap.putAll(fileConfiguration.getUserMacros());
            ArrayList<String> arrayList = new ArrayList<String>(hashSet);
            List<String> list = this.buildMacrosString(hashMap);
            this.projectBridge.setupFile(fileConfiguration.getCompilePath(), arrayList, !fileConfiguration.overrideIncludes(), list, !fileConfiguration.overrideMacros(), item);
        } else {
            List list = Collections.emptyList();
            List list2 = Collections.emptyList();
            this.projectBridge.setupFile(fileConfiguration.getCompilePath(), list, true, list2, true, item);
        }
    }

    private void reConsolidatePaths(Set<String> set, FileConfiguration fileConfiguration) {
        String string = fileConfiguration.getCompilePath();
        for (String string2 : fileConfiguration.getUserInludePaths()) {
            if (!(string2.startsWith("/") || string2.length() > 1 && string2.charAt(1) == ':')) {
                string2 = string2.equals(".") ? string : string + File.separator + string2;
                File file = new File(string2);
                string2 = FileUtil.normalizeFile((File)file).getAbsolutePath();
            }
            set.add(this.projectBridge.getRelativepath(string2));
        }
        if (this.isDifferentCompilePath(fileConfiguration.getFilePath(), string)) {
            set.add(this.projectBridge.getRelativepath(string));
        }
    }

    private boolean isDifferentCompilePath(String string, String string2) {
        int n;
        if (Utilities.isWindows()) {
            string = string.replace('\\', '/');
        }
        return (n = string.lastIndexOf(47)) > 0 && !(string = string.substring(0, n)).equals(string2);
    }

    /*
     * WARNING - void declaration
     */
    private void addConfiguration(Folder folder, ProjectConfiguration projectConfiguration, Set<Item> set) {
        Object object5;
        Collection<Object> collection;
        Object object22;
        Object object4;
        boolean bl = projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP;
        Map<String, Set<Pair>> map = this.analyzeConfigurationStructure(projectConfiguration.getFiles(), bl);
        List<Pair> list = this.detectOrphan(map, bl);
        if (list.size() > 0) {
            this.createOrphan(folder, list, bl);
        }
        if ("folder".equals(this.level)) {
            Object object3;
            object4 = new HashMap();
            for (Map.Entry<String, Set<Pair>> entry : map.entrySet()) {
                object22 = entry.getKey();
                collection = entry.getValue();
                for (Object object5 : collection) {
                    if (((Pair)object5).item != null) {
                        void var15_29;
                        object3 = ((Pair)object5).item.getFolder();
                        Set set2 = (Set)object4.get(object3);
                        if (set2 == null) {
                            HashSet hashSet = new HashSet();
                            object4.put(object3, hashSet);
                        }
                        var15_29.add(((Pair)object5).fileConfiguration);
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.err.println("Cannot find pair by path " + ((Pair)object5).fileConfiguration.getFilePath());
                }
            }
            for (Map.Entry entry : object4.entrySet()) {
                object22 = (Folder)entry.getKey();
                collection = (Set)entry.getValue();
                Object object6 = new HashSet<String>();
                object5 = new HashMap();
                for (FileConfiguration fileConfiguration : collection) {
                    this.reConsolidatePaths((Set<String>)object6, fileConfiguration);
                    object5.putAll(fileConfiguration.getUserMacros());
                }
                object3 = this.buildMacrosString((Map<String, String>)object5);
                ArrayList<String> arrayList = new ArrayList<String>((Collection<String>)object6);
                this.projectBridge.setupFolder(arrayList, false, (List)object3, false, projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP, (Folder)object22);
            }
        } else {
            object4 = new HashSet();
            for (Map.Entry<String, Set<Pair>> entry : map.entrySet()) {
                object22 = entry.getValue();
                for (Object object6 : object22) {
                    if (((Pair)object6).item == null) continue;
                    object5 = ((Pair)object6).item.getFolder();
                    object4.add(object5);
                }
            }
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                Folder folder2 = (Folder)iterator.next();
                object22 = Collections.emptyList();
                collection = Collections.emptyList();
                this.projectBridge.setupFolder((List)collection, true, (List)object22, true, projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP, folder2);
            }
        }
        for (Set set3 : map.values()) {
            for (Object object22 : set3) {
                if (((Pair)object22).item == null) continue;
                set.add(((Pair)object22).item);
            }
        }
    }

    private void createOrphan(Folder folder, List<Pair> list, boolean bl) {
        HashMap<String, Pair> hashMap = new HashMap<String, Pair>();
        for (Pair pair : list) {
            String string = pair.fileConfiguration.getFilePath();
            hashMap.put(string, pair);
        }
        AbstractRoot abstractRoot = UnusedFactory.createRoot(hashMap.keySet());
        this.addFolder(folder, abstractRoot, hashMap, bl);
    }

    private void addFolder(Folder folder, AbstractRoot abstractRoot, Map<String, Pair> map, boolean bl) {
        String string = abstractRoot.getName();
        Folder folder2 = folder.findFolderByName(string);
        if (folder2 == null) {
            folder2 = this.projectBridge.createFolder(folder, string);
            folder.addFolder(folder2);
        }
        for (AbstractRoot object : abstractRoot.getChildren()) {
            this.addFolder(folder2, object, map, bl);
        }
        for (String string2 : abstractRoot.getFiles()) {
            Pair pair = map.get(string2);
            if (pair != null) {
                String string3 = this.projectBridge.getRelativepath(string2);
                Item item = this.projectBridge.getProjectItem(string3);
                if (item == null) {
                    item = this.projectBridge.createItem(string2);
                    folder2.addItem(item);
                } else if (DEBUG) {
                    System.err.println("Orphan pair found by path " + string2);
                }
                pair.item = item;
                this.setupFile(pair.fileConfiguration, pair.item, bl);
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("Cannot find pair by path " + string2);
        }
    }

    private List<Pair> detectOrphan(Map<String, Set<Pair>> map, boolean bl) {
        Map<String, Folder> map2 = this.prefferedFolders();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (Map.Entry<String, Set<Pair>> entry : map.entrySet()) {
            String string;
            Object object;
            String string2 = entry.getKey();
            Set<Pair> set = entry.getValue();
            Folder folder = null;
            ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
            for (Pair pair : set) {
                int n;
                object = pair.item;
                if (object != null) {
                    if (folder == null) continue;
                    folder = object.getFolder();
                    continue;
                }
                string = pair.fileConfiguration.getFilePath();
                if (Utilities.isWindows()) {
                    string = string.replace('\\', '/');
                }
                if ((n = string.lastIndexOf(47)) >= 0) {
                    string = string.substring(0, n);
                    folder = map2.get(string);
                }
                if (folder != null) continue;
                arrayList2.add(pair);
            }
            if (folder != null) {
                for (Pair pair : arrayList2) {
                    object = this.projectBridge.getRelativepath(pair.fileConfiguration.getFilePath());
                    string = this.projectBridge.getProjectItem(string2);
                    if (string == null) {
                        string = this.projectBridge.createItem(pair.fileConfiguration.getFilePath());
                        folder.addItem((Item)string);
                        pair.item = (Item)string;
                    }
                    this.setupFile(pair.fileConfiguration, (Item)string, bl);
                }
                continue;
            }
            for (Pair pair : arrayList2) {
                arrayList.add(pair);
            }
        }
        return arrayList;
    }

    private Map<String, Set<Pair>> analyzeConfigurationStructure(List<FileConfiguration> list, boolean bl) {
        HashMap<String, Set<Pair>> hashMap = new HashMap<String, Set<Pair>>();
        for (FileConfiguration fileConfiguration : list) {
            String string;
            Item item;
            int n;
            String string2 = fileConfiguration.getFilePath();
            if (Utilities.isWindows()) {
                string2 = string2.replace('\\', '/');
            }
            if ((n = string2.lastIndexOf(47)) < 0) continue;
            String string3 = string2.substring(0, n);
            HashSet<Pair> hashSet = (HashSet<Pair>)hashMap.get(string3);
            if (hashSet == null) {
                hashSet = new HashSet<Pair>();
                hashMap.put(string3, hashSet);
            }
            if ((item = this.projectBridge.getProjectItem(string = this.projectBridge.getRelativepath(string2))) != null) {
                this.setupFile(fileConfiguration, item, bl);
            }
            hashSet.add(new Pair(fileConfiguration, item));
        }
        return hashMap;
    }

    private static class Pair {
        private FileConfiguration fileConfiguration;
        private Item item;

        private Pair(FileConfiguration fileConfiguration, Item item) {
            this.fileConfiguration = fileConfiguration;
            this.item = item;
        }
    }
}

