/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.query.readers;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.refactoring.spi.AnalysisUtilities;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.refactoring.SchemaUIHelper;
import org.netbeans.modules.xml.xam.Component;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Schema;

public class QuerySubstitutionGroupsReader {
    private SchemaModel model;
    private Map<GlobalElement, List<GlobalElement>> sGroups;
    public static final Schema FIND_USAGES_NODES_SCHEMA = new Schema();
    public static final Schema FIND_USAGES_EDGES_SCHEMA;

    public QuerySubstitutionGroupsReader(SchemaModel schemaModel) {
        this.model = schemaModel;
    }

    public Graph loadGraph() {
        List<GlobalElement> list;
        GlobalElement globalElement;
        Object object;
        Object object22;
        Graph graph = new Graph(true);
        graph.getNodeTable().addColumns(FIND_USAGES_NODES_SCHEMA);
        graph.getEdgeTable().addColumns(FIND_USAGES_EDGES_SCHEMA);
        this.sGroups = new HashMap<GlobalElement, List<GlobalElement>>();
        Collection collection = this.model.getSchema().getElements();
        for (Object object22 : collection) {
            object = object22.getSubstitutionGroup();
            if (object == null) continue;
            globalElement = (GlobalElement)object.get();
            if (globalElement != null) {
                list = this.sGroups.get(globalElement);
                if (list == null) {
                    list = new ArrayList<GlobalElement>();
                    this.sGroups.put(globalElement, list);
                }
                list.add((GlobalElement)object22);
                continue;
            }
            ErrorManager.getDefault().log(65536, "QuerySubstitutionGroupsReader.loadGraph ignoring GE w/ invalid substGrp ref " + object22.getName());
        }
        int n = this.sGroups.size();
        if (n == 1) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(QuerySubstitutionGroupsReader.class, (String)"LBL_SubstitutionGroup_Found"));
        } else {
            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(NbBundle.getMessage(QuerySubstitutionGroupsReader.class, (String)"LBL_SubstitutionGroups_Found"), n));
        }
        object22 = this.sGroups.keySet();
        object = object22.iterator();
        while (object.hasNext()) {
            globalElement = (GlobalElement)object.next();
            list = this.sGroups.get(globalElement);
            assert (list != null) : "Error is finding substitution group for " + globalElement;
            prefuse.data.Node node = this.createHeadElementNode(graph, globalElement);
            for (GlobalElement globalElement2 : list) {
                prefuse.data.Node node2 = this.createNode(graph, globalElement2);
                AnalysisUtilities.ToolTipLine toolTipLine = null;
                toolTipLine = new AnalysisUtilities.ToolTipLine(MessageFormat.format(NbBundle.getMessage(QuerySubstitutionGroupsReader.class, (String)"LBL_Substitutable_Element"), node.getString("label")), 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
                String string = node2.getString("component-type-name");
                AnalysisUtilities.ToolTipLine toolTipLine2 = new AnalysisUtilities.ToolTipLine(string, 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
                String string2 = AnalysisUtilities.createHTMLToolTip((AnalysisUtilities.ToolTipLine[])new AnalysisUtilities.ToolTipLine[]{toolTipLine, toolTipLine2});
                node2.setString("tooltip", string2);
                Edge edge = this.createEdge(graph, node2, node);
            }
        }
        return graph;
    }

    private prefuse.data.Node createHeadElementNode(Graph graph, GlobalElement globalElement) {
        prefuse.data.Node node = this.createNode(graph, globalElement);
        node.setBoolean("is-head-element", true);
        AnalysisUtilities.ToolTipLine toolTipLine = new AnalysisUtilities.ToolTipLine(NbBundle.getMessage(QuerySubstitutionGroupsReader.class, (String)"LBL_Head_Element"), 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
        AnalysisUtilities.ToolTipLine toolTipLine2 = new AnalysisUtilities.ToolTipLine(NbBundle.getMessage(QuerySubstitutionGroupsReader.class, (String)"LBL_Global_Element"), 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
        String string = AnalysisUtilities.createHTMLToolTip((AnalysisUtilities.ToolTipLine[])new AnalysisUtilities.ToolTipLine[]{toolTipLine, toolTipLine2});
        node.setString("tooltip", string);
        return node;
    }

    private Edge createEdge(Graph graph, prefuse.data.Node node, prefuse.data.Node node2) {
        Edge edge = graph.addEdge(node, node2);
        edge.setString("edge-type", "generalization");
        return edge;
    }

    private prefuse.data.Node createNode(Graph graph, GlobalElement globalElement) {
        prefuse.data.Node node = graph.addNode();
        System.out.println("QuerySubstitutionGroupsReader:: createNode");
        SchemaUIHelper schemaUIHelper = new SchemaUIHelper();
        Node node2 = schemaUIHelper.getDisplayNode((Component)globalElement);
        node.set("openide-node", (Object)node2);
        node.set("xam-component", (Object)globalElement);
        node.setString("component-type-name", node2.getShortDescription());
        node.setString("label", node2.getName());
        node.setString("element-type", node2.getDisplayName());
        return node;
    }

    static {
        FIND_USAGES_NODES_SCHEMA.addColumn("label", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("id", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("component-type-name", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("element-type", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("xml-filename", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("tooltip", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("xam-component", Component.class);
        FIND_USAGES_NODES_SCHEMA.addColumn("is-primitive", Boolean.TYPE, (Object)false);
        FIND_USAGES_NODES_SCHEMA.addColumn("is-query-node", Boolean.TYPE, (Object)false);
        FIND_USAGES_NODES_SCHEMA.addColumn("is-usage-node", Boolean.TYPE, (Object)false);
        FIND_USAGES_NODES_SCHEMA.addColumn("is-head-element", Boolean.TYPE, (Object)false);
        FIND_USAGES_NODES_SCHEMA.addColumn("openide-node", Node.class);
        FIND_USAGES_EDGES_SCHEMA = new Schema();
        FIND_USAGES_EDGES_SCHEMA.addColumn("label", String.class, (Object)"");
        FIND_USAGES_EDGES_SCHEMA.addColumn("edge-type", String.class, (Object)"");
        FIND_USAGES_EDGES_SCHEMA.addColumn("tooltip", String.class, (Object)"");
    }
}

