/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.layout.jlayout;

import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.service.TSConstraint;
import com.tomsawyer.service.layout.TSSingleNodeListLayoutConstraint;
import com.tomsawyer.service.layout.jlayout.TSHasDistanceConstraint;
import com.tomsawyer.service.layout.jlayout.TSHasOrientationConstraint;
import com.tomsawyer.util.TSParser;
import java.io.IOException;

public class TSWithinRangeConstraint
extends TSSingleNodeListLayoutConstraint
implements TSHasOrientationConstraint,
TSHasDistanceConstraint {
    private int orientation;
    private double distance = 0.0;

    public TSWithinRangeConstraint() {
        this(-1, 0, 0);
    }

    public TSWithinRangeConstraint(int n, int n2, int n3) {
        super(n, n2);
        this.orientation = n3;
    }

    public boolean checkValidity() {
        return this.getNodeList().size() >= 2 && super.checkValidity();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new RuntimeException("Invalid parameter.");
        }
        int n2 = this.orientation;
        this.orientation = n;
        if (n2 != n) {
            this.fireConstraintChangedEvent();
        }
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double d) {
        double d2 = this.distance;
        this.distance = d;
        if (d2 != d) {
            this.fireConstraintChangedEvent();
        }
    }

    public TSConstraint cloneWithAttributes() {
        TSWithinRangeConstraint tSWithinRangeConstraint = new TSWithinRangeConstraint(this.getStyle(), this.getPriority(), this.getOrientation());
        tSWithinRangeConstraint.setDistance(this.getDistance());
        return tSWithinRangeConstraint;
    }

    protected void copy(TSConstraint tSConstraint) {
        super.copy(tSConstraint);
        if (tSConstraint instanceof TSWithinRangeConstraint) {
            this.orientation = ((TSWithinRangeConstraint)tSConstraint).getOrientation();
            this.distance = ((TSWithinRangeConstraint)tSConstraint).getDistance();
        }
    }

    public void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        super.read(tSGraphObjectTable, tSParser);
        tSParser.parseInputString("orientation");
        this.setOrientation(tSParser.getInt());
        tSParser.parseInputString("distance");
        this.setDistance(tSParser.getDouble());
    }
}

