/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.layout;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.service.TSConstraint;
import com.tomsawyer.service.dk;
import com.tomsawyer.service.layout.TSHasEdgesConstraint;
import com.tomsawyer.service.layout.TSLayoutConstraint;
import com.tomsawyer.util.TSParser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class TSSingleEdgeListLayoutConstraint
extends TSLayoutConstraint
implements TSHasEdgesConstraint {
    private dk edges = new dk();

    public TSSingleEdgeListLayoutConstraint() {
        this(-1, 0);
    }

    public TSSingleEdgeListLayoutConstraint(int n, int n2) {
        super(n, n2);
    }

    public List getEdgeList() {
        return Collections.unmodifiableList(this.edges);
    }

    public boolean checkValidity() {
        boolean bl;
        boolean bl2 = bl = this.edges.size() != 0;
        if (bl && this.edges.contains(null)) {
            bl = false;
        }
        HashSet hashSet = this.edges.iterator();
        while (hashSet.hasNext() && bl) {
            TSDEdge tSDEdge = (TSDEdge)hashSet.next();
            if (tSDEdge.isOwned()) continue;
            bl = false;
        }
        if (bl) {
            hashSet = new HashSet(this.edges);
            bl = hashSet.size() == this.edges.size();
        }
        return bl;
    }

    public void addEdge(TSDEdge tSDEdge) {
        if (this.edges.add(tSDEdge)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void addEdge(int n, TSDEdge tSDEdge) {
        this.edges.add(n, tSDEdge);
        this.fireConstraintChangedEvent();
    }

    public void removeEdge(TSEdge tSEdge) {
        this.onEdgeDiscarded(tSEdge);
    }

    public void onEdgeRemoved(TSEdge tSEdge) {
        if (this.edges.remove(tSEdge)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void onEdgeInserted(TSEdge tSEdge) {
        if (this.edges.c(tSEdge)) {
            this.edges.a(tSEdge);
            this.fireConstraintChangedEvent();
        }
    }

    public void onEdgeDiscarded(TSEdge tSEdge) {
        if (this.edges.b(tSEdge)) {
            this.fireConstraintChangedEvent();
        }
    }

    protected void copy(TSConstraint tSConstraint) {
        super.copy(tSConstraint);
        this.edges = new dk();
        if (tSConstraint instanceof TSSingleEdgeListLayoutConstraint) {
            Iterator iterator = ((TSSingleEdgeListLayoutConstraint)tSConstraint).getEdgeList().iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getUtilityObject() instanceof TSDEdge) {
                    this.edges.add(tSDEdge.getUtilityObject());
                    continue;
                }
                this.edges.add(tSDEdge);
            }
        }
    }

    public void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        super.read(tSGraphObjectTable, tSParser);
        tSParser.parseInputString("edgeList");
        tSParser.parseOpenBracket();
        while (tSParser.getString().equals("edge")) {
            int n = tSParser.getInt();
            this.edges.add(tSGraphObjectTable.get((long)n));
        }
        tSParser.pushBack();
        tSParser.parseCloseBracket();
        this.setValid(this.checkValidity());
    }
}

