/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.properties;

import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.dialog.TSUnsignedDoubleField;
import com.tomsawyer.editor.dialog.TSUnsignedIntegerField;
import com.tomsawyer.editor.service.layout.properties.TSEBaseLayoutPropertiesDialog;
import com.tomsawyer.editor.service.layout.properties.hy;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.dp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public abstract class TSETabComponent
extends JPanel
implements KeyListener,
ActionListener {
    protected TSEGraph graph;
    protected TSServiceInputData inputData;
    protected JDialog dialog;
    protected Color normalTextColor;
    protected Color disableTextColor;
    protected Color labelColor = Color.black;
    boolean changed;
    protected Font font;
    protected TSEResourceBundleWrapper labels;
    protected dp layoutHelper;

    public TSETabComponent(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        this.graph = tSEGraph;
        this.inputData = tSServiceInputData;
        this.dialog = jDialog;
        this.init();
        this.setValues(this.getServiceInputData());
        this.setTabOrder();
    }

    protected void init() {
        this.normalTextColor = Color.white;
        this.disableTextColor = new Color(204, 204, 204);
        this.font = new Font("Dialog", 0, 12);
        this.changed = false;
        this.labels = TSEResourceBundleWrapper.getSystemLabelBundle();
    }

    public void setValues(TSServiceInputData tSServiceInputData) {
    }

    protected void setTabOrder() {
    }

    protected JButton getOKButton() {
        return ((TSEBaseLayoutPropertiesDialog)this.dialog).okButton;
    }

    protected void enable(JComponent jComponent) {
        jComponent.setEnabled(true);
        if (jComponent instanceof JTextField) {
            jComponent.setBackground(this.normalTextColor);
        }
    }

    protected void disable(JComponent jComponent) {
        jComponent.setEnabled(false);
        if (jComponent instanceof JTextField) {
            jComponent.setBackground(this.disableTextColor);
        }
    }

    protected void activateButtons() {
        this.setChanged(true);
        ((TSEBaseLayoutPropertiesDialog)this.dialog).activateButtons();
    }

    public JLabel createLabel(String string) {
        string = this.translateText(string);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.font);
        jLabel.setForeground(this.labelColor);
        return jLabel;
    }

    protected JPanel createBoxLayoutPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        int n = 0;
        if (!bl) {
            n = 1;
        }
        jPanel.setLayout(new BoxLayout(jPanel, n));
        jPanel.setBorder(null);
        return jPanel;
    }

    public void createBorder(JPanel jPanel, String string) {
        string = this.translateText(string);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitleColor(this.labelColor);
        titledBorder.setTitleFont(this.font);
        jPanel.setBorder(titledBorder);
    }

    public void createEmptyBorder(JPanel jPanel, int n, int n2, int n3, int n4) {
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
    }

    public void createCompoundBorder(JPanel jPanel, String string, int n, int n2, int n3, int n4) {
        string = this.translateText(string);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitleColor(this.labelColor);
        titledBorder.setTitleFont(this.font);
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(n, n2, n3, n4)));
    }

    public JCheckBox createCheckbox(String string) {
        return this.createCheckbox(string, string);
    }

    protected Component createRigidArea(int n, int n2) {
        return Box.createRigidArea(new Dimension(n, n2));
    }

    protected Component createVerticalRigidArea(int n) {
        return this.createRigidArea(0, n);
    }

    protected Component createHorizontalRigidArea(int n) {
        return this.createRigidArea(n, 0);
    }

    public JCheckBox createCheckbox(String string, String string2) {
        string = this.translateText(string);
        string = " " + string;
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setFont(this.font);
        jCheckBox.setActionCommand(string2);
        jCheckBox.addActionListener(this);
        jCheckBox.setBorder(null);
        return jCheckBox;
    }

    public JRadioButton createRadioButton(String string) {
        return this.createRadioButton(string, string);
    }

    public JRadioButton createRadioButton(String string, String string2) {
        string = this.translateText(string);
        string = " " + string;
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setFont(this.font);
        jRadioButton.setActionCommand(string2);
        jRadioButton.addActionListener(this);
        jRadioButton.setBorder(null);
        return jRadioButton;
    }

    public TSUnsignedIntegerField createIntegerField(int n, int n2) {
        TSUnsignedIntegerField tSUnsignedIntegerField = new TSUnsignedIntegerField(n, n2);
        tSUnsignedIntegerField.setMaximumSize(tSUnsignedIntegerField.getPreferredSize());
        tSUnsignedIntegerField.addKeyListener(this);
        return tSUnsignedIntegerField;
    }

    public TSUnsignedIntegerField createIntegerField(int n, int n2, int n3) {
        TSUnsignedIntegerField tSUnsignedIntegerField = new TSUnsignedIntegerField(n, n2, n3);
        tSUnsignedIntegerField.setMaximumSize(tSUnsignedIntegerField.getPreferredSize());
        tSUnsignedIntegerField.addKeyListener(this);
        return tSUnsignedIntegerField;
    }

    public TSUnsignedDoubleField createDoubleField(int n, double d, double d2) {
        TSUnsignedDoubleField tSUnsignedDoubleField = new TSUnsignedDoubleField(n, d, d2);
        tSUnsignedDoubleField.setMaximumSize(tSUnsignedDoubleField.getPreferredSize());
        tSUnsignedDoubleField.addKeyListener(this);
        return tSUnsignedDoubleField;
    }

    public void onApply() {
        this.setChanged(false);
    }

    protected void processIntegerField(String string, TSUnsignedIntegerField tSUnsignedIntegerField) {
        this.processIntegerField(this.getGraph(), string, tSUnsignedIntegerField);
    }

    protected void processIntegerField(Object object, String string, TSUnsignedIntegerField tSUnsignedIntegerField) {
        tSUnsignedIntegerField.ensureValidValue();
        String string2 = tSUnsignedIntegerField.getText();
        int n = this.layoutHelper != null ? this.layoutHelper.c(this.inputData, object, string) : this.getServiceInputData().getValueAsInteger(object, string);
        if (string2 == null || string2.equals("")) {
            tSUnsignedIntegerField.setText(String.valueOf(n));
        } else {
            int n2 = Integer.parseInt(tSUnsignedIntegerField.getText());
            if (n2 != n) {
                this.getServiceInputData().setOption(object, string, n2);
            }
        }
    }

    protected void processDoubleField(String string, TSUnsignedDoubleField tSUnsignedDoubleField) {
        this.processDoubleField(this.getGraph(), string, tSUnsignedDoubleField);
    }

    protected void processDoubleField(Object object, String string, TSUnsignedDoubleField tSUnsignedDoubleField) {
        tSUnsignedDoubleField.ensureValidValue();
        String string2 = tSUnsignedDoubleField.getText();
        double d = this.layoutHelper != null ? this.layoutHelper.b(this.inputData, object, string) : this.getServiceInputData().getValueAsDouble(object, string);
        if (string2 == null || string2.equals("")) {
            tSUnsignedDoubleField.setText(String.valueOf(d));
        } else {
            double d2 = Double.valueOf(tSUnsignedDoubleField.getText());
            if (d2 != d) {
                this.getServiceInputData().setOption(object, string, d2);
            }
        }
    }

    protected void processChoices(String string, int n) {
        this.processChoices((Object)this.getGraph(), string, n);
    }

    protected void processChoices(Object object, String string, int n) {
        int n2 = this.layoutHelper != null ? this.layoutHelper.c(this.inputData, object, string) : this.getServiceInputData().getValueAsInteger(object, string);
        if (n != n2) {
            this.getServiceInputData().setOption(object, string, n);
        }
    }

    protected void processChoices(String string, String string2) {
        this.processChoices((Object)this.getGraph(), string, string2);
    }

    protected void processChoices(Object object, String string, String string2) {
        String string3 = this.layoutHelper != null ? this.layoutHelper.d(this.inputData, object, string) : this.getServiceInputData().getValueAsString(object, string);
        if (!string2.equals(string3)) {
            this.getServiceInputData().setOption(object, string, string2);
        }
    }

    protected void processChoices(String string, boolean bl) {
        TSEGraph tSEGraph = this.getGraph();
        boolean bl2 = this.getServiceInputData().getValueAsBoolean(tSEGraph, string);
        if (bl != bl2) {
            this.getServiceInputData().setOption((Object)tSEGraph, string, bl);
        }
    }

    protected void processChoices(Object object, String string, boolean bl) {
        boolean bl2 = this.layoutHelper != null ? this.layoutHelper.a(this.inputData, object, string) : this.getServiceInputData().getValueAsBoolean(object, string);
        if (bl != bl2) {
            this.getServiceInputData().setOption(object, string, bl);
        }
    }

    protected void processCheckbox(String string, JCheckBox jCheckBox) {
        this.processCheckbox(this.getGraph(), string, jCheckBox, false);
    }

    protected void processCheckbox(Object object, String string, JCheckBox jCheckBox) {
        this.processCheckbox(object, string, jCheckBox, false);
    }

    protected void processCheckbox(String string, JCheckBox jCheckBox, boolean bl) {
        this.processCheckbox(this.getGraph(), string, jCheckBox, bl);
    }

    protected void processCheckbox(Object object, String string, JCheckBox jCheckBox, boolean bl) {
        boolean bl2;
        boolean bl3 = jCheckBox.isSelected();
        if (bl) {
            bl3 = !bl3;
        }
        if (bl3 != (bl2 = this.layoutHelper != null ? this.layoutHelper.a(this.inputData, object, string) : this.getServiceInputData().getValueAsBoolean(object, string))) {
            this.getServiceInputData().setOption(object, string, bl3);
        }
    }

    protected int normalizeComponentDimensions(List list, boolean bl, boolean bl2) {
        int n = -1;
        int n2 = -1;
        if (list != null) {
            JComponent jComponent;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jComponent = (JComponent)iterator.next();
                if (bl) {
                    n = (int)Math.max(jComponent.getPreferredSize().getWidth(), (double)n);
                }
                if (!bl2) continue;
                n2 = (int)Math.max(jComponent.getPreferredSize().getHeight(), (double)n2);
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                jComponent = (JComponent)iterator.next();
                int n3 = bl ? n : (int)jComponent.getPreferredSize().getWidth();
                int n4 = bl2 ? n2 : (int)jComponent.getPreferredSize().getHeight();
                Dimension dimension = new Dimension(n3, n4);
                jComponent.setPreferredSize(dimension);
                jComponent.setMinimumSize(dimension);
                jComponent.setMaximumSize(dimension);
            }
        }
        return n;
    }

    public void onGlobalOptionChanged(String string, Object object) {
    }

    protected void addTextFieldListener(JTextField jTextField, String string, TSEBaseLayoutPropertiesDialog tSEBaseLayoutPropertiesDialog) {
        new hy(this, jTextField, string, tSEBaseLayoutPropertiesDialog);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.activateButtons();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.activateButtons();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void onLayout() {
    }

    public void onReset() {
        if (this.isChanged()) {
            this.setValues(this.getServiceInputData());
            this.setChanged(false);
        }
    }

    public void onDefaults() {
        if (this.isChanged()) {
            this.setValues(new TSServiceInputData());
            this.setChanged(true);
        }
    }

    public String translateText(String string) {
        boolean bl = true;
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (string.equals("") || bl) {
            return string;
        }
        return this.labels.getStringSafely(string);
    }

    protected TSEGraph getGraph() {
        return this.graph;
    }

    public void setGraph(TSEGraph tSEGraph) {
        this.graph = tSEGraph;
    }

    public TSServiceInputData getServiceInputData() {
        return this.inputData;
    }

    public void setServiceInputData(TSServiceInputData tSServiceInputData) {
        this.inputData = tSServiceInputData;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog jDialog) {
        this.dialog = jDialog;
    }

    public int getOperation() {
        return 1000;
    }

    public int getLayoutStyle() {
        return 0;
    }
}

