/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.dialog.TSUnsignedDoubleField;
import com.tomsawyer.editor.service.layout.properties.TSETabComponent;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.layout.jlayout.TSSymmetricLayoutInputTailor;
import com.tomsawyer.service.layout.jlayout.es;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TSESymmetricTab
extends TSETabComponent {
    protected TSUnsignedDoubleField nodeSpacingField;
    protected JRadioButton qualityDraftRadioButton;
    protected JRadioButton qualityDefaultRadioButton;
    protected JRadioButton qualityProofRadioButton;

    public TSESymmetricTab(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
    }

    protected void init() {
        super.init();
        this.layoutHelper = new es();
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        JPanel jPanel3 = this.makeSpacingOptionsPanel();
        JPanel jPanel4 = this.makeMiscPanel();
        JPanel jPanel5 = this.makeLayoutQualityPanel();
        jPanel.add(jPanel3);
        jPanel.add(this.createVerticalRigidArea(6));
        jPanel.add(jPanel4);
        Vector<JPanel> vector = new Vector<JPanel>();
        vector.add(jPanel3);
        vector.add(jPanel4);
        this.normalizeComponentDimensions(vector, true, false);
        jPanel2.add(jPanel5);
        Vector<JPanel> vector2 = new Vector<JPanel>();
        vector2.add(jPanel5);
        this.normalizeComponentDimensions(vector2, true, false);
        this.add(jPanel);
        this.add(this.createHorizontalRigidArea(6));
        this.add(jPanel2);
        this.createEmptyBorder(this, 5, 5, 5, 5);
    }

    protected JPanel makeSpacingOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        JLabel jLabel = this.createLabel("Node_Spacing:");
        this.nodeSpacingField = this.createDoubleField(4, 0.0, 1000.0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.add(jLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        this.nodeSpacingField.setAlignmentX(1.0f);
        jPanel3.add((Component)this.nodeSpacingField);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(30, 0)));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Spacing_Options", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeLayoutQualityPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        this.qualityDraftRadioButton = this.createRadioButton("Draft");
        this.qualityDefaultRadioButton = this.createRadioButton("Default");
        this.qualityProofRadioButton = this.createRadioButton("Proof");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.qualityDraftRadioButton);
        buttonGroup.add(this.qualityDefaultRadioButton);
        buttonGroup.add(this.qualityProofRadioButton);
        jPanel.add(this.qualityDraftRadioButton);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.qualityDefaultRadioButton);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.qualityProofRadioButton);
        this.createCompoundBorder(jPanel, "Layout_Quality", 0, 6, 5, 30);
        return jPanel;
    }

    protected JPanel makeMiscPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        this.createEmptyBorder(jPanel, 3, 2, 0, 0);
        return jPanel;
    }

    public void setValues(TSServiceInputData tSServiceInputData) {
        TSSymmetricLayoutInputTailor tSSymmetricLayoutInputTailor = new TSSymmetricLayoutInputTailor(tSServiceInputData, (TSDGraph)this.getGraph());
        this.nodeSpacingField.setText(String.valueOf(tSSymmetricLayoutInputTailor.getNodeSpacing()));
        int n = tSSymmetricLayoutInputTailor.getQuality();
        if (n == 0) {
            this.qualityDraftRadioButton.setSelected(true);
        } else if (n == 1) {
            this.qualityDefaultRadioButton.setSelected(true);
        } else {
            this.qualityProofRadioButton.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.activateButtons();
    }

    public void onApply() {
        super.onApply();
        this.processDoubleField("layout:symmetric:graph:nodeSpacing", this.nodeSpacingField);
        int n = this.qualityDraftRadioButton.isSelected() ? 0 : (this.qualityDefaultRadioButton.isSelected() ? 1 : 2);
        this.processChoices("layout:symmetric:graph:quality", n);
    }

    public int getLayoutStyle() {
        return 3;
    }
}

