/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.netbeans.actions.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.uml.integration.netbeans.actions.ui.ChooseLocationDialog;
import org.netbeans.modules.uml.integration.netbeans.actions.ui.ReverseEngineerDescriptor;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.ui.common.JavaSourceRootsUI;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseEngineerPanel
extends JPanel
implements ActionListener,
DocumentListener,
ChangeListener,
TableModelListener {
    private JButton browseButton;
    private JPanel existingProjectPanel;
    private JRadioButton existingProjectRadio;
    private JPanel newProjectPanel;
    private JRadioButton newProjectRadio;
    private JLabel projectFolderLabel;
    private JTextField projectFolderText;
    private JLabel projectLocationLabel;
    private JTextField projectLocationText;
    private JLabel projectNameLabel;
    private JTextField projectNameText;
    private ButtonGroup projectTypeButtonGroup;
    private JPanel selNodesPanel;
    private JLabel selectedNodesLabel;
    private JTextField selectedNodesText;
    private JLabel sourceFoldersLabel;
    private JTable sourceRoots;
    private JPanel sourceRootsPanel;
    private JScrollPane sourceRootsScrollPane;
    private JLabel statusLabel;
    private JComboBox targetProjectCombo;
    private JLabel targetProjectLabel;
    private Project javaProject;
    private Project umlProject;
    private ArrayList<String> selectedNodes;
    private boolean showSourceRoots = true;
    private ChooseLocationDialog chooser;
    private ReverseEngineerDescriptor descriptor;
    private boolean valid = true;
    private String statusMsg = " ";
    private boolean enable = false;
    private String PROP_PROJECT_NAME = "PROP_PROJECT_NAME";

    public ReverseEngineerPanel(Project project) {
        this(project, null);
    }

    public ReverseEngineerPanel(Project project, Project project2) {
        this.javaProject = project;
        this.umlProject = project2;
        this.showSourceRoots = true;
        this.initComponents();
        this.initSourceRootsTable();
        this.initListeners();
        this.initValues();
        this.initJavaProjectValues();
    }

    public ReverseEngineerPanel(Project project, ArrayList<String> arrayList, Project project2) {
        this.javaProject = project;
        this.selectedNodes = arrayList;
        this.umlProject = project2;
        this.showSourceRoots = false;
        this.initComponents();
        this.sourceRootsPanel.setVisible(false);
        this.initSourceRootsTable();
        this.initListeners();
        this.initValues();
        this.initJavaProjectValues();
        this.initJavaFilesValues();
    }

    private void initComponents() {
        this.projectTypeButtonGroup = new ButtonGroup();
        this.selNodesPanel = new JPanel();
        this.selectedNodesLabel = new JLabel();
        this.selectedNodesText = new JTextField();
        this.sourceRootsPanel = new JPanel();
        this.sourceFoldersLabel = new JLabel();
        this.sourceRootsScrollPane = new JScrollPane();
        this.sourceRoots = new JTable();
        this.existingProjectPanel = new JPanel();
        this.existingProjectRadio = new JRadioButton();
        this.targetProjectLabel = new JLabel();
        this.targetProjectCombo = new JComboBox();
        this.newProjectPanel = new JPanel();
        this.newProjectRadio = new JRadioButton();
        this.projectNameLabel = new JLabel();
        this.projectNameText = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationText = new JTextField();
        this.projectFolderLabel = new JLabel();
        this.projectFolderText = new JTextField();
        this.browseButton = new JButton();
        this.statusLabel = new JLabel();
        this.selectedNodesLabel.setLabelFor(this.selectedNodesText);
        Mnemonics.setLocalizedText((JLabel)this.selectedNodesLabel, (String)NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_SelectedNodes"));
        this.selectedNodesLabel.getAccessibleContext().setAccessibleName("");
        this.selectedNodesLabel.getAccessibleContext().setAccessibleDescription("");
        this.selectedNodesText.setEditable(false);
        this.selectedNodesText.getAccessibleContext().setAccessibleName("");
        this.selectedNodesText.getAccessibleContext().setAccessibleDescription("");
        GroupLayout groupLayout = new GroupLayout((Container)this.selNodesPanel);
        this.selNodesPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.selectedNodesLabel).addPreferredGap(0).add((Component)this.selectedNodesText, -1, 481, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.selectedNodesLabel).add((Component)this.selectedNodesText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.sourceFoldersLabel.setLabelFor(this.sourceRoots);
        Mnemonics.setLocalizedText((JLabel)this.sourceFoldersLabel, (String)NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_JavaProjectSourcePackageFolders"));
        this.sourceFoldersLabel.getAccessibleContext().setAccessibleName("");
        this.sourceFoldersLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerPanel.class, (String)"ACSD_JavaProjectSourcePackageFolders"));
        this.sourceRoots.setModel(new DefaultTableModel(new Object[][]{{new Boolean(true), null, null}, {new Boolean(true), null, null}}, new String[]{"Reverse Engineer", "Package Folder", "Package Folder Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, Object.class, String.class};
                this.canEdit = new boolean[]{true, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.sourceRootsScrollPane.setViewportView(this.sourceRoots);
        this.sourceRoots.getAccessibleContext().setAccessibleName("");
        this.sourceRoots.getAccessibleContext().setAccessibleDescription("");
        GroupLayout groupLayout2 = new GroupLayout((Container)this.sourceRootsPanel);
        this.sourceRootsPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.sourceRootsScrollPane, -1, 563, Short.MAX_VALUE).add((Component)this.sourceFoldersLabel)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.sourceFoldersLabel).addPreferredGap(0).add((Component)this.sourceRootsScrollPane, -1, 98, Short.MAX_VALUE).addContainerGap()));
        this.projectTypeButtonGroup.add(this.existingProjectRadio);
        this.existingProjectRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.existingProjectRadio, (String)NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_UseExistingUMLProject"));
        this.existingProjectRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.existingProjectRadio.setMargin(new Insets(0, 0, 0, 0));
        this.existingProjectRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ReverseEngineerPanel.this.existingProjectRadioStateChanged(changeEvent);
            }
        });
        this.existingProjectRadio.getAccessibleContext().setAccessibleName("");
        this.existingProjectRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerPanel.class, (String)"ACSD_UseExistingUMLProject"));
        this.targetProjectLabel.setLabelFor(this.targetProjectCombo);
        Mnemonics.setLocalizedText((JLabel)this.targetProjectLabel, (String)NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_TargetProject"));
        this.targetProjectLabel.getAccessibleContext().setAccessibleName("");
        this.targetProjectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerPanel.class, (String)"ACSD_TargetProject"));
        this.targetProjectCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ReverseEngineerPanel.this.targetProjectComboItemStateChanged(itemEvent);
            }
        });
        this.targetProjectCombo.getAccessibleContext().setAccessibleName("");
        this.targetProjectCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerPanel.class, (String)"ACSD_TargetProject"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.existingProjectPanel);
        this.existingProjectPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(27, 27, 27).add((Component)this.targetProjectLabel).addPreferredGap(0).add((Component)this.targetProjectCombo, 0, 469, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.existingProjectRadio))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.existingProjectRadio).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.targetProjectLabel).add((Component)this.targetProjectCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.projectTypeButtonGroup.add(this.newProjectRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.newProjectRadio, (String)NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_CreateNewUMLProject"));
        this.newProjectRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.newProjectRadio.setMargin(new Insets(0, 0, 0, 0));
        this.newProjectRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ReverseEngineerPanel.this.newProjectRadioStateChanged(changeEvent);
            }
        });
        this.newProjectRadio.getAccessibleContext().setAccessibleName("");
        this.newProjectRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerPanel.class, (String)"ACSD_CreateNewUMLProject"));
        this.projectNameLabel.setLabelFor(this.projectNameText);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_ProjectName"));
        this.projectNameLabel.getAccessibleContext().setAccessibleName("");
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerPanel.class, (String)"ACSD_ProjectName"));
        this.projectNameText.getAccessibleContext().setAccessibleName("");
        this.projectNameText.getAccessibleContext().setAccessibleDescription("");
        this.projectLocationLabel.setLabelFor(this.projectLocationText);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_ProjectLocation"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerPanel.class, (String)"ACSD_ProjectLocation"));
        this.projectLocationText.getAccessibleContext().setAccessibleName("");
        this.projectLocationText.getAccessibleContext().setAccessibleDescription("");
        this.projectFolderLabel.setLabelFor(this.projectFolderText);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_ProjectFolder"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleName(null);
        this.projectFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerPanel.class, (String)"ASCD_ProjectFolder"));
        this.projectFolderText.setEnabled(false);
        this.projectFolderText.getAccessibleContext().setAccessibleName("");
        this.projectFolderText.getAccessibleContext().setAccessibleDescription("");
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReverseEngineerPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerPanel.class, (String)"ACSD_BrowseButton"));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.newProjectPanel);
        this.newProjectPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.newProjectRadio)).add(2, (GroupLayout.Group)groupLayout4.createSequentialGroup().add(27, 27, 27).add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.projectLocationLabel).add((Component)this.projectNameLabel).add((Component)this.projectFolderLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.projectFolderText, -1, 376, Short.MAX_VALUE).add((Component)this.projectNameText, -1, 376, Short.MAX_VALUE).add(2, (Component)this.projectLocationText, -1, 376, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton))).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.newProjectRadio).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.browseButton).add((Component)this.projectLocationText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.projectFolderLabel).add((Component)this.projectFolderText, -2, -1, -2)).addContainerGap(11, Short.MAX_VALUE)));
        this.statusLabel.setForeground(new Color(0, 0, 255));
        this.statusLabel.setText("<field validation status message>");
        this.statusLabel.getAccessibleContext().setAccessibleName("Dialog field validation message");
        this.statusLabel.getAccessibleContext().setAccessibleDescription("Reports the validation messages for all of the input fields of this dialog.");
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.selNodesPanel, -1, -1, Short.MAX_VALUE).add((Component)this.sourceRootsPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.statusLabel, -1, 563, Short.MAX_VALUE).addContainerGap()).add((Component)this.newProjectPanel, -1, -1, Short.MAX_VALUE).add((Component)this.existingProjectPanel, -1, -1, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.selNodesPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.sourceRootsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.existingProjectPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.newProjectPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.statusLabel)));
    }

    private void targetProjectComboItemStateChanged(ItemEvent itemEvent) {
        this.umlProject = (Project)this.targetProjectCombo.getSelectedItem();
    }

    private void newProjectRadioStateChanged(ChangeEvent changeEvent) {
    }

    private void existingProjectRadioStateChanged(ChangeEvent changeEvent) {
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = new JFrame();
        jFrame.setLocation(this.getLocationOnScreen());
        if (this.chooser == null) {
            this.chooser = new ChooseLocationDialog((Frame)jFrame, true, new File(this.retrieveProjectParentDirectory()), NbBundle.getMessage(ReverseEngineerPanel.class, (String)"LBL_RevEngProjectLocationChooseDialog_Title"));
        } else {
            this.chooser.setFolderLocation(this.retrieveProjectParentDirectory());
        }
        this.chooser.getLocationChooser().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReverseEngineerPanel.this.locationChooserActionPerformed(actionEvent);
            }
        });
        this.chooser.setLocation(this.getLocationOnScreen());
        this.chooser.setVisible(true);
    }

    public void locationChooserActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ApproveSelection")) {
            this.projectLocationText.setText(this.chooser.getFolderLocation().getPath());
        }
    }

    @Override
    public void requestFocus() {
        this.targetProjectCombo.requestFocus();
        this.updateValidStatus();
    }

    private void initListeners() {
        this.projectNameText.getDocument().addDocumentListener(this);
        this.projectLocationText.getDocument().addDocumentListener(this);
        this.projectTypeButtonGroup.getSelection().addChangeListener(this);
        this.sourceRoots.getModel().addTableModelListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameText.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(this.PROP_PROJECT_NAME, null, this.projectNameText.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameText.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(this.PROP_PROJECT_NAME, null, this.projectNameText.getText());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameText.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(this.PROP_PROJECT_NAME, null, this.projectNameText.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameText.getDocument() || document == this.projectLocationText.getDocument()) {
            String string = this.projectNameText.getText();
            String string2 = this.projectLocationText.getText();
            this.projectFolderText.setText(string2 + File.separatorChar + string);
            this.updateValidStatus();
        }
    }

    private void initSourceRootsTable() {
        JavaSourceRootsUI.JavaSourceRootsModel javaSourceRootsModel = JavaSourceRootsUI.createModel((Project)this.javaProject);
        if (javaSourceRootsModel != null) {
            this.sourceRoots.setModel((TableModel)javaSourceRootsModel);
        } else {
            this.sourceRoots.setModel(JavaSourceRootsUI.createEmptyModel());
        }
        this.sourceRoots.getTableHeader().setReorderingAllowed(false);
        this.sourceRoots.setAutoResizeMode(3);
    }

    private void initValues() {
        this.populateProjectList();
        this.enablePanelFields(this.targetProjectComboHasItems() && this.umlProject != null);
        this.populateNewProjectFields();
        this.statusLabel.setText(" ");
    }

    private void initJavaProjectValues() {
        this.selectedNodesText.setText(this.retrieveJavaProjectName());
    }

    private void initJavaFilesValues() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.selectedNodes == null || this.selectedNodes.size() == 0) {
            stringBuffer.append("<Error: no nodes selected>");
        } else {
            for (String string : this.selectedNodes) {
                stringBuffer.append(string).append(", ");
            }
            stringBuffer.delete(stringBuffer.lastIndexOf(", "), stringBuffer.length() - 1);
        }
        this.selectedNodesText.setText(stringBuffer.toString());
    }

    private void populateProjectList() {
        ProjectCellRenderer projectCellRenderer = new ProjectCellRenderer();
        this.targetProjectCombo.setRenderer(projectCellRenderer);
        Project[] projectArray = ProjectUtil.getOpenUMLProjects();
        if (projectArray == null || projectArray.length < 1) {
            this.enableExistingProjectPanelComponents(false);
            this.existingProjectRadio.setEnabled(false);
        } else {
            DefaultComboBoxModel<Project> defaultComboBoxModel = new DefaultComboBoxModel<Project>(projectArray);
            this.targetProjectCombo.setModel(defaultComboBoxModel);
            this.selectTargetProject();
        }
    }

    private void populateNewProjectFields() {
        String string = this.retrieveProjectParentDirectory();
        this.projectNameText.setText(ProjectUtil.createUniqueProjectName((File)new File(string), (String)(this.retrieveJavaProjectName() + NbBundle.getMessage(ReverseEngineerPanel.class, (String)"TXT_RE_PROJECT_SUFFIX")), (boolean)true));
        this.projectLocationText.setText(this.retrieveProjectParentDirectory());
    }

    private String retrieveJavaProjectName() {
        return ProjectUtils.getInformation((Project)this.javaProject).getDisplayName();
    }

    private void selectTargetProject() {
        if (!this.targetProjectComboHasItems()) {
            this.targetProjectCombo.setEnabled(false);
            return;
        }
        if (this.umlProject != null) {
            this.targetProjectCombo.setSelectedItem(this.umlProject);
        } else {
            this.targetProjectCombo.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.enablePanelFields(this.existingProjectRadio.isSelected());
        this.updateValidStatus();
    }

    private void enablePanelFields(boolean bl) {
        this.enableExistingProjectPanelComponents(bl);
        this.enableNewProjectPanelComponents(!bl);
    }

    private void enableExistingProjectPanelComponents(boolean bl) {
        this.existingProjectRadio.setSelected(bl);
        this.targetProjectLabel.setEnabled(bl);
        this.targetProjectCombo.setEnabled(bl);
        this.umlProject = bl ? (Project)this.targetProjectCombo.getSelectedItem() : null;
    }

    private void enableNewProjectPanelComponents(boolean bl) {
        this.newProjectRadio.setSelected(bl);
        this.projectNameLabel.setEnabled(bl);
        this.projectNameText.setEnabled(bl);
        this.projectLocationLabel.setEnabled(bl);
        this.projectLocationText.setEnabled(bl);
        this.browseButton.setEnabled(bl);
        this.projectFolderLabel.setEnabled(bl);
    }

    public String getProjectFolder() {
        return this.projectFolderText.getText();
    }

    public String getProjectName() {
        return this.projectNameText.getText();
    }

    public Project getJavaProject() {
        return this.javaProject;
    }

    public JavaSourceRootsUI.JavaSourceRootsModel getSourceRoots() {
        return (JavaSourceRootsUI.JavaSourceRootsModel)this.sourceRoots.getModel();
    }

    public boolean isUseExistingProject() {
        return this.existingProjectRadio.isSelected();
    }

    public boolean isCreateNewProject() {
        return this.newProjectRadio.isSelected();
    }

    public Project getUMLProject() {
        return this.umlProject;
    }

    public boolean isShowSourceRoots() {
        return this.showSourceRoots;
    }

    private String retrieveProjectParentDirectory() {
        try {
            return FileUtil.toFile((FileObject)this.javaProject.getProjectDirectory().getParent()).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "<Java project parent folder IOException>";
        }
    }

    private boolean targetProjectComboHasItems() {
        return this.targetProjectCombo.getModel() != null && this.targetProjectCombo.getModel().getSize() > 0;
    }

    private boolean updateValidStatus() {
        this.enable = true;
        this.statusMsg = " ";
        if (this.newProjectRadio.isSelected()) {
            if (!new File(this.projectLocationText.getText()).exists()) {
                this.enable = Boolean.FALSE;
                this.statusMsg = "MSG_STATUS_ProjectLocationFolderDNE";
                return this.notifyPropertyListeners();
            }
            if (new File(this.projectFolderText.getText()).exists()) {
                this.enable = Boolean.FALSE;
                this.statusMsg = "MSG_STATUS_ProjectExists";
                return this.notifyPropertyListeners();
            }
        }
        if (this.showSourceRoots) {
            boolean bl = false;
            for (int i = 0; i < this.sourceRoots.getModel().getRowCount(); ++i) {
                if (!((Boolean)this.sourceRoots.getModel().getValueAt(i, 0)).booleanValue()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.enable = Boolean.FALSE;
                this.statusMsg = "MSG_STATUS_NoSourceGroups";
                return this.notifyPropertyListeners();
            }
        }
        return this.notifyPropertyListeners();
    }

    private boolean notifyPropertyListeners() {
        this.firePropertyChange("valid", this.valid, this.enable);
        if (!this.statusMsg.equals(" ")) {
            this.statusMsg = NbBundle.getMessage(ReverseEngineerPanel.class, (String)this.statusMsg);
        }
        this.statusLabel.setText(this.statusMsg);
        this.valid = this.enable;
        return this.valid;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateValidStatus();
    }

    private static class ProjectCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ProjectCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Project) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.setText(projectInformation.getDisplayName());
                this.setIcon(projectInformation.getIcon());
            } else {
                this.setText(object == null ? " " : object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

