/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.netbeans;

import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.SourceNavigator;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;
import org.netbeans.modules.uml.integration.ide.events.MemberInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodInfo;
import org.netbeans.modules.uml.integration.netbeans.ElementAndFile;
import org.netbeans.modules.uml.integration.netbeans.NBFileUtils;
import org.netbeans.modules.uml.integration.netbeans.NBUtils;
import org.netbeans.modules.uml.integration.netbeans.actions.SourceNavigateAction;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotation;

public class NBSourceNavigator
implements SourceNavigator {
    private int lineNoOffset = 0;

    public NBSourceNavigator() {
        Log.entry((String)"Entering function NBSourceNavigator::NBSourceNavigator");
    }

    public void navigateTo(ClassInfo classInfo) {
        if (SourceNavigateAction.Round_Trip) {
            Log.out((String)("In navigateTo class " + classInfo.getName()));
            ElementAndFile elementAndFile = this.getJavaClass(classInfo);
            if (elementAndFile != null) {
                this.showSourceFile(elementAndFile);
            }
        }
        SourceNavigateAction.Round_Trip = false;
    }

    public void navigateTo(MethodInfo methodInfo) {
        if (SourceNavigateAction.Round_Trip) {
            Log.entry((String)"Entering function NBSourceNavigator::navigateTo Method");
            Log.out((String)(" To get the method " + methodInfo.getName()));
            ClassInfo classInfo = methodInfo.getContainingClass();
            String string = classInfo.getName();
            string = string.substring(string.lastIndexOf(".") + 1);
            boolean bl = methodInfo.getName().equals(string);
            ElementAndFile elementAndFile = NBUtils.getMethod(methodInfo, bl);
            if (elementAndFile != null) {
                Log.out((String)"Got the method displaying..");
                try {
                    this.showSourceFile(elementAndFile);
                }
                catch (Exception exception) {
                    Log.stackTrace((Throwable)exception);
                }
            }
        }
        SourceNavigateAction.Round_Trip = false;
    }

    public void navigateTo(MemberInfo memberInfo) {
        if (SourceNavigateAction.Round_Trip) {
            Log.entry((String)"Entering function NBSourceNavigator::navigateTo Member");
            Log.out((String)("The member is " + memberInfo.getName()));
            ElementAndFile elementAndFile = NBUtils.getField(memberInfo);
            if (elementAndFile != null) {
                this.showSourceFile(elementAndFile);
            }
        }
        SourceNavigateAction.Round_Trip = false;
    }

    protected void showSourceFile(ElementAndFile elementAndFile) {
        Log.entry((String)"Entering function NBSourceNavigator::showSourceFile");
        if (elementAndFile != null) {
            UiUtils.open((FileObject)elementAndFile.getFileObject(), (ElementHandle)elementAndFile.getElementHandle());
        }
    }

    protected ElementAndFile getJavaClass(ClassInfo classInfo) {
        Log.entry((String)"Entering function NBSourceNavigator::getClassElement");
        NBFileUtils nBFileUtils = new NBFileUtils();
        ElementAndFile elementAndFile = NBFileUtils.findJavaClass(classInfo);
        StatusDisplayer statusDisplayer = StatusDisplayer.getDefault();
        if (elementAndFile != null) {
            statusDisplayer.setStatusText("");
        }
        return elementAndFile;
    }

    private static final class NavAnnotation
    extends Annotation {
        private static NavAnnotation instance = null;

        private NavAnnotation() {
        }

        public static NavAnnotation getInstance() {
            if (instance == null) {
                instance = new NavAnnotation();
            }
            return instance;
        }

        public String getShortDescription() {
            return "";
        }

        public String getAnnotationType() {
            return "com-embarcadero-netbeans-nav";
        }
    }
}

