/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.netbeans;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.JavaClassUtils;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;
import org.netbeans.modules.uml.integration.netbeans.ElementAndFile;
import org.netbeans.modules.uml.integration.netbeans.NBUtils;
import org.netbeans.modules.uml.project.AssociatedSourceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class NBFileUtils {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.uml.integration");

    public static FileSystem getFileSystem(String string) {
        return NBFileUtils.getFileSystem(string, false);
    }

    public static FileSystem getFileSystem(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            File file = new File(string);
            String string2 = string.toLowerCase();
            Repository repository = Repository.getDefault();
            FileSystem[] fileSystemArray = repository.toArray();
            try {
                for (int i = 0; i < fileSystemArray.length; ++i) {
                    File file2 = FileUtil.toFile((FileObject)fileSystemArray[i].getRoot());
                    if (file2 == null) continue;
                    if (bl) {
                        Log.out((String)("getFileSystem(" + string + "): trying " + file2));
                    }
                    if (bl ? file2.equals(file) : string2.startsWith(file2.toString().toLowerCase())) {
                        return fileSystemArray[i];
                    }
                    if (!bl) continue;
                    Log.out((String)("getFileSystem(" + string + "): rejected " + file2));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public FileObject findFileObject(FileSystem fileSystem, String string) {
        String string2;
        FileObject fileObject;
        Log.entry((String)"Entering function NBFileUtils::findFileObject");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        for (fileObject = fileSystem.getRoot(); stringTokenizer.hasMoreTokens() && fileObject != null; fileObject = fileObject.getFileObject(string2)) {
            string2 = stringTokenizer.nextToken();
        }
        return fileObject;
    }

    public static FileSystem getFS(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        String string2 = new File(string).getParent();
        FileObject fileObject = FileUtil.toFileObject((File)new File(string2));
        try {
            return fileObject != null ? fileObject.getFileSystem() : null;
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            logger.log(Level.WARNING, null, fileStateInvalidException);
            return null;
        }
    }

    public FileObject createPackageSturcture(FileSystem fileSystem, String string) {
        Log.entry((String)"Entering function NBFileUtils::createPackageSturcture");
        FileObject fileObject = null;
        FileObject fileObject2 = null;
        try {
            fileObject = fileSystem.getRoot();
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                if (fileObject != null) {
                    fileObject.refresh();
                }
                if ((fileObject2 = fileObject.getFileObject(string2 = stringTokenizer.nextToken())) == null && string2.indexOf(46) < 0) {
                    fileObject2 = fileObject.createFolder(string2);
                } else if (fileObject2 == null) {
                    Log.entry((String)"Entering function NBFileUtils::if");
                    break;
                }
                fileObject = fileObject2;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            logger.log(Level.WARNING, null, dataObjectNotFoundException);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, null, exception);
        }
        return fileObject;
    }

    public static String normalizeFile(String string) {
        if (string != null && string.length() > 0) {
            string = string.replace("/", File.separator).trim();
        }
        return string;
    }

    public static JavaSource findResource(String string) {
        Log.entry((String)"Entering function NBFileUtils::findResource(String)");
        if (string == null || string.length() <= 0) {
            return null;
        }
        string = NBFileUtils.normalizeFile(string);
        JavaSource javaSource = null;
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        if (fileObject != null) {
            javaSource = JavaSource.forFileObject((FileObject)fileObject);
        }
        return javaSource;
    }

    public static FileObject findFileObject(String string) {
        Log.entry((String)"Entering function NBFileUtils::findFileObject");
        File file = new File(string);
        return FileUtil.toFileObject((File)file);
    }

    public DataFolder findFolder(String string) {
        Log.entry((String)"Entering function NBFileUtils::findFolder");
        DataFolder dataFolder = null;
        try {
            FileObject fileObject = NBFileUtils.findFileObject(string);
            if (fileObject != null) {
                dataFolder = (DataFolder)DataFolder.find((FileObject)fileObject);
            } else {
                FileSystem fileSystem = NBFileUtils.getFileSystem(string, false);
                if (fileSystem != null) {
                    File file = FileUtil.toFile((FileObject)fileSystem.getRoot());
                    String string2 = file.getAbsolutePath();
                    String string3 = string.substring(string2.length() + 1);
                    FileObject fileObject2 = this.createPackageSturcture(fileSystem, string3);
                    dataFolder = DataFolder.findFolder((FileObject)fileObject2);
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            logger.log(Level.WARNING, null, dataObjectNotFoundException);
            dataFolder = null;
        }
        return dataFolder;
    }

    public static FileObject findFileObject(String string, String string2, String string3) {
        FileObject fileObject;
        ClassPath classPath;
        if (string2 == null || string2.trim().length() == 0) {
            string2 = null;
        }
        if (string == null) {
            string = "";
        }
        if ((string = string.replace('.', '/').trim()).length() > 0) {
            string = string + "/";
        }
        if (string3 != null && string2 != null) {
            string2 = string2 + "." + string3;
        }
        String string4 = string;
        if (string2 != null) {
            string4 = string4 + string2;
        }
        if ((classPath = ClassPath.getClassPath((FileObject)(fileObject = FileUtil.toFileObject((File)new File(string4))), (String)"classpath/source")) != null) {
            return classPath.findResource(string4);
        }
        return null;
    }

    public static boolean isWritable(File file) {
        if (file == null) {
            return false;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        return fileObject != null && fileObject.isFolder() && fileObject.canWrite();
    }

    public static void checkWritable(ClassInfo classInfo) throws UnwritableFileException {
        String string = classInfo == null ? null : classInfo.getFilename();
        try {
            File file = new File(string);
            if (file.canWrite() || !file.exists()) {
                return;
            }
            if (!JavaClassUtils.needToCheckOut(classInfo)) {
                NBUtils.showSpamlessErrCode("Errors.Roundtrip.ReadOnly", new Object[]{string}, "Errors.Roundtrip.ReadOnly.Title");
            }
            if (!file.canWrite()) {
                throw new UnwritableFileException(string);
            }
        }
        catch (Exception exception) {
            throw new UnwritableFileException(string);
        }
    }

    public static ElementAndFile findJavaClass(ClassInfo classInfo) {
        Log.entry((String)"Entering function NBFileUtils::findJavaClass");
        ElementAndFile elementAndFile = null;
        if (classInfo != null) {
            try {
                JavaSource javaSource = NBFileUtils.findResource(classInfo);
                if (javaSource != null) {
                    String string = classInfo.getPackage();
                    if (string != null && string.length() > 0) {
                        string = string + ".";
                    }
                    string = string + classInfo.getName();
                    elementAndFile = NBFileUtils.getTypeElement(javaSource, string);
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, null, exception);
            }
        }
        return elementAndFile;
    }

    public static ElementAndFile getTypeElement(JavaSource javaSource, final String string) {
        final ElementAndFile[] elementAndFileArray = new ElementAndFile[1];
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) {
                    Elements elements = compilationController.getElements();
                    TypeElement typeElement = elements.getTypeElement(string);
                    if (typeElement != null) {
                        elementAndFileArray[0] = new ElementAndFile(ElementHandle.create((Element)typeElement), compilationController.getFileObject());
                        for (Element element : elements.getAllMembers(typeElement)) {
                        }
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, null, iOException);
        }
        return elementAndFileArray[0];
    }

    public static JavaSource findResource(ClassInfo classInfo) {
        ClassInfo classInfo2;
        Log.entry((String)"Entering function NBFileUtils::findResource");
        String string = classInfo.getFilename();
        if (string == null || string.length() == 0) {
            classInfo.updateFilename(null);
            string = classInfo.getFilename();
        }
        if ((classInfo2 = classInfo.getOuterClass()) != null) {
            return NBFileUtils.findResource(classInfo2);
        }
        JavaSource javaSource = null;
        try {
            if (classInfo != null) {
                javaSource = NBFileUtils.findResource(string);
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, null, exception);
        }
        return javaSource;
    }

    public static Project getAssociatedSourceProject(Project project) {
        AssociatedSourceProvider associatedSourceProvider = (AssociatedSourceProvider)project.getLookup().lookup(AssociatedSourceProvider.class);
        Project project2 = associatedSourceProvider.getAssociatedSourceProject();
        return project2;
    }

    public static FileObject getPackageFileObject(ClassInfo classInfo) {
        FileObject fileObject = NBFileUtils.getSrcDirFileObject(classInfo);
        FileObject fileObject2 = null;
        String string = "";
        try {
            string = classInfo.getPackage();
            if (string == null) {
                string = "";
            }
            if (string.length() == 0) {
                return fileObject;
            }
            fileObject2 = fileObject.getFileObject(string = string.replace('.', '/').trim());
            if (fileObject2 == null) {
                String string2 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                FileObject fileObject3 = fileObject;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    FileObject fileObject4 = fileObject.getFileObject(string2 = string2 + "/" + string3);
                    if (fileObject4 != null) {
                        fileObject3 = fileObject4;
                    }
                    if (fileObject4 != null) continue;
                    fileObject3 = fileObject2 = fileObject3.createFolder(string3);
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, null, exception);
        }
        return fileObject2;
    }

    public static FileObject getExportPackageFileObject(ClassInfo classInfo) {
        FileObject fileObject = classInfo.getExportSourceFolderFileObject();
        FileObject fileObject2 = null;
        String string = "";
        try {
            string = classInfo.getPackage();
            if (string == null) {
                string = "";
            }
            if (string.length() == 0) {
                return fileObject;
            }
            fileObject2 = fileObject.getFileObject(string = string.replace('.', '/').trim());
            if (fileObject2 == null) {
                String string2 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                FileObject fileObject3 = fileObject;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    FileObject fileObject4 = fileObject.getFileObject(string2 = string2 + "/" + string3);
                    if (fileObject4 != null) {
                        fileObject3 = fileObject4;
                    }
                    if (fileObject4 != null) continue;
                    fileObject3 = fileObject2 = fileObject3.createFolder(string3);
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, null, exception);
        }
        return fileObject2;
    }

    protected FileObject createPackage(FileObject fileObject, String string) {
        Log.entry((String)"Entering function NBEventProcessor::createPackage");
        FileObject fileObject2 = fileObject;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                FileObject fileObject3 = fileObject2.getFileObject(string2);
                fileObject2 = fileObject3 == null || !fileObject3.isFolder() ? fileObject2.createFolder(string2) : fileObject3;
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, null, exception);
        }
        return fileObject2;
    }

    public static FileObject getSrcDirFileObject(ClassInfo classInfo) {
        String string = classInfo.getProject().getBaseDirectory();
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            logger.log(Level.WARNING, null, dataObjectNotFoundException);
        }
        Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        Project project2 = NBFileUtils.getAssociatedSourceProject(project);
        AssociatedSourceProvider associatedSourceProvider = (AssociatedSourceProvider)project.getLookup().lookup(AssociatedSourceProvider.class);
        SourceGroup[] sourceGroupArray = associatedSourceProvider.getSourceGroups();
        int n = 0;
        int n2 = 0;
        String string2 = classInfo.getPackage();
        SourceGroup sourceGroup = sourceGroupArray[0];
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            n2 = NBFileUtils.getNumberOfPackagesThatMatch(sourceGroupArray[i], string2);
            if (n2 <= n) continue;
            n = n2;
            sourceGroup = sourceGroupArray[i];
        }
        FileObject fileObject2 = sourceGroup.getRootFolder();
        return fileObject2;
    }

    private static int getNumberOfPackagesThatMatch(SourceGroup sourceGroup, String string) {
        int n = 0;
        FileObject fileObject = sourceGroup.getRootFolder();
        if (string != null && string.length() > 0) {
            String string2;
            FileObject fileObject2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens() && (fileObject2 = fileObject.getFileObject(string2 = stringTokenizer.nextToken())) != null) {
                ++n;
                fileObject = fileObject2;
            }
        }
        return n;
    }

    public static String getSimpleName(String string) {
        String string2 = string;
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static String getPackage(String string) {
        String string2 = "";
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getPackageForResource(String string) {
        String string2 = "";
        int n = string.lastIndexOf("/");
        if (n > 0) {
            string2 = string.substring(0, n);
            string2 = string2.replace("/", ".");
        }
        return string2;
    }

    public static String getSimpleNameForResource(String string) {
        int n = string.lastIndexOf("/");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        int n2 = string.indexOf(".java");
        string = string.substring(0, n2);
        return string;
    }

    public static class UnwritableFileException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnwritableFileException(String string) {
            super("The file '" + string + "' is unwritable.");
        }
    }
}

